/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.config;

import jakarta.faces.context.ExternalContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.myfaces.util.lang.ClassUtils;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ConfigFilesXmlValidationUtils {
    public static final LSResourceResolver LS_RESOURCE_RESOLVER = new ValidatorLSResourceResolver();
    public static final ErrorHandler VALIDATION_ERROR_HANDLER = new ValidationErrorHandler();
    private static final Logger log = Logger.getLogger(ConfigFilesXmlValidationUtils.class.getName());
    private static final String FACES_CONFIG_SCHEMA_PATH_12 = "org/apache/myfaces/resource/web-facesconfig_1_2.xsd";
    private static final String FACES_CONFIG_SCHEMA_PATH_20 = "org/apache/myfaces/resource/web-facesconfig_2_0.xsd";
    private static final String FACES_CONFIG_SCHEMA_PATH_21 = "org/apache/myfaces/resource/web-facesconfig_2_1.xsd";
    private static final String FACES_CONFIG_SCHEMA_PATH_22 = "org/apache/myfaces/resource/web-facesconfig_2_2.xsd";
    private static final String FACES_CONFIG_SCHEMA_PATH_23 = "org/apache/myfaces/resource/web-facesconfig_2_3.xsd";
    private static final String FACES_CONFIG_SCHEMA_PATH_30 = "org/apache/myfaces/resource/web-facesconfig_3_0.xsd";
    private static final String FACES_CONFIG_SCHEMA_PATH_40 = "org/apache/myfaces/resource/web-facesconfig_4_0.xsd";
    private static final String FACES_TAGLIB_SCHEMA_PATH = "org/apache/myfaces/resource/web-facelettaglibrary_2_0.xsd";

    public static void validateFacesConfigFile(URL xmlFile, ExternalContext externalContext, String version) throws SAXException, IOException {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Source schemaFile = ConfigFilesXmlValidationUtils.getFacesConfigSchemaFileAsSource(externalContext, version);
        if (schemaFile == null) {
            throw new IOException("Could not find schema file for validation.");
        }
        schemaFactory.setResourceResolver(LS_RESOURCE_RESOLVER);
        Schema schema = schemaFactory.newSchema(schemaFile);
        Validator validator = schema.newValidator();
        URLConnection conn = xmlFile.openConnection();
        conn.setUseCaches(false);
        try (InputStream is = conn.getInputStream();){
            StreamSource source = new StreamSource(is);
            validator.setErrorHandler(VALIDATION_ERROR_HANDLER);
            validator.validate(source);
        }
    }

    private static Source getFacesConfigSchemaFileAsSource(ExternalContext externalContext, String version) {
        String xmlSchema = "1.2".equals(version) ? FACES_CONFIG_SCHEMA_PATH_12 : ("2.0".equals(version) ? FACES_CONFIG_SCHEMA_PATH_20 : ("2.1".equals(version) ? FACES_CONFIG_SCHEMA_PATH_21 : ("2.2".equals(version) ? FACES_CONFIG_SCHEMA_PATH_22 : ("2.3".equals(version) ? FACES_CONFIG_SCHEMA_PATH_23 : ("3.0".equals(version) ? FACES_CONFIG_SCHEMA_PATH_30 : FACES_CONFIG_SCHEMA_PATH_40)))));
        InputStream stream = ClassUtils.getResourceAsStream((String)xmlSchema);
        if (stream == null) {
            stream = externalContext.getResourceAsStream(xmlSchema);
        }
        if (stream == null) {
            return null;
        }
        return new StreamSource(stream);
    }

    public static final String getFacesConfigVersion(URL url) {
        String result = "4.0";
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            FacesConfigVersionCheckHandler handler = new FacesConfigVersionCheckHandler();
            factory.setNamespaceAware(false);
            factory.setFeature("http://xml.org/sax/features/validation", false);
            factory.setValidating(false);
            try {
                factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
                factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
                factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                factory.setXIncludeAware(false);
            }
            catch (Throwable e) {
                log.log(Level.WARNING, "SAXParserFactory#setFeature not implemented. Skipping...", e);
            }
            SAXParser parser = factory.newSAXParser();
            URLConnection conn = url.openConnection();
            conn.setUseCaches(false);
            try (InputStream input = conn.getInputStream();){
                try {
                    parser.parse(input, (DefaultHandler)handler);
                }
                catch (SAXException sAXException) {
                    // empty catch block
                }
            }
            if (handler.isVersion11()) {
                return "1.1";
            }
            if (handler.isVersion12()) {
                return "1.2";
            }
            if (handler.isVersion20()) {
                return "2.0";
            }
            if (handler.isVersion21()) {
                return "2.1";
            }
            if (handler.isVersion22()) {
                return "2.2";
            }
            if (handler.isVersion23()) {
                return "2.3";
            }
            if (handler.isVersion30()) {
                return "3.0";
            }
            if (handler.isVersion40OrLater()) {
                return "4.0";
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return result;
    }

    public static void validateFaceletTagLibFile(URL xmlFile, ExternalContext externalContext, String version) throws SAXException, IOException, ParserConfigurationException {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Source schemaFile = ConfigFilesXmlValidationUtils.getFaceletSchemaFileAsSource(externalContext);
        if (schemaFile == null) {
            throw new IOException("Could not find schema file for validation.");
        }
        schemaFactory.setResourceResolver(LS_RESOURCE_RESOLVER);
        Schema schema = schemaFactory.newSchema(schemaFile);
        Validator validator = schema.newValidator();
        URLConnection conn = xmlFile.openConnection();
        conn.setUseCaches(false);
        try (InputStream is = conn.getInputStream();){
            StreamSource source = new StreamSource(is);
            validator.setErrorHandler(VALIDATION_ERROR_HANDLER);
            validator.validate(source);
        }
    }

    private static Source getFaceletSchemaFileAsSource(ExternalContext externalContext) {
        InputStream stream = ClassUtils.getResourceAsStream((String)FACES_TAGLIB_SCHEMA_PATH);
        if (stream == null) {
            stream = externalContext.getResourceAsStream(FACES_TAGLIB_SCHEMA_PATH);
        }
        if (stream == null) {
            return null;
        }
        return new StreamSource(stream);
    }

    public static final String getFaceletTagLibVersion(URL url) {
        if (ConfigFilesXmlValidationUtils.isTaglibDocument20OrLater(url)) {
            return "2.0";
        }
        return "1.0";
    }

    private static boolean isTaglibDocument20OrLater(URL url) {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            VersionCheckHandler handler = new VersionCheckHandler();
            factory.setNamespaceAware(false);
            factory.setFeature("http://xml.org/sax/features/validation", false);
            factory.setValidating(false);
            try {
                factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
                factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
                factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                factory.setXIncludeAware(false);
            }
            catch (Throwable e) {
                log.log(Level.WARNING, "SAXParserFactory#setFeature not implemented. Skipping...", e);
            }
            SAXParser parser = factory.newSAXParser();
            URLConnection conn = url.openConnection();
            conn.setUseCaches(false);
            try (InputStream input = conn.getInputStream();){
                try {
                    parser.parse(input, (DefaultHandler)handler);
                }
                catch (SAXException sAXException) {
                    // empty catch block
                }
            }
            return handler.isVersion20OrLater();
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private static class VersionCheckHandler
    extends DefaultHandler {
        private boolean version20OrLater;

        private VersionCheckHandler() {
        }

        public boolean isVersion20OrLater() {
            return this.version20OrLater;
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            if (name.equals("facelet-taglib")) {
                int length = attributes.getLength();
                for (int i = 0; i < length; ++i) {
                    String attrName = attributes.getLocalName(i);
                    String string = attrName != null ? (attrName.length() > 0 ? attrName : attributes.getQName(i)) : (attrName = attributes.getQName(i));
                    if (!attrName.equals("version")) continue;
                    this.version20OrLater = true;
                }
            }
        }
    }

    private static class FacesConfigVersionCheckHandler
    extends DefaultHandler {
        private boolean version11;
        private boolean version12;
        private boolean version20;
        private boolean version21;
        private boolean version22;
        private boolean version23;
        private boolean version30;
        private boolean version40OrLater;

        private FacesConfigVersionCheckHandler() {
        }

        public boolean isVersion11() {
            return this.version11;
        }

        public boolean isVersion12() {
            return this.version12;
        }

        public boolean isVersion20() {
            return this.version20;
        }

        public boolean isVersion21() {
            return this.version21;
        }

        public boolean isVersion22() {
            return this.version22;
        }

        public boolean isVersion23() {
            return this.version23;
        }

        public boolean isVersion30() {
            return this.version30;
        }

        public boolean isVersion40OrLater() {
            return this.version40OrLater;
        }

        protected void reset() {
            this.version11 = false;
            this.version12 = false;
            this.version20 = false;
            this.version21 = false;
            this.version22 = false;
            this.version23 = false;
            this.version30 = false;
            this.version40OrLater = false;
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            if (name.equals("faces-config")) {
                int length = attributes.getLength();
                for (int i = 0; i < length; ++i) {
                    String attrName = attributes.getLocalName(i);
                    String string = attrName != null ? (attrName.length() > 0 ? attrName : attributes.getQName(i)) : (attrName = attributes.getQName(i));
                    if (!attrName.equals("version")) continue;
                    if (attributes.getValue(i).equals("1.1")) {
                        this.reset();
                        this.version11 = true;
                        continue;
                    }
                    if (attributes.getValue(i).equals("1.2")) {
                        this.reset();
                        this.version12 = true;
                        continue;
                    }
                    if (attributes.getValue(i).equals("2.0")) {
                        this.reset();
                        this.version20 = true;
                        continue;
                    }
                    if (attributes.getValue(i).equals("2.1")) {
                        this.reset();
                        this.version21 = true;
                        continue;
                    }
                    if (attributes.getValue(i).equals("2.2")) {
                        this.reset();
                        this.version22 = true;
                        continue;
                    }
                    if (attributes.getValue(i).equals("2.3")) {
                        this.reset();
                        this.version23 = true;
                        continue;
                    }
                    if (attributes.getValue(i).equals("3.0")) {
                        this.reset();
                        this.version30 = true;
                        continue;
                    }
                    this.reset();
                    this.version40OrLater = true;
                }
            }
        }
    }

    public static class ValidationErrorHandler
    implements ErrorHandler {
        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            throw exception;
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            Logger log = Logger.getLogger(ConfigFilesXmlValidationUtils.class.getName());
            log.log(Level.SEVERE, exception.getMessage(), exception);
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            Logger log = Logger.getLogger(ConfigFilesXmlValidationUtils.class.getName());
            log.log(Level.WARNING, exception.getMessage(), exception);
        }
    }

    public static class ValidatorLSResourceResolver
    implements LSResourceResolver {
        @Override
        public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
            if ("http://www.w3.org/TR/REC-xml".equals(type) && "datatypes.dtd".equals(systemId)) {
                return new LSInputImpl(publicId, systemId, baseURI, ClassUtils.getResourceAsStream((String)"org/apache/myfaces/resource/datatypes.dtd"));
            }
            if ("-//W3C//DTD XMLSCHEMA 200102//EN".equals(publicId) && "XMLSchema.dtd".equals(systemId)) {
                return new LSInputImpl(publicId, systemId, baseURI, ClassUtils.getResourceAsStream((String)"org/apache/myfaces/resource/XMLSchema.dtd"));
            }
            if ("http://java.sun.com/xml/ns/javaee".equals(namespaceURI) && "javaee_5.xsd".equals(systemId)) {
                return new LSInputImpl(publicId, systemId, baseURI, ClassUtils.getResourceAsStream((String)"org/apache/myfaces/resource/javaee_5.xsd"));
            }
            if ("http://xmlns.jcp.org/xml/ns/javaee".equals(namespaceURI) && "javaee_7.xsd".equals(systemId)) {
                return new LSInputImpl(publicId, systemId, baseURI, ClassUtils.getResourceAsStream((String)"org/apache/myfaces/resource/javaee_7.xsd"));
            }
            if ("https://jakarta.ee/xml/ns/jakartaee".equals(namespaceURI)) {
                if ("jakartaee_9.xsd".equals(systemId)) {
                    return new LSInputImpl(publicId, systemId, baseURI, ClassUtils.getResourceAsStream((String)"org/apache/myfaces/resource/jakartaee_9.xsd"));
                }
                if ("jakartaee_10.xsd".equals(systemId)) {
                    return new LSInputImpl(publicId, systemId, baseURI, ClassUtils.getResourceAsStream((String)"org/apache/myfaces/resource/jakartaee_10.xsd"));
                }
            }
            if ("http://www.w3.org/XML/1998/namespace".equals(namespaceURI)) {
                return new LSInputImpl(publicId, systemId, baseURI, ClassUtils.getResourceAsStream((String)"org/apache/myfaces/resource/xml.xsd"));
            }
            return null;
        }
    }

    public static class LSInputImpl
    implements LSInput {
        private final String _publicId;
        private final String _systemId;
        private final String _baseURI;
        private final InputStream _input;

        public LSInputImpl(String publicId, String systemId, String baseURI, InputStream input) {
            this._publicId = publicId;
            this._systemId = systemId;
            this._baseURI = baseURI;
            this._input = input;
        }

        @Override
        public String getBaseURI() {
            return this._baseURI;
        }

        @Override
        public InputStream getByteStream() {
            return this._input;
        }

        @Override
        public boolean getCertifiedText() {
            return false;
        }

        @Override
        public Reader getCharacterStream() {
            return null;
        }

        @Override
        public String getEncoding() {
            return null;
        }

        @Override
        public String getPublicId() {
            return this._publicId;
        }

        @Override
        public String getStringData() {
            return null;
        }

        @Override
        public String getSystemId() {
            return this._systemId;
        }

        @Override
        public void setBaseURI(String baseURI) {
        }

        @Override
        public void setByteStream(InputStream byteStream) {
        }

        @Override
        public void setCertifiedText(boolean certifiedText) {
        }

        @Override
        public void setCharacterStream(Reader characterStream) {
        }

        @Override
        public void setEncoding(String encoding) {
        }

        @Override
        public void setPublicId(String publicId) {
        }

        @Override
        public void setStringData(String stringData) {
        }

        @Override
        public void setSystemId(String systemId) {
        }
    }
}

