/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.el;

import jakarta.el.ELContext;
import jakarta.el.ELResolver;
import jakarta.el.EvaluationListener;
import jakarta.el.FunctionMapper;
import jakarta.el.VariableMapper;
import jakarta.faces.context.FacesContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class FacesELContext
extends ELContext {
    private ELResolver _elResolver;
    private FunctionMapper _functionMapper;
    private VariableMapper _variableMapper;
    private List<EvaluationListener> listeners;

    public FacesELContext(ELResolver elResolver, FacesContext facesContext) {
        this._elResolver = elResolver;
        this.putContext(FacesContext.class, facesContext);
    }

    public VariableMapper getVariableMapper() {
        return this._variableMapper;
    }

    public void setVariableMapper(VariableMapper varMapper) {
        this._variableMapper = varMapper;
    }

    public FunctionMapper getFunctionMapper() {
        return this._functionMapper;
    }

    public void setFunctionMapper(FunctionMapper functionMapper) {
        this._functionMapper = functionMapper;
    }

    public ELResolver getELResolver() {
        return this._elResolver;
    }

    public void addEvaluationListener(EvaluationListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<EvaluationListener>();
        }
        this.listeners.add(listener);
    }

    public List<EvaluationListener> getEvaluationListeners() {
        return this.listeners == null ? Collections.emptyList() : this.listeners;
    }

    public void notifyBeforeEvaluation(String expression) {
        if (this.listeners == null) {
            return;
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            EvaluationListener listener = this.listeners.get(i);
            listener.beforeEvaluation((ELContext)this, expression);
        }
    }

    public void notifyAfterEvaluation(String expression) {
        if (this.listeners == null) {
            return;
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            EvaluationListener listener = this.listeners.get(i);
            listener.afterEvaluation((ELContext)this, expression);
        }
    }

    public void notifyPropertyResolved(Object base, Object property) {
        if (this.listeners == null) {
            return;
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            EvaluationListener listener = this.listeners.get(i);
            listener.propertyResolved((ELContext)this, base, property);
        }
    }
}

