/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.compiler;

import jakarta.el.ELException;
import jakarta.el.MethodExpression;
import jakarta.el.ValueExpression;
import jakarta.faces.FacesException;
import jakarta.faces.view.Location;
import jakarta.faces.view.facelets.FaceletException;
import jakarta.faces.view.facelets.Tag;
import jakarta.faces.view.facelets.TagAttribute;
import jakarta.faces.view.facelets.TagAttributes;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.myfaces.config.element.FaceletsProcessing;
import org.apache.myfaces.util.lang.ClassUtils;
import org.apache.myfaces.view.facelets.compiler.CompilationManager;
import org.apache.myfaces.view.facelets.compiler.Compiler;
import org.apache.myfaces.view.facelets.compiler.DynamicComponentFacelet;
import org.apache.myfaces.view.facelets.compiler.EncodingHandler;
import org.apache.myfaces.view.facelets.compiler.FaceletsProcessingInstructions;
import org.apache.myfaces.view.facelets.compiler.NamespaceHandler;
import org.apache.myfaces.view.facelets.tag.TagAttributeImpl;
import org.apache.myfaces.view.facelets.tag.TagAttributesImpl;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public final class SAXCompiler
extends Compiler {
    private static final Pattern XML_DECLARATION = Pattern.compile("^<\\?xml.+?version=['\"](.+?)['\"](.+?encoding=['\"]((.+?))['\"])?.*?\\?>");
    private static final List<String> SKIPPED_NAMESPACES = Arrays.asList("http://www.w3.org/1998/Math/MathML", "http://www.w3.org/2000/svg", "http://www.w3.org/1999/xlink");

    @Override
    public Compiler.CompilerResult doCompile(URL src, String alias) throws IOException, FaceletException, ELException, FacesException {
        CompilationManager mngr = null;
        String encoding = null;
        try (InputStream is = null;){
            is = new BufferedInputStream(src.openStream(), 1024);
            mngr = new CompilationManager(alias, this, this.getFaceletsProcessingInstructions(src, alias));
            encoding = SAXCompiler.writeXmlDecl(is, mngr);
            CompilationHandler handler = new CompilationHandler(mngr, alias);
            SAXParser parser = this.createSAXParser(handler);
            parser.parse(is, (DefaultHandler)handler);
        }
        return new Compiler.CompilerResult(new EncodingHandler(mngr.createFaceletHandler(), encoding), mngr.getDoctype());
    }

    @Override
    protected Compiler.CompilerResult doCompileViewMetadata(URL src, String alias) throws IOException, FaceletException, ELException, FacesException {
        String encoding;
        CompilationManager mngr;
        block12: {
            mngr = null;
            encoding = null;
            try (InputStream is = null;){
                is = new BufferedInputStream(src.openStream(), 1024);
                mngr = new CompilationManager(alias, this, this.getFaceletsProcessingInstructions(src, alias));
                encoding = SAXCompiler.getXmlDecl(is, mngr);
                ViewMetadataHandler handler = new ViewMetadataHandler(mngr, alias);
                SAXParser parser = this.createSAXParser(handler);
                if (System.getSecurityManager() != null) {
                    try {
                        InputStream finalInputStream = is;
                        AccessController.doPrivileged(() -> {
                            parser.parse(finalInputStream, (DefaultHandler)handler);
                            return null;
                        });
                        break block12;
                    }
                    catch (PrivilegedActionException pae) {
                        Exception e = pae.getException();
                        if (e instanceof SAXException) {
                            throw new FaceletException("Error Parsing " + alias + ": " + e.getMessage(), e.getCause());
                        }
                        if (e instanceof IOException) {
                            throw (IOException)e;
                        }
                        break block12;
                    }
                }
                parser.parse(is, (DefaultHandler)handler);
            }
        }
        return new Compiler.CompilerResult(new EncodingHandler(mngr.createFaceletHandler(), encoding), mngr.getDoctype());
    }

    @Override
    protected Compiler.CompilerResult doCompileCompositeComponentMetadata(URL src, String alias) throws IOException, FaceletException, ELException, FacesException {
        CompilationManager mngr = null;
        String encoding = null;
        try (InputStream is = null;){
            is = new BufferedInputStream(src.openStream(), 1024);
            mngr = new CompilationManager(alias, this, this.getFaceletsProcessingInstructions(src, alias));
            encoding = SAXCompiler.getXmlDecl(is, mngr);
            CompositeComponentMetadataHandler handler = new CompositeComponentMetadataHandler(mngr, alias);
            SAXParser parser = this.createSAXParser(handler);
            parser.parse(is, (DefaultHandler)handler);
        }
        return new Compiler.CompilerResult(new EncodingHandler(mngr.createFaceletHandler(), encoding), mngr.getDoctype());
    }

    @Override
    protected Compiler.CompilerResult doCompileComponent(String taglibURI, String tagName, Map<String, Object> attributes) {
        String alias = tagName;
        CompilationManager mngr = new CompilationManager(alias, this, this.getDefaultFaceletsProcessingInstructions());
        String prefix = "oamf";
        mngr.pushNamespace(prefix, taglibURI);
        boolean tagContainParams = !(!"include".equals(tagName) && !"decorate".equals(tagName) && !"composition".equals(tagName) || !"jakarta.faces.facelets".equals(taglibURI) && !"http://xmlns.jcp.org/jsf/facelets".equals(taglibURI) && !"http://java.sun.com/jsf/facelets".equals(taglibURI));
        Location location = new Location(alias, 0, 0);
        int len = attributes.size();
        if (tagContainParams && attributes.containsKey("params")) {
            --len;
        }
        TagAttribute[] ta = new TagAttribute[len];
        int i = 0;
        Map paramsMap = null;
        for (Map.Entry<String, Object> entry : attributes.entrySet()) {
            String stringValue = null;
            if (tagContainParams && "params".equals(entry.getKey())) {
                paramsMap = (Map)entry.getValue();
                continue;
            }
            if (entry.getValue() instanceof ValueExpression) {
                stringValue = ((ValueExpression)entry.getValue()).getExpressionString();
            } else if (entry.getValue() instanceof MethodExpression) {
                stringValue = ((MethodExpression)entry.getValue()).getExpressionString();
            } else if (entry.getValue() != null) {
                stringValue = entry.getValue().toString();
            }
            ta[i] = new TagAttributeImpl(location, "", entry.getKey(), entry.getKey(), stringValue);
            ++i;
        }
        mngr.pushTag(new Tag(location, taglibURI, tagName, "oamf:" + tagName, (TagAttributes)new TagAttributesImpl(ta)));
        if (tagContainParams && paramsMap != null) {
            for (Map.Entry<String, Object> entry : paramsMap.entrySet()) {
                TagAttribute[] tap = new TagAttribute[2];
                String stringValue = null;
                if (entry.getValue() instanceof ValueExpression) {
                    stringValue = ((ValueExpression)entry.getValue()).getExpressionString();
                } else if (entry.getValue() instanceof MethodExpression) {
                    stringValue = ((MethodExpression)entry.getValue()).getExpressionString();
                } else if (entry.getValue() != null) {
                    stringValue = entry.getValue().toString();
                }
                tap[0] = new TagAttributeImpl(location, "", "name", "name", entry.getKey());
                tap[1] = new TagAttributeImpl(location, "", "value", "value", stringValue);
                mngr.pushTag(new Tag(location, "jakarta.faces.facelets", "param", "oamf:param", (TagAttributes)new TagAttributesImpl(tap)));
                mngr.popTag();
            }
        }
        mngr.popTag();
        mngr.popNamespace(prefix);
        DynamicComponentFacelet handler = new DynamicComponentFacelet((NamespaceHandler)mngr.createFaceletHandler());
        return new Compiler.CompilerResult(handler, mngr.getDoctype());
    }

    protected FaceletsProcessingInstructions getDefaultFaceletsProcessingInstructions() {
        return FaceletsProcessingInstructions.getProcessingInstructions("xhtml", false);
    }

    protected FaceletsProcessingInstructions getFaceletsProcessingInstructions(URL src, String alias) {
        String processAs = null;
        boolean compressSpaces = false;
        for (FaceletsProcessing entry : this.getFaceletsProcessingConfigurations()) {
            if (!src.getPath().endsWith(entry.getFileExtension())) continue;
            processAs = entry.getProcessAs();
            compressSpaces = Boolean.valueOf(entry.getOamCompressSpaces());
            break;
        }
        return FaceletsProcessingInstructions.getProcessingInstructions(processAs, compressSpaces);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String writeXmlDecl(InputStream is, CompilationManager mngr) throws IOException {
        is.mark(128);
        String encoding = null;
        try {
            String r;
            Matcher m;
            byte[] b = new byte[128];
            if (is.read(b) > 0 && (m = XML_DECLARATION.matcher(r = new String(b))).find()) {
                if (!mngr.getFaceletsProcessingInstructions().isConsumeXmlDeclaration()) {
                    mngr.writeInstruction(m.group(0) + "\n", null);
                }
                if (m.group(3) != null) {
                    encoding = m.group(3);
                }
            }
        }
        finally {
            is.reset();
        }
        return encoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String getXmlDecl(InputStream is, CompilationManager mngr) throws IOException {
        is.mark(128);
        String encoding = null;
        try {
            String r;
            Matcher m;
            byte[] b = new byte[128];
            if (is.read(b) > 0 && (m = XML_DECLARATION.matcher(r = new String(b))).find() && m.group(3) != null) {
                encoding = m.group(3);
            }
        }
        finally {
            is.reset();
        }
        return encoding;
    }

    private SAXParser createSAXParser(DefaultHandler handler) throws SAXException, ParserConfigurationException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        factory.setValidating(this.isValidating());
        factory.setFeature("http://xml.org/sax/features/validation", this.isValidating());
        SAXParser parser = factory.newSAXParser();
        XMLReader reader = parser.getXMLReader();
        reader.setProperty("http://xml.org/sax/properties/lexical-handler", handler);
        reader.setErrorHandler(handler);
        reader.setEntityResolver(handler);
        return parser;
    }

    private static class CompositeComponentMetadataHandler
    extends DefaultHandler
    implements LexicalHandler {
        private final String alias;
        private boolean inDocument = false;
        private Locator locator;
        private final CompilationManager unit;
        private boolean inCompositeInterface = false;
        private boolean inCompositeImplementation = false;
        private boolean consumingCDATA = false;
        private boolean swallowCDATAContent = false;

        public CompositeComponentMetadataHandler(CompilationManager unit, String alias) {
            this.unit = unit;
            this.alias = alias;
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.inDocument && this.inCompositeInterface && (!this.consumingCDATA || this.consumingCDATA && !this.swallowCDATAContent)) {
                this.unit.writeText(new String(ch, start, length), this.createLocation());
            }
        }

        @Override
        public void comment(char[] ch, int start, int length) throws SAXException {
            if (this.inDocument && this.inCompositeInterface && !this.unit.getFaceletsProcessingInstructions().isConsumeXMLComments()) {
                this.unit.writeComment(new String(ch, start, length), this.createLocation());
            }
        }

        protected TagAttributes createAttributes(Attributes attrs) {
            int len = attrs.getLength();
            TagAttribute[] ta = new TagAttribute[len];
            for (int i = 0; i < len; ++i) {
                ta[i] = new TagAttributeImpl(this.createLocation(), attrs.getURI(i), attrs.getLocalName(i), attrs.getQName(i), attrs.getValue(i));
            }
            return new TagAttributesImpl(ta);
        }

        protected Location createLocation() {
            return new Location(this.alias, this.locator.getLineNumber(), this.locator.getColumnNumber());
        }

        @Override
        public void endCDATA() throws SAXException {
            if (this.inDocument && this.inCompositeInterface) {
                if (!this.unit.getFaceletsProcessingInstructions().isConsumeCDataSections()) {
                    this.unit.writeInstruction("]]>", this.createLocation());
                } else {
                    this.consumingCDATA = false;
                    this.swallowCDATAContent = false;
                }
            }
        }

        @Override
        public void endDTD() throws SAXException {
            this.inDocument = true;
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.inCompositeInterface) {
                this.unit.popTag();
            } else if (this.inCompositeImplementation && ("jakarta.faces.composite".equals(uri) || "http://xmlns.jcp.org/jsf/composite".equals(uri) || "http://java.sun.com/jsf/composite".equals(uri)) && ("insertFacet".equals(localName) || "renderFacet".equals(localName) || "insertChildren".equals(localName) || "implementation".equals(localName))) {
                this.unit.popTag();
            }
            if ("jakarta.faces.composite".equals(uri) || "http://xmlns.jcp.org/jsf/composite".equals(uri) || "http://java.sun.com/jsf/composite".equals(uri)) {
                if ("interface".equals(localName)) {
                    this.inCompositeInterface = false;
                } else if ("implementation".equals(localName)) {
                    this.inCompositeImplementation = false;
                }
            }
        }

        @Override
        public void endEntity(String name) throws SAXException {
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
            this.unit.popNamespace(prefix);
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            if (this.locator != null) {
                throw new SAXException("Error Traced[line: " + this.locator.getLineNumber() + "] " + e.getMessage());
            }
            throw e;
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            if (this.inDocument && this.inCompositeInterface) {
                this.unit.writeWhitespace(new String(ch, start, length), this.createLocation());
            }
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
            String dtd = "org/apache/myfaces/resource/default.dtd";
            URL url = ClassUtils.getResource((String)dtd);
            return new InputSource(url.toString());
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        @Override
        public void startCDATA() throws SAXException {
            if (this.inDocument && this.inCompositeInterface) {
                if (!this.unit.getFaceletsProcessingInstructions().isConsumeCDataSections()) {
                    this.unit.writeInstruction("<![CDATA[", this.createLocation());
                } else {
                    this.consumingCDATA = true;
                    this.swallowCDATAContent = this.unit.getFaceletsProcessingInstructions().isSwallowCDataContent();
                }
            }
        }

        @Override
        public void startDocument() throws SAXException {
            this.inDocument = true;
        }

        @Override
        public void startDTD(String name, String publicId, String systemId) throws SAXException {
            this.inDocument = false;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if ("jakarta.faces.composite".equals(uri) || "http://xmlns.jcp.org/jsf/composite".equals(uri) || "http://java.sun.com/jsf/composite".equals(uri)) {
                if ("interface".equals(localName)) {
                    this.inCompositeInterface = true;
                } else if ("implementation".equals(localName)) {
                    this.inCompositeImplementation = true;
                }
            }
            if (this.inCompositeInterface) {
                this.unit.pushTag(new Tag(this.createLocation(), uri, localName, qName, this.createAttributes(attributes)));
            } else if (this.inCompositeImplementation && ("jakarta.faces.composite".equals(uri) || "http://xmlns.jcp.org/jsf/composite".equals(uri) || "http://java.sun.com/jsf/composite".equals(uri)) && ("insertFacet".equals(localName) || "renderFacet".equals(localName) || "insertChildren".equals(localName) || "implementation".equals(localName))) {
                this.unit.pushTag(new Tag(this.createLocation(), uri, localName, qName, this.createAttributes(attributes)));
            }
        }

        @Override
        public void startEntity(String name) throws SAXException {
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            this.unit.pushNamespace(prefix, uri);
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
            if (this.inDocument && this.inCompositeInterface && !this.unit.getFaceletsProcessingInstructions().isConsumeProcessingInstructions()) {
                StringBuilder sb = new StringBuilder(64);
                sb.append("<?").append(target).append(' ').append(data).append("?>\n");
                this.unit.writeInstruction(sb.toString(), this.createLocation());
            }
        }
    }

    private static class ViewMetadataHandler
    extends DefaultHandler
    implements LexicalHandler {
        private final String alias;
        private boolean inDocument = false;
        private Locator locator;
        private final CompilationManager unit;
        private boolean inMetadata = false;
        private int uiRemoveCount = 0;
        private boolean consumingCDATA = false;
        private boolean swallowCDATAContent = false;

        public ViewMetadataHandler(CompilationManager unit, String alias) {
            this.unit = unit;
            this.alias = alias;
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.inDocument && this.inMetadata && (!this.consumingCDATA || this.consumingCDATA && !this.swallowCDATAContent)) {
                this.unit.writeText(new String(ch, start, length), this.createLocation());
            }
        }

        @Override
        public void comment(char[] ch, int start, int length) throws SAXException {
            if (this.inDocument && this.inMetadata && !this.unit.getFaceletsProcessingInstructions().isConsumeXMLComments()) {
                this.unit.writeComment(new String(ch, start, length), this.createLocation());
            }
        }

        protected TagAttributes createAttributes(Attributes attrs) {
            int len = attrs.getLength();
            TagAttribute[] ta = new TagAttribute[len];
            for (int i = 0; i < len; ++i) {
                ta[i] = new TagAttributeImpl(this.createLocation(), attrs.getURI(i), attrs.getLocalName(i), attrs.getQName(i), attrs.getValue(i));
            }
            return new TagAttributesImpl(ta);
        }

        protected Location createLocation() {
            return new Location(this.alias, this.locator.getLineNumber(), this.locator.getColumnNumber());
        }

        @Override
        public void endCDATA() throws SAXException {
            if (this.inDocument && this.inMetadata) {
                if (!this.unit.getFaceletsProcessingInstructions().isConsumeCDataSections()) {
                    this.unit.writeInstruction("]]>", this.createLocation());
                } else {
                    this.consumingCDATA = false;
                    this.swallowCDATAContent = false;
                }
            }
        }

        @Override
        public void endDTD() throws SAXException {
            this.inDocument = true;
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.inMetadata) {
                this.unit.popTag();
            }
            if ("jakarta.faces.core".equals(uri) || "http://xmlns.jcp.org/jsf/core".equals(uri) || "http://java.sun.com/jsf/core".equals(uri)) {
                if ("metadata".equals(localName)) {
                    this.inMetadata = false;
                } else if (!this.inMetadata && "view".equals(localName)) {
                    this.unit.popTag();
                }
            } else if (("jakarta.faces.facelets".equals(uri) || "http://xmlns.jcp.org/jsf/facelets".equals(uri) || "http://java.sun.com/jsf/facelets".equals(uri)) && !this.inMetadata && "remove".equals(localName)) {
                --this.uiRemoveCount;
            }
        }

        @Override
        public void endEntity(String name) throws SAXException {
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
            this.unit.popNamespace(prefix);
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            if (this.locator != null) {
                throw new SAXException("Error Traced[line: " + this.locator.getLineNumber() + "] " + e.getMessage());
            }
            throw e;
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            if (this.inDocument && this.inMetadata) {
                this.unit.writeWhitespace(new String(ch, start, length), this.createLocation());
            }
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
            String dtd = "org/apache/myfaces/resource/default.dtd";
            URL url = ClassUtils.getResource((String)dtd);
            return new InputSource(url.toString());
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        @Override
        public void startCDATA() throws SAXException {
            if (this.inDocument && this.inMetadata) {
                if (!this.unit.getFaceletsProcessingInstructions().isConsumeCDataSections()) {
                    this.unit.writeInstruction("<![CDATA[", this.createLocation());
                } else {
                    this.consumingCDATA = true;
                    this.swallowCDATAContent = this.unit.getFaceletsProcessingInstructions().isSwallowCDataContent();
                }
            }
        }

        @Override
        public void startDocument() throws SAXException {
            this.inDocument = true;
        }

        @Override
        public void startDTD(String name, String publicId, String systemId) throws SAXException {
            this.inDocument = false;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (this.uiRemoveCount <= 0 && ("jakarta.faces.core".equals(uri) || "http://xmlns.jcp.org/jsf/core".equals(uri) || "http://java.sun.com/jsf/core".equals(uri))) {
                if ("metadata".equals(localName)) {
                    this.inMetadata = true;
                } else if (!this.inMetadata && "view".equals(localName)) {
                    this.unit.pushTag(new Tag(this.createLocation(), uri, localName, qName, this.createAttributes(attributes)));
                }
            }
            if (this.inMetadata) {
                this.unit.pushTag(new Tag(this.createLocation(), uri, localName, qName, this.createAttributes(attributes)));
            } else if (("jakarta.faces.facelets".equals(uri) || "http://xmlns.jcp.org/jsf/facelets".equals(uri) || "http://java.sun.com/jsf/facelets".equals(uri)) && "remove".equals(localName)) {
                ++this.uiRemoveCount;
            }
        }

        @Override
        public void startEntity(String name) throws SAXException {
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            this.unit.pushNamespace(prefix, uri);
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
            if (this.inDocument && this.inMetadata && !this.unit.getFaceletsProcessingInstructions().isConsumeProcessingInstructions()) {
                StringBuilder sb = new StringBuilder(64);
                sb.append("<?").append(target).append(' ').append(data).append("?>\n");
                this.unit.writeInstruction(sb.toString(), this.createLocation());
            }
        }
    }

    private static class CompilationHandler
    extends DefaultHandler
    implements LexicalHandler {
        private final String alias;
        private boolean inDocument = false;
        private Locator locator;
        private final CompilationManager unit;
        private boolean consumingCDATA = false;
        private boolean swallowCDATAContent = false;

        public CompilationHandler(CompilationManager unit, String alias) {
            this.unit = unit;
            this.alias = alias;
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.inDocument && (!this.consumingCDATA || this.consumingCDATA && !this.swallowCDATAContent)) {
                this.unit.writeText(new String(ch, start, length), this.createLocation());
            }
        }

        @Override
        public void comment(char[] ch, int start, int length) throws SAXException {
            if (this.inDocument && !this.unit.getFaceletsProcessingInstructions().isConsumeXMLComments()) {
                this.unit.writeComment(new String(ch, start, length), this.createLocation());
            }
        }

        protected TagAttributes createAttributes(Attributes attrs) {
            int len = attrs.getLength();
            TagAttribute[] ta = new TagAttribute[len];
            for (int i = 0; i < len; ++i) {
                ta[i] = new TagAttributeImpl(this.createLocation(), attrs.getURI(i), attrs.getLocalName(i), attrs.getQName(i), attrs.getValue(i));
            }
            return new TagAttributesImpl(ta);
        }

        protected Location createLocation() {
            return new Location(this.alias, this.locator.getLineNumber(), this.locator.getColumnNumber());
        }

        @Override
        public void endCDATA() throws SAXException {
            if (this.inDocument) {
                if (!this.unit.getFaceletsProcessingInstructions().isConsumeCDataSections()) {
                    this.unit.writeInstruction("]]>", this.createLocation());
                } else {
                    this.consumingCDATA = false;
                    this.swallowCDATAContent = false;
                }
            }
        }

        @Override
        public void endDTD() throws SAXException {
            this.inDocument = true;
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.unit.popTag();
        }

        @Override
        public void endEntity(String name) throws SAXException {
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
            this.unit.popNamespace(prefix);
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            if (this.locator != null) {
                throw new SAXException("Error Traced[line: " + this.locator.getLineNumber() + "] " + e.getMessage());
            }
            throw e;
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            if (this.inDocument) {
                this.unit.writeWhitespace(new String(ch, start, length), this.createLocation());
            }
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
            String dtd = "org/apache/myfaces/resource/default.dtd";
            URL url = ClassUtils.getResource((String)dtd);
            return new InputSource(url.toString());
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        @Override
        public void startCDATA() throws SAXException {
            if (this.inDocument) {
                if (!this.unit.getFaceletsProcessingInstructions().isConsumeCDataSections()) {
                    this.unit.writeInstruction("<![CDATA[", this.createLocation());
                } else {
                    this.consumingCDATA = true;
                    this.swallowCDATAContent = this.unit.getFaceletsProcessingInstructions().isSwallowCDataContent();
                }
            }
        }

        @Override
        public void startDocument() throws SAXException {
            this.inDocument = true;
        }

        @Override
        public void startDTD(String name, String publicId, String systemId) throws SAXException {
            if (this.inDocument && !this.unit.getFaceletsProcessingInstructions().isConsumeXmlDocType()) {
                this.unit.writeDoctype(name, publicId, systemId);
            }
            this.inDocument = false;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.unit.pushTag(new Tag(this.createLocation(), uri, localName, qName, this.createAttributes(attributes)));
        }

        @Override
        public void startEntity(String name) throws SAXException {
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            if (!SKIPPED_NAMESPACES.contains(uri)) {
                this.unit.pushNamespace(prefix, uri);
            }
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
            if (this.inDocument && !this.unit.getFaceletsProcessingInstructions().isConsumeProcessingInstructions()) {
                StringBuilder sb = new StringBuilder(64);
                sb.append("<?").append(target).append(' ').append(data).append("?>\n");
                this.unit.writeInstruction(sb.toString(), this.createLocation());
            }
        }
    }
}

