/*
 * Decompiled with CFR 0.152.
 */
package jakarta.faces.component;

import jakarta.el.ELException;
import jakarta.el.ValueExpression;
import jakarta.faces.FacesException;
import jakarta.faces.application.Resource;
import jakarta.faces.component.ContextCallback;
import jakarta.faces.component.NamingContainer;
import jakarta.faces.component.PartialStateHolder;
import jakarta.faces.component.StateHelper;
import jakarta.faces.component.TransientStateHelper;
import jakarta.faces.component.TransientStateHolder;
import jakarta.faces.component._BundleMap;
import jakarta.faces.component._DeltaList;
import jakarta.faces.component._DeltaStateHelper;
import jakarta.faces.component._EventListenerWrapper;
import jakarta.faces.component.visit.VisitCallback;
import jakarta.faces.component.visit.VisitContext;
import jakarta.faces.component.visit.VisitHint;
import jakarta.faces.component.visit.VisitResult;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.AbortProcessingException;
import jakarta.faces.event.ComponentSystemEvent;
import jakarta.faces.event.ComponentSystemEventListener;
import jakarta.faces.event.FacesEvent;
import jakarta.faces.event.FacesListener;
import jakarta.faces.event.PostRestoreStateEvent;
import jakarta.faces.event.SystemEvent;
import jakarta.faces.event.SystemEventListener;
import jakarta.faces.event.SystemEventListenerHolder;
import jakarta.faces.render.Renderer;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.myfaces.core.api.shared.lang.Assert;
import org.apache.myfaces.core.api.shared.lang.ClassUtils;

public abstract class UIComponent
implements PartialStateHolder,
TransientStateHolder,
SystemEventListenerHolder,
ComponentSystemEventListener {
    public static final String BEANINFO_KEY = "jakarta.faces.component.BEANINFO_KEY";
    public static final String COMPOSITE_COMPONENT_TYPE_KEY = "jakarta.faces.component.COMPOSITE_COMPONENT_TYPE";
    public static final String COMPOSITE_FACET_NAME = "jakarta.faces.component.COMPOSITE_FACET_NAME";
    public static final String FACETS_KEY = "jakarta.faces.component.FACETS_KEY";
    public static final String VIEW_LOCATION_KEY = "jakarta.faces.component.VIEW_LOCATION_KEY";
    public static final String ATTRS_WITH_DECLARED_DEFAULT_VALUES = "jakarta.faces.component.ATTR_NAMES_WITH_DEFAULT_VALUES";
    private static final String _COMPONENT_STACK = "componentStack:" + UIComponent.class.getName();
    private static final String _CURRENT_COMPOSITE_COMPONENT_KEY = "compositeComponent:" + UIComponent.class.getName();
    Map<Class<? extends SystemEvent>, List<SystemEventListener>> _systemEventListenerClassMap;
    private transient Map<String, String> _resourceBundleMap = null;
    private boolean _inView = false;
    private _DeltaStateHelper _stateHelper = null;
    private boolean _initialStateMarked = false;

    public abstract Map<String, Object> getAttributes();

    public Map<String, Object> getPassThroughAttributes() {
        return this.getPassThroughAttributes(true);
    }

    public Map<String, Object> getPassThroughAttributes(boolean create) {
        return Collections.emptyMap();
    }

    @Override
    public boolean initialStateMarked() {
        return this._initialStateMarked;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean invokeOnComponent(FacesContext context, String clientId, ContextCallback callback) throws FacesException {
        Assert.notNull(context, "context");
        Assert.notNull(clientId, "clientId");
        Assert.notNull(callback, "callback");
        this.pushComponentToEL(context, this);
        try {
            boolean found = clientId.equals(this.getClientId(context));
            if (found) {
                try {
                    callback.invokeContextCallback(context, this);
                }
                catch (Exception e) {
                    throw new FacesException(e);
                }
                boolean e = found;
                return e;
            }
            if (this.getFacetCount() > 0) {
                Iterator<UIComponent> it = this.getFacets().values().iterator();
                while (!found && it.hasNext()) {
                    found = it.next().invokeOnComponent(context, clientId, callback);
                }
            }
            if (this.getChildCount() > 0) {
                int childCount = this.getChildCount();
                for (int i = 0; !found && i < childCount; ++i) {
                    UIComponent child = this.getChildren().get(i);
                    found = child.invokeOnComponent(context, clientId, callback);
                }
            }
            boolean bl = found;
            return bl;
        }
        finally {
            this.popComponentFromEL(context);
        }
    }

    public static boolean isCompositeComponent(UIComponent component) {
        return component.getAttributes().containsKey("jakarta.faces.application.Resource.ComponentResource");
    }

    public boolean isInView() {
        return this._inView;
    }

    public abstract boolean isRendered();

    @Override
    public void markInitialState() {
        this._initialStateMarked = true;
    }

    protected boolean isVisitable(VisitContext context) {
        Set<VisitHint> hints = context.getHints();
        if (hints.contains((Object)VisitHint.SKIP_TRANSIENT) && this.isTransient()) {
            return false;
        }
        return !hints.contains((Object)VisitHint.SKIP_UNRENDERED) || this.isRendered();
    }

    public void setValueExpression(String name, ValueExpression expression) {
        Assert.notNull(name, "name");
        if (name.equals("id")) {
            throw new IllegalArgumentException("Can't set a ValueExpression for the 'id' property.");
        }
        if (name.equals("parent")) {
            throw new IllegalArgumentException("Can't set a ValueExpression for the 'parent' property.");
        }
        if (expression == null) {
            this.getStateHelper().remove((Serializable)((Object)PropertyKeys.bindings), name);
        } else {
            if (expression.isLiteralText()) {
                try {
                    Object value = expression.getValue(this.getFacesContext().getELContext());
                    this.getAttributes().put(name, value);
                    return;
                }
                catch (ELException e) {
                    throw new FacesException(e);
                }
            }
            this.getStateHelper().put((Serializable)((Object)PropertyKeys.bindings), name, expression);
        }
    }

    public String getClientId() {
        return this.getClientId(this.getFacesContext());
    }

    public abstract String getClientId(FacesContext var1);

    public static UIComponent getCompositeComponentParent(UIComponent component) {
        if (component == null) {
            return null;
        }
        UIComponent parent = component;
        do {
            if ((parent = parent.getParent()) == null || !UIComponent.isCompositeComponent(parent)) continue;
            return parent;
        } while (parent != null);
        return null;
    }

    public String getContainerClientId(FacesContext ctx) {
        Assert.notNull(ctx, "ctx");
        return this.getClientId(ctx);
    }

    public static UIComponent getCurrentComponent(FacesContext context) {
        List componentStack = (List)context.getAttributes().get(_COMPONENT_STACK);
        if (componentStack != null && !componentStack.isEmpty()) {
            return (UIComponent)componentStack.get(componentStack.size() - 1);
        }
        return null;
    }

    public static UIComponent getCurrentCompositeComponent(FacesContext context) {
        return (UIComponent)context.getAttributes().get(_CURRENT_COMPOSITE_COMPONENT_KEY);
    }

    public abstract String getFamily();

    public abstract String getId();

    @Override
    public List<SystemEventListener> getListenersForEventClass(Class<? extends SystemEvent> eventClass) {
        List<Object> listeners;
        listeners = this._systemEventListenerClassMap == null ? Collections.emptyList() : ((listeners = this._systemEventListenerClassMap.get(eventClass)) == null ? Collections.emptyList() : Collections.unmodifiableList(listeners));
        return listeners;
    }

    public UIComponent getNamingContainer() {
        UIComponent component = this;
        do {
            if (!(component instanceof NamingContainer)) continue;
            return component;
        } while ((component = component.getParent()) != null);
        return null;
    }

    public abstract void setId(String var1);

    public void setInView(boolean isInView) {
        this._inView = isInView;
    }

    public abstract void setParent(UIComponent var1);

    public abstract UIComponent getParent();

    public abstract void setRendered(boolean var1);

    public abstract String getRendererType();

    public abstract void setRendererType(String var1);

    public abstract boolean getRendersChildren();

    public Map<String, String> getResourceBundleMap() {
        block7: {
            if (this._resourceBundleMap == null) {
                FacesContext context = this.getFacesContext();
                Locale locale = context.getViewRoot().getLocale();
                ClassLoader loader = ClassUtils.getContextClassLoader();
                try {
                    ResourceBundle.Control bundleControl = (ResourceBundle.Control)context.getExternalContext().getApplicationMap().get("org.apache.myfaces.RESOURCE_BUNDLE_CONTROL");
                    this._resourceBundleMap = bundleControl == null ? new _BundleMap(ResourceBundle.getBundle(this.getClass().getName(), locale, loader)) : new _BundleMap(ResourceBundle.getBundle(this.getClass().getName(), locale, loader, bundleControl));
                }
                catch (MissingResourceException e) {
                    if (this._isCompositeComponent()) {
                        Resource componentResource = (Resource)this.getAttributes().get("jakarta.faces.application.Resource.ComponentResource");
                        int extensionIndex = componentResource.getResourceName().lastIndexOf(46);
                        String resourceName = (extensionIndex < 0 ? componentResource.getResourceName() : componentResource.getResourceName().substring(0, extensionIndex)) + ".properties";
                        Resource bundleResource = context.getApplication().getResourceHandler().createResource(resourceName, componentResource.getLibraryName());
                        if (bundleResource != null) {
                            try {
                                this._resourceBundleMap = new _BundleMap(new PropertyResourceBundle(bundleResource.getInputStream()));
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    }
                    if (this._resourceBundleMap != null) break block7;
                    this._resourceBundleMap = Collections.emptyMap();
                }
            }
        }
        return this._resourceBundleMap;
    }

    public ValueExpression getValueExpression(String name) {
        Assert.notNull(name, "name");
        Map bindings = (Map)this.getStateHelper().get((Serializable)((Object)PropertyKeys.bindings));
        if (bindings != null) {
            return (ValueExpression)bindings.get(name);
        }
        return null;
    }

    public abstract List<UIComponent> getChildren();

    public abstract int getChildCount();

    public abstract UIComponent findComponent(String var1);

    public abstract Map<String, UIComponent> getFacets();

    public abstract UIComponent getFacet(String var1);

    public abstract Iterator<UIComponent> getFacetsAndChildren();

    public abstract void broadcast(FacesEvent var1) throws AbortProcessingException;

    @Override
    public void clearInitialState() {
        this._initialStateMarked = false;
    }

    public abstract void decode(FacesContext var1);

    public abstract void encodeBegin(FacesContext var1) throws IOException;

    public abstract void encodeChildren(FacesContext var1) throws IOException;

    public abstract void encodeEnd(FacesContext var1) throws IOException;

    public void encodeAll(FacesContext context) throws IOException {
        Assert.notNull(context, "context");
        this.pushComponentToEL(context, this);
        try {
            if (!this.isRendered()) {
                return;
            }
        }
        finally {
            this.popComponentFromEL(context);
        }
        this.encodeBegin(context);
        if (this.getRendersChildren()) {
            this.encodeChildren(context);
        } else if (this.getChildCount() > 0) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                UIComponent comp = this.getChildren().get(i);
                comp.encodeAll(context);
            }
        }
        this.encodeEnd(context);
    }

    protected abstract void addFacesListener(FacesListener var1);

    protected abstract FacesListener[] getFacesListeners(Class var1);

    protected abstract void removeFacesListener(FacesListener var1);

    public abstract void queueEvent(FacesEvent var1);

    public abstract void processRestoreState(FacesContext var1, Object var2);

    public abstract void processDecodes(FacesContext var1);

    @Override
    public void processEvent(ComponentSystemEvent event) throws AbortProcessingException {
        if (event instanceof PostRestoreStateEvent) {
            List<SystemEventListener> listeners;
            ValueExpression expression = this.getValueExpression("binding");
            if (expression != null) {
                expression.setValue(this.getFacesContext().getELContext(), (Object)this);
            }
            if (!(listeners = this.getListenersForEventClass(PostRestoreStateEvent.class)).isEmpty()) {
                int size = listeners.size();
                for (int i = 0; i < size; ++i) {
                    SystemEventListener listener = listeners.get(i);
                    if (!listener.isListenerForSource(this)) continue;
                    boolean shouldProcessEvent = true;
                    if (listener instanceof _EventListenerWrapper && ((_EventListenerWrapper)listener).getListenerCapability() == 4) {
                        shouldProcessEvent = false;
                    }
                    if (!shouldProcessEvent) continue;
                    listener.processEvent(event);
                }
            }
        }
    }

    public abstract void processValidators(FacesContext var1);

    public abstract void processUpdates(FacesContext var1);

    public abstract Object processSaveState(FacesContext var1);

    public void subscribeToEvent(Class<? extends SystemEvent> eventClass, ComponentSystemEventListener componentListener) {
        List<SystemEventListener> listeners;
        Assert.notNull(eventClass, "eventClass");
        Assert.notNull(componentListener, "componentListener");
        _EventListenerWrapper listener = new _EventListenerWrapper(this, componentListener);
        if (this._systemEventListenerClassMap == null) {
            this._systemEventListenerClassMap = new HashMap<Class<? extends SystemEvent>, List<SystemEventListener>>(4, 1.0f);
        }
        if ((listeners = this._systemEventListenerClassMap.get(eventClass)) == null) {
            listeners = new _DeltaList<SystemEventListener>(3);
            this._systemEventListenerClassMap.put(eventClass, listeners);
        }
        listeners.add(listener);
    }

    public void unsubscribeFromEvent(Class<? extends SystemEvent> eventClass, ComponentSystemEventListener componentListener) {
        List<SystemEventListener> listeners;
        Assert.notNull(eventClass, "eventClass");
        Assert.notNull(componentListener, "componentListener");
        if (this._systemEventListenerClassMap != null && (listeners = this._systemEventListenerClassMap.get(eventClass)) != null && !listeners.isEmpty()) {
            Iterator<SystemEventListener> it = listeners.iterator();
            while (it.hasNext()) {
                ComponentSystemEventListener listener = ((_EventListenerWrapper)it.next()).getComponentSystemEventListener();
                if (listener == null || !listener.equals(componentListener)) continue;
                it.remove();
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean visitTree(VisitContext context, VisitCallback callback) {
        try {
            int childCount;
            this.pushComponentToEL(context.getFacesContext(), this);
            if (!this.isVisitable(context)) {
                boolean bl = false;
                return bl;
            }
            VisitResult res = context.invokeVisitCallback(this, callback);
            switch (res) {
                case COMPLETE: {
                    boolean bl = true;
                    return bl;
                }
                case REJECT: {
                    boolean bl = false;
                    return bl;
                }
            }
            if (this.getFacetCount() > 0) {
                for (UIComponent facet : this.getFacets().values()) {
                    if (!facet.visitTree(context, callback)) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            if ((childCount = this.getChildCount()) > 0) {
                for (int i = 0; i < childCount; ++i) {
                    UIComponent child = this.getChildren().get(i);
                    if (!child.visitTree(context, callback)) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.popComponentFromEL(context.getFacesContext());
        }
    }

    protected abstract FacesContext getFacesContext();

    protected abstract Renderer getRenderer(FacesContext var1);

    protected StateHelper getStateHelper() {
        return this.getStateHelper(true);
    }

    protected StateHelper getStateHelper(boolean create) {
        if (this._stateHelper != null) {
            return this._stateHelper;
        }
        if (create) {
            this._stateHelper = new _DeltaStateHelper(this);
        }
        return this._stateHelper;
    }

    public TransientStateHelper getTransientStateHelper() {
        return this.getTransientStateHelper(true);
    }

    public TransientStateHelper getTransientStateHelper(boolean create) {
        if (this._stateHelper != null) {
            return this._stateHelper;
        }
        if (create) {
            this._stateHelper = new _DeltaStateHelper(this);
        }
        return this._stateHelper;
    }

    @Override
    public void restoreTransientState(FacesContext context, Object state) {
        this.getTransientStateHelper().restoreTransientState(context, state);
    }

    @Override
    public Object saveTransientState(FacesContext context) {
        return this.getTransientStateHelper().saveTransientState(context);
    }

    public void popComponentFromEL(FacesContext context) {
        int i;
        Map<Object, Object> contextAttributes = context.getAttributes();
        List componentStack = (List)contextAttributes.get(_COMPONENT_STACK);
        UIComponent oldCurrent = null;
        if (componentStack != null && !componentStack.isEmpty()) {
            int componentIndex = componentStack.lastIndexOf(this);
            if (componentIndex >= 0) {
                for (i = componentStack.size() - 1; i >= componentIndex; --i) {
                    oldCurrent = (UIComponent)componentStack.remove(componentStack.size() - 1);
                }
            } else {
                return;
            }
        }
        if (oldCurrent != null && oldCurrent._isCompositeComponent()) {
            UIComponent previousCompositeComponent = null;
            for (i = componentStack.size() - 1; i >= 0; --i) {
                UIComponent component = (UIComponent)componentStack.get(i);
                if (!component._isCompositeComponent()) continue;
                previousCompositeComponent = component;
                break;
            }
            contextAttributes.put(_CURRENT_COMPOSITE_COMPONENT_KEY, previousCompositeComponent);
        }
    }

    public void pushComponentToEL(FacesContext context, UIComponent component) {
        Map<Object, Object> contextAttributes;
        ArrayList<UIComponent> componentStack;
        if (component == null) {
            component = this;
        }
        if ((componentStack = (ArrayList<UIComponent>)(contextAttributes = context.getAttributes()).get(_COMPONENT_STACK)) == null) {
            componentStack = new ArrayList<UIComponent>();
            contextAttributes.put(_COMPONENT_STACK, componentStack);
        }
        componentStack.add(component);
        if (component._isCompositeComponent()) {
            contextAttributes.put(_CURRENT_COMPOSITE_COMPONENT_KEY, component);
        }
    }

    public int getFacetCount() {
        Map<String, UIComponent> facets = this.getFacets();
        return facets == null ? 0 : facets.size();
    }

    private boolean _isCompositeComponent() {
        return UIComponent.isCompositeComponent(this);
    }

    boolean isCachedFacesContext() {
        return false;
    }

    void setCachedFacesContext(FacesContext facesContext) {
    }

    static enum PropertyKeys {
        rendered,
        rendererType,
        attributesMap,
        bindings,
        facesListeners,
        passThroughAttributesMap;

    }
}

