/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.core.api.shared;

import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UISelectItem;
import jakarta.faces.component.UISelectItems;
import jakarta.faces.context.FacesContext;
import jakarta.faces.convert.Converter;
import jakarta.faces.model.SelectItem;
import jakarta.faces.model.SelectItemGroup;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.myfaces.core.api.shared.AttributeUtils;
import org.apache.myfaces.core.api.shared.VarUtils;
import org.apache.myfaces.core.api.shared.lang.ClassUtils;
import org.apache.myfaces.core.api.shared.lang.CollectionUtils;

public class SelectItemsUtil {
    public static final String ATTR_ITEM_VALUE = "itemValue";
    public static final String ATTR_ITEM_LABEL = "itemLabel";
    public static final String ATTR_ITEM_DESCRIPTION = "itemDescription";
    public static final String ATTR_ITEM_DISABLED = "itemDisabled";
    public static final String ATTR_ITEM_LABEL_ESCAPED = "itemLabelEscaped";
    public static final String ATTR_NO_SELECTION_VALUE = "noSelectionValue";
    public static final String ATTR_NO_SELECTION_OPTION = "noSelectionOption";
    public static final String ATTR_VAR = "var";

    public static <S extends SelectItem> S createSelectItem(UISelectItem uiSelectItem, Supplier<S> supplier) {
        Object value = uiSelectItem.getItemValue();
        String label = uiSelectItem.getItemLabel();
        if (label == null && value != null) {
            label = value.toString();
        }
        SelectItem selectItem = (SelectItem)supplier.get();
        selectItem.setValue(value);
        selectItem.setLabel(label);
        selectItem.setDescription(uiSelectItem.getItemDescription());
        selectItem.setDisabled(uiSelectItem.isItemDisabled());
        selectItem.setEscape(uiSelectItem.isItemEscaped());
        selectItem.setNoSelectionOption(uiSelectItem.isNoSelectionOption());
        return (S)selectItem;
    }

    public static <S extends SelectItem> S createSelectItem(UIComponent component, Object value, Supplier<S> supplier) {
        Object itemDescription;
        Map<String, Object> attributes = component.getAttributes();
        Object itemValue = SelectItemsUtil.getItemValue(attributes, value);
        Object itemLabel = attributes.get(ATTR_ITEM_LABEL);
        if (itemLabel == null) {
            if (itemValue != null) {
                itemLabel = itemValue.toString();
            }
        } else {
            itemLabel = itemLabel.toString();
        }
        if ((itemDescription = attributes.get(ATTR_ITEM_DESCRIPTION)) != null) {
            itemDescription = itemDescription.toString();
        }
        boolean itemDisabled = AttributeUtils.getBooleanAttribute(component, ATTR_ITEM_DISABLED, false);
        boolean itemLabelEscaped = AttributeUtils.getBooleanAttribute(component, ATTR_ITEM_LABEL_ESCAPED, true);
        Object noSelectionValue = attributes.get(ATTR_NO_SELECTION_VALUE);
        SelectItem selectItem = (SelectItem)supplier.get();
        selectItem.setValue(itemValue);
        selectItem.setLabel((String)itemLabel);
        selectItem.setDescription((String)itemDescription);
        selectItem.setDisabled(itemDisabled);
        selectItem.setEscape(itemLabelEscaped);
        selectItem.setNoSelectionOption(Objects.equals(itemValue, noSelectionValue));
        return (S)selectItem;
    }

    public static SelectItem updateSelectItem(UISelectItems uiSelectItems, SelectItem value) {
        Object itemDescription;
        Object noSelection;
        Object itemEscaped;
        Object itemDisabled;
        if (value instanceof SelectItemGroup) {
            return value;
        }
        Map<String, Object> attrs = uiSelectItems.getAttributes();
        Object itemLabel = attrs.get(ATTR_ITEM_LABEL);
        if (itemLabel != null) {
            value.setLabel(String.valueOf(itemLabel));
        }
        if ((itemDisabled = attrs.get(ATTR_ITEM_DISABLED)) != null) {
            value.setDisabled(Boolean.parseBoolean(itemDisabled.toString()));
        }
        if ((itemEscaped = attrs.get(ATTR_ITEM_LABEL_ESCAPED)) != null) {
            value.setEscape(Boolean.parseBoolean(itemEscaped.toString()));
        }
        if ((noSelection = attrs.get(ATTR_NO_SELECTION_OPTION)) != null) {
            value.setNoSelectionOption(Boolean.parseBoolean(noSelection.toString()));
        }
        if ((itemDescription = attrs.get(ATTR_ITEM_DESCRIPTION)) != null) {
            value.setDescription(String.valueOf(itemDescription));
        }
        return value;
    }

    public static List<SelectItem> collectSelectItems(FacesContext context, UIComponent component) {
        ArrayList<SelectItem> items = new ArrayList<SelectItem>();
        for (int i = 0; i < component.getChildCount(); ++i) {
            UIComponent child = component.getChildren().get(i);
            if (child instanceof UISelectItems) {
                UISelectItems uiSelectItems = (UISelectItems)child;
                SelectItemsUtil.createSelectItems(context, uiSelectItems, uiSelectItems.getValue(), SelectItem::new, items::add);
                continue;
            }
            if (!(child instanceof UISelectItem)) continue;
            items.add(SelectItemsUtil.createSelectItem(child, null, SelectItem::new));
        }
        return items;
    }

    public static <S extends SelectItem> void createSelectItems(FacesContext context, UISelectItems component, Object values, Supplier<S> supplier, Consumer<S> callback) {
        Map<String, Object> attributes = component.getAttributes();
        Object varObject = attributes.get(ATTR_VAR);
        String var = varObject != null ? (String)varObject : "item";
        CollectionUtils.forEach(values, value -> VarUtils.executeInScope(context, var, value, () -> SelectItemsUtil.lambda$createSelectItems$0(callback, component, attributes, value, (Supplier)supplier)));
    }

    private static Object getItemValue(Map<String, Object> attributes, Object defaultValue) {
        Object itemValue = attributes.get(ATTR_ITEM_VALUE);
        return itemValue != null || attributes.containsKey(ATTR_ITEM_VALUE) ? itemValue : defaultValue;
    }

    public static boolean matchValue(FacesContext context, UIComponent uiComponent, Object value, Iterator<SelectItem> iterator, Converter converter) {
        while (iterator.hasNext()) {
            Object itemValue;
            SelectItemGroup itemgroup;
            SelectItem[] selectItems;
            SelectItem item = iterator.next();
            if (!(item instanceof SelectItemGroup ? (selectItems = (itemgroup = (SelectItemGroup)item).getSelectItems()) != null && selectItems.length > 0 && SelectItemsUtil.matchValue(context, uiComponent, value, Arrays.asList(selectItems).iterator(), converter) : value == (itemValue = SelectItemsUtil.convertOrCoerceValue(context, uiComponent, value, item, converter)) || value.equals(itemValue))) continue;
            return true;
        }
        return false;
    }

    public static boolean isNoSelectionOption(FacesContext context, UIComponent uiComponent, Object value, Iterator<SelectItem> iterator, Converter converter) {
        while (iterator.hasNext()) {
            Object itemValue;
            SelectItemGroup itemgroup;
            SelectItem[] selectItems;
            SelectItem item = iterator.next();
            if (!(item instanceof SelectItemGroup ? (selectItems = (itemgroup = (SelectItemGroup)item).getSelectItems()) != null && selectItems.length > 0 && SelectItemsUtil.isNoSelectionOption(context, uiComponent, value, Arrays.asList(selectItems).iterator(), converter) : item.isNoSelectionOption() && (value == (itemValue = SelectItemsUtil.convertOrCoerceValue(context, uiComponent, value, item, converter)) || value.equals(itemValue)))) continue;
            return true;
        }
        return false;
    }

    private static Object convertOrCoerceValue(FacesContext facesContext, UIComponent uiComponent, Object value, SelectItem selectItem, Converter converter) {
        Object itemValue = selectItem.getValue();
        if (itemValue == null && value == null) {
            return null;
        }
        if (converter != null && !(value instanceof String) && itemValue instanceof String) {
            itemValue = converter.getAsObject(facesContext, uiComponent, (String)itemValue);
        } else {
            try {
                if (value instanceof Enum) {
                    Class<?> targetClass = value.getClass();
                    if (targetClass != null && !targetClass.isEnum()) {
                        targetClass = targetClass.getSuperclass();
                    }
                    itemValue = ClassUtils.convertToTypeNoLogging(facesContext, itemValue, targetClass);
                } else {
                    itemValue = ClassUtils.convertToTypeNoLogging(facesContext, itemValue, value.getClass());
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return itemValue;
    }

    private static /* synthetic */ Object lambda$createSelectItems$0(Consumer callback, UISelectItems component, Map attributes, Object value, Supplier supplier) {
        callback.accept(SelectItemsUtil.createSelectItem(component, SelectItemsUtil.getItemValue(attributes, value), supplier));
        return null;
    }
}

