/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.flow.cdi;

import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.BeforeBeanDiscovery;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ProcessBean;
import jakarta.faces.flow.FlowScoped;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.myfaces.flow.FlowReference;
import org.apache.myfaces.flow.cdi.FlowScopeContext;
import org.apache.myfaces.flow.cdi.FlowScopeContextualStorageHolder;

public class FlowScopeExtension
implements Extension {
    private FlowScopeContext flowScopedContext;
    private Map<Class, FlowReference> flowBeanReferences = new ConcurrentHashMap<Class, FlowReference>();

    void beforeBeanDiscovery(@Observes BeforeBeanDiscovery event, BeanManager beanManager) {
        event.addScope(FlowScoped.class, true, true);
        AnnotatedType<FlowScopeContextualStorageHolder> annotatedType = beanManager.createAnnotatedType(FlowScopeContextualStorageHolder.class);
        event.addAnnotatedType(annotatedType, annotatedType.getJavaClass().getName());
    }

    void onProcessBean(@Observes ProcessBean event, BeanManager manager) {
        FlowScoped flowScoped;
        String flowId;
        if (event.getAnnotated().isAnnotationPresent(FlowScoped.class) && (flowId = (flowScoped = event.getAnnotated().getAnnotation(FlowScoped.class)).value()) != null) {
            this.flowBeanReferences.put(event.getBean().getBeanClass(), new FlowReference(flowScoped.definingDocumentId(), flowId));
        }
    }

    void afterBeanDiscovery(@Observes AfterBeanDiscovery event, BeanManager manager) {
        this.flowScopedContext = new FlowScopeContext(manager, this.flowBeanReferences);
        event.addContext(this.flowScopedContext);
    }
}

