/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.spi.impl;

import jakarta.faces.context.ExternalContext;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.myfaces.spi.ServiceProviderFinderFactory;
import org.apache.myfaces.spi.WebConfigProvider;
import org.apache.myfaces.spi.WebConfigProviderFactory;
import org.apache.myfaces.spi.impl.DefaultWebConfigProvider;
import org.apache.myfaces.util.lang.ClassUtils;

public class DefaultWebConfigProviderFactory
extends WebConfigProviderFactory {
    public static final String WEB_CONFIG_PROVIDER = WebConfigProvider.class.getName();
    public static final String WEB_CONFIG_PROVIDER_LIST = WebConfigProvider.class.getName() + ".LIST";

    private Logger getLogger() {
        return Logger.getLogger(DefaultWebConfigProviderFactory.class.getName());
    }

    @Override
    public WebConfigProvider getWebConfigProvider(ExternalContext externalContext) {
        WebConfigProvider instance = null;
        try {
            instance = this.resolveWebXmlProviderFromService(externalContext);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoClassDefFoundError | InvocationTargetException e) {
            this.getLogger().log(Level.SEVERE, "", e);
        }
        if (instance == null) {
            instance = new DefaultWebConfigProvider();
        }
        return instance;
    }

    private WebConfigProvider resolveWebXmlProviderFromService(ExternalContext externalContext) throws ClassNotFoundException, NoClassDefFoundError, InstantiationException, IllegalAccessException, InvocationTargetException {
        List<String> classList = (List<String>)externalContext.getApplicationMap().get(WEB_CONFIG_PROVIDER_LIST);
        if (classList == null) {
            classList = ServiceProviderFinderFactory.getServiceProviderFinder(externalContext).getServiceProviderList(WEB_CONFIG_PROVIDER);
            externalContext.getApplicationMap().put(WEB_CONFIG_PROVIDER_LIST, classList);
        }
        return ClassUtils.buildApplicationObject(WebConfigProvider.class, classList, new DefaultWebConfigProvider());
    }
}

