/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.impl;

import jakarta.el.ELException;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.faces.FacesException;
import jakarta.faces.FactoryFinder;
import jakarta.faces.annotation.View;
import jakarta.faces.application.ViewResource;
import jakarta.faces.context.FacesContext;
import jakarta.faces.view.facelets.Facelet;
import jakarta.faces.view.facelets.FaceletCache;
import jakarta.faces.view.facelets.FaceletCacheFactory;
import jakarta.faces.view.facelets.FaceletContext;
import jakarta.faces.view.facelets.FaceletException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.myfaces.cdi.util.CDIUtils;
import org.apache.myfaces.config.webparameters.MyfacesConfig;
import org.apache.myfaces.core.api.shared.lang.Assert;
import org.apache.myfaces.resource.ResourceLoaderUtils;
import org.apache.myfaces.util.ExternalSpecifications;
import org.apache.myfaces.view.facelets.AbstractFaceletCache;
import org.apache.myfaces.view.facelets.FaceletFactory;
import org.apache.myfaces.view.facelets.compiler.Compiler;
import org.apache.myfaces.view.facelets.impl.DefaultFacelet;

public final class DefaultFaceletFactory
extends FaceletFactory {
    private static final long INFINITE_DELAY = -1L;
    private static final long NO_CACHE_DELAY = 0L;
    protected static final Logger log = Logger.getLogger(DefaultFaceletFactory.class.getName());
    private Optional<URL> _baseUrl;
    private Compiler _compiler;
    private Map<String, DefaultFacelet> _compositeComponentMetadataFacelets;
    private long _refreshPeriod;
    private Map<String, URL> _relativeLocations;
    private Map<String, Boolean> _managedFacelet;
    private FaceletCache<Facelet> _faceletCache;
    private AbstractFaceletCache<Facelet> _abstractFaceletCache;
    private boolean viewUniqueIdsCacheEnabled;

    public DefaultFaceletFactory(Compiler compiler) throws IOException {
        this(compiler, -1L);
    }

    public DefaultFaceletFactory(Compiler compiler, long refreshPeriod) {
        Assert.notNull(compiler, "compiler");
        this._compiler = compiler;
        this._compositeComponentMetadataFacelets = new HashMap<String, DefaultFacelet>();
        this._relativeLocations = new HashMap<String, URL>();
        this._managedFacelet = new HashMap<String, Boolean>();
        this._refreshPeriod = refreshPeriod < 0L ? -1L : refreshPeriod * 1000L;
        FaceletCacheFactory cacheFactory = (FaceletCacheFactory)FactoryFinder.getFactory("jakarta.faces.view.facelets.FaceletCacheFactory");
        this._faceletCache = cacheFactory.getFaceletCache();
        FaceletCache.MemberFactory<Facelet> faceletFactory = url -> this._createFacelet(url);
        FaceletCache.MemberFactory<Facelet> viewMetadataFaceletFactory = url -> this._createViewMetadataFacelet(url);
        if (this._faceletCache instanceof AbstractFaceletCache) {
            this._abstractFaceletCache = (AbstractFaceletCache)this._faceletCache;
            FaceletCache.MemberFactory<Facelet> compositeComponentMetadataFaceletFactory = url -> this._createCompositeComponentMetadataFacelet(url);
            try {
                this._abstractFaceletCache.setCacheFactories(faceletFactory, viewMetadataFaceletFactory, compositeComponentMetadataFaceletFactory);
            }
            catch (Exception e) {
                throw new FacesException("Cannot call setMemberFactories method, Initialization of FaceletCache failed.", e);
            }
        }
        try {
            this._faceletCache.setCacheFactories(faceletFactory, viewMetadataFaceletFactory);
        }
        catch (Exception e) {
            throw new FacesException("Cannot call setMemberFactories method, Initialization of FaceletCache failed.", e);
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Rrefresh period " + this._refreshPeriod);
        }
        this.viewUniqueIdsCacheEnabled = MyfacesConfig.getCurrentInstance().isViewUniqueIdsCacheEnabled();
    }

    public Compiler getCompiler() {
        return this._compiler;
    }

    private URL getBaseUrl() {
        if (this._baseUrl == null) {
            FacesContext context = FacesContext.getCurrentInstance();
            ViewResource resource = context.getApplication().getResourceHandler().createViewResource(context, "/");
            this._baseUrl = Optional.ofNullable(resource == null ? null : resource.getURL());
        }
        return this._baseUrl.isPresent() ? this._baseUrl.get() : null;
    }

    @Override
    public Facelet getFacelet(FacesContext facesContext, String uri) throws IOException, FaceletException, FacesException, ELException {
        URL url;
        Boolean isManagedFacelet = this._managedFacelet.get(uri);
        if (isManagedFacelet == null || isManagedFacelet.booleanValue()) {
            Facelet facelet = null;
            if (ExternalSpecifications.isCDIAvailable(facesContext.getExternalContext())) {
                BeanManager bm = CDIUtils.getBeanManager(facesContext);
                facelet = CDIUtils.get(bm, Facelet.class, true, View.Literal.of(uri));
            }
            this._managedFacelet.put(uri, facelet != null);
            if (facelet != null) {
                return facelet;
            }
        }
        if ((url = this._relativeLocations.get(uri)) == null) {
            url = this.resolveURL(facesContext, this.getBaseUrl(), uri);
            if (url != null) {
                ViewResource viewResource = (ViewResource)facesContext.getAttributes().get("oam.facelets.LAST_RESOURCE_RESOLVED");
                if (viewResource == null) {
                    HashMap<String, URL> newLoc = new HashMap<String, URL>(this._relativeLocations);
                    newLoc.put(uri, url);
                    this._relativeLocations = newLoc;
                }
            } else {
                throw new IOException("'" + uri + "' not found.");
            }
        }
        return this.getFacelet(url);
    }

    @Override
    public Facelet getFacelet(URL url) throws IOException, FaceletException, FacesException, ELException {
        return this._faceletCache.getFacelet(url);
    }

    @Override
    public Facelet getFacelet(FaceletContext ctx, URL url) throws IOException, FaceletException, FacesException, ELException {
        if (this._abstractFaceletCache != null) {
            return this._abstractFaceletCache.getFacelet(ctx, url);
        }
        return this._faceletCache.getFacelet(url);
    }

    public long getRefreshPeriod() {
        return this._refreshPeriod;
    }

    public URL resolveURL(FacesContext context, URL source, String path) throws IOException {
        if (path.startsWith("/")) {
            context.getAttributes().put("oam.facelets.LAST_RESOURCE_RESOLVED", null);
            URL url = this.resolveURL(context, path);
            if (url == null) {
                throw new FileNotFoundException(path + " Not Found in ExternalContext as a Resource");
            }
            return url;
        }
        return new URL(source, path);
    }

    protected boolean needsToBeRefreshed(DefaultFacelet facelet) {
        if (this._refreshPeriod == 0L) {
            return true;
        }
        if (this._refreshPeriod == -1L) {
            return false;
        }
        long target = facelet.getCreateTime() + this._refreshPeriod;
        if (System.currentTimeMillis() > target) {
            try {
                long lastModified = ResourceLoaderUtils.getResourceLastModified(facelet.getSource());
                return lastModified == 0L || lastModified > target;
            }
            catch (IOException e) {
                throw new FaceletException("Error Checking Last Modified for " + facelet.getAlias(), e);
            }
        }
        return false;
    }

    private DefaultFacelet _createFacelet(URL url) throws IOException, FaceletException, FacesException, ELException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Creating Facelet for: " + url);
        }
        URL baseUrl = this.getBaseUrl();
        String alias = "/" + this._removeFirst(url.getFile(), baseUrl == null ? "" : baseUrl.getFile());
        try {
            Compiler.CompilerResult result = this._compiler.compile(url, alias);
            DefaultFacelet f = new DefaultFacelet(this, this._compiler.createExpressionFactory(), url, alias, alias, result.getFaceletHandler(), this.viewUniqueIdsCacheEnabled, result.getDoctype());
            return f;
        }
        catch (FileNotFoundException fnfe) {
            throw new FileNotFoundException("Facelet " + alias + " not found at: " + url.toExternalForm());
        }
    }

    private DefaultFacelet _createViewMetadataFacelet(URL url) throws IOException, FaceletException, FacesException, ELException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Creating Facelet used to create View Metadata for: " + url);
        }
        URL baseUrl = this.getBaseUrl();
        String faceletId = "/" + this._removeFirst(url.getFile(), baseUrl == null ? "" : baseUrl.getFile());
        String alias = "/viewMetadata" + faceletId;
        try {
            Compiler.CompilerResult result = this._compiler.compileViewMetadata(url, alias);
            DefaultFacelet f = new DefaultFacelet(this, this._compiler.createExpressionFactory(), url, alias, faceletId, result.getFaceletHandler(), this.viewUniqueIdsCacheEnabled, result.getDoctype());
            return f;
        }
        catch (FileNotFoundException fnfe) {
            throw new FileNotFoundException("Facelet " + alias + " not found at: " + url.toExternalForm());
        }
    }

    private DefaultFacelet _createCompositeComponentMetadataFacelet(URL url) throws IOException, FaceletException, FacesException, ELException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Creating Facelet used to create Composite Component Metadata for: " + url);
        }
        URL baseUrl = this.getBaseUrl();
        String alias = "/compositeComponentMetadata/" + this._removeFirst(url.getFile(), baseUrl == null ? "" : baseUrl.getFile());
        try {
            Compiler.CompilerResult result = this._compiler.compileCompositeComponentMetadata(url, alias);
            DefaultFacelet f = new DefaultFacelet(this, this._compiler.createExpressionFactory(), url, alias, alias, result.getFaceletHandler(), true, this.viewUniqueIdsCacheEnabled, result.getDoctype());
            return f;
        }
        catch (FileNotFoundException fnfe) {
            throw new FileNotFoundException("Facelet " + alias + " not found at: " + url.toExternalForm());
        }
    }

    @Override
    public Facelet getViewMetadataFacelet(FacesContext facesContext, String uri) throws IOException {
        URL url;
        Boolean isManagedFacelet = this._managedFacelet.get(uri);
        if (isManagedFacelet == null || isManagedFacelet.booleanValue()) {
            Facelet facelet = null;
            if (ExternalSpecifications.isCDIAvailable(facesContext.getExternalContext())) {
                BeanManager bm = CDIUtils.getBeanManager(facesContext);
                facelet = CDIUtils.get(bm, Facelet.class, true, View.Literal.of(uri));
            }
            this._managedFacelet.put(uri, facelet != null);
            if (facelet != null) {
                return facelet;
            }
        }
        if ((url = this._relativeLocations.get(uri)) == null) {
            url = this.resolveURL(facesContext, this.getBaseUrl(), uri);
            ViewResource viewResource = (ViewResource)facesContext.getAttributes().get("oam.facelets.LAST_RESOURCE_RESOLVED");
            if (url != null) {
                if (viewResource == null) {
                    HashMap<String, URL> newLoc = new HashMap<String, URL>(this._relativeLocations);
                    newLoc.put(uri, url);
                    this._relativeLocations = newLoc;
                }
            } else {
                throw new IOException("'" + uri + "' not found.");
            }
        }
        return this.getViewMetadataFacelet(url);
    }

    @Override
    public Facelet getViewMetadataFacelet(URL url) throws IOException, FaceletException, FacesException, ELException {
        if (this._abstractFaceletCache != null) {
            return (Facelet)this._abstractFaceletCache.getViewMetadataFacelet(url);
        }
        return this._faceletCache.getViewMetadataFacelet(url);
    }

    @Override
    public Facelet getCompositeComponentMetadataFacelet(FacesContext facesContext, String uri) throws IOException {
        URL url = this._relativeLocations.get(uri);
        if (url == null) {
            url = this.resolveURL(facesContext, this.getBaseUrl(), uri);
            ViewResource viewResource = (ViewResource)facesContext.getAttributes().get("oam.facelets.LAST_RESOURCE_RESOLVED");
            if (url != null) {
                if (viewResource == null) {
                    HashMap<String, URL> newLoc = new HashMap<String, URL>(this._relativeLocations);
                    newLoc.put(uri, url);
                    this._relativeLocations = newLoc;
                }
            } else {
                throw new IOException("'" + uri + "' not found.");
            }
        }
        return this.getCompositeComponentMetadataFacelet(url);
    }

    @Override
    public Facelet getCompositeComponentMetadataFacelet(URL url) throws IOException, FaceletException, FacesException, ELException {
        if (this._abstractFaceletCache != null) {
            return this._abstractFaceletCache.getCompositeComponentMetadataFacelet(url);
        }
        Assert.notNull(url, "url");
        String key = url.toString();
        DefaultFacelet f = this._compositeComponentMetadataFacelets.get(key);
        if (f == null || this.needsToBeRefreshed(f)) {
            f = this._createCompositeComponentMetadataFacelet(url);
            if (this._refreshPeriod != 0L) {
                HashMap<String, DefaultFacelet> newLoc = new HashMap<String, DefaultFacelet>(this._compositeComponentMetadataFacelets);
                newLoc.put(key, f);
                this._compositeComponentMetadataFacelets = newLoc;
            }
        }
        return f;
    }

    private URL resolveURL(FacesContext context, String path) {
        ViewResource resource = context.getApplication().getResourceHandler().createViewResource(context, path);
        if (resource != null) {
            context.getAttributes().put("oam.facelets.LAST_RESOURCE_RESOLVED", resource);
            return resource.getURL();
        }
        return null;
    }

    @Override
    public Facelet compileComponentFacelet(String taglibURI, String tagName, Map<String, Object> attributes) {
        Compiler.CompilerResult result = this._compiler.compileComponent(taglibURI, tagName, attributes);
        String alias = "/component/oamf:" + tagName;
        return new DefaultFacelet(this, this._compiler.createExpressionFactory(), this.getBaseUrl(), alias, alias, result.getFaceletHandler(), this.viewUniqueIdsCacheEnabled, result.getDoctype());
    }

    private String _removeFirst(String string, String toRemove) {
        return Pattern.compile(toRemove, 16).matcher(string).replaceFirst("");
    }
}

