/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.renderkit.html;

import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseStream;
import jakarta.faces.context.ResponseWriter;
import jakarta.faces.render.ClientBehaviorRenderer;
import jakarta.faces.render.RenderKit;
import jakarta.faces.render.Renderer;
import jakarta.faces.render.RendererWrapper;
import jakarta.faces.render.ResponseStateManager;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.myfaces.config.webparameters.MyfacesConfig;
import org.apache.myfaces.core.api.shared.lang.Assert;
import org.apache.myfaces.renderkit.ContentTypeUtils;
import org.apache.myfaces.renderkit.LazyRenderKit;
import org.apache.myfaces.renderkit.html.EarlyFlushHtmlResponseWriterImpl;
import org.apache.myfaces.renderkit.html.HtmlResponseStateManager;
import org.apache.myfaces.renderkit.html.HtmlResponseWriterImpl;
import org.apache.myfaces.util.lang.ClassUtils;

public class HtmlRenderKitImpl
extends RenderKit
implements LazyRenderKit {
    private static final Logger log = Logger.getLogger(HtmlRenderKitImpl.class.getName());
    private Map<String, Map<String, Renderer>> _renderers = new ConcurrentHashMap<String, Map<String, Renderer>>(64, 0.75f, 1);
    private ResponseStateManager _responseStateManager = new HtmlResponseStateManager();
    private Map<String, ClientBehaviorRenderer> _clientBehaviorRenderers = new HashMap<String, ClientBehaviorRenderer>();
    private MyfacesConfig myfacesConfig = MyfacesConfig.getCurrentInstance();

    public void addClientBehaviorRenderer(String type, ClientBehaviorRenderer renderer) {
        Assert.notNull((Object)type, (String)"type");
        Assert.notNull((Object)renderer, (String)"renderer");
        this._clientBehaviorRenderers.put(type, renderer);
    }

    public ClientBehaviorRenderer getClientBehaviorRenderer(String type) {
        Assert.notNull((Object)type, (String)"type");
        return this._clientBehaviorRenderers.get(type);
    }

    public Iterator<String> getClientBehaviorRendererTypes() {
        return this._clientBehaviorRenderers.keySet().iterator();
    }

    public Renderer getRenderer(String componentFamily, String rendererType) {
        Assert.notNull((Object)componentFamily, (String)"componentFamily");
        Assert.notNull((Object)rendererType, (String)"rendererType");
        Map<String, Renderer> familyRendererMap = this._renderers.get(componentFamily);
        Renderer renderer = null;
        if (familyRendererMap != null) {
            renderer = familyRendererMap.get(rendererType);
        }
        if (renderer == null) {
            log.warning("Unsupported component-family/renderer-type: " + componentFamily + "/" + rendererType);
        }
        if (renderer instanceof LazyRendererWrapper) {
            renderer = ((LazyRendererWrapper)renderer).getWrapped();
            familyRendererMap.put(rendererType, renderer);
        }
        return renderer;
    }

    public void addRenderer(String componentFamily, String rendererType, Renderer renderer) {
        Assert.notNull((Object)componentFamily, (String)"componentFamily");
        Assert.notNull((Object)rendererType, (String)"rendererType");
        Assert.notNull((Object)renderer, (String)"renderer");
        this._put(componentFamily, rendererType, renderer);
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Add Renderer family = " + componentFamily + " rendererType = " + rendererType + " renderer class = " + renderer.getClass().getName());
        }
    }

    @Override
    public void addRenderer(String componentFamily, String rendererType, String rendererClass) {
        Assert.notNull((Object)componentFamily, (String)"componentFamily");
        Assert.notNull((Object)rendererType, (String)"rendererType");
        Assert.notNull((Object)rendererClass, (String)"rendererClass");
        this._put(componentFamily, rendererType, (Renderer)new LazyRendererWrapper(rendererClass));
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Add Renderer family = " + componentFamily + " rendererType = " + rendererType + " renderer class = " + rendererClass);
        }
    }

    private synchronized void _put(String componentFamily, String rendererType, Renderer renderer) {
        Map<String, Renderer> familyRendererMap = this._renderers.get(componentFamily);
        if (familyRendererMap == null) {
            familyRendererMap = new ConcurrentHashMap<String, Renderer>(8, 0.75f, 1);
            this._renderers.put(componentFamily, familyRendererMap);
        } else if (familyRendererMap.get(rendererType) != null) {
            log.fine("Overwriting renderer with family = " + componentFamily + " rendererType = " + rendererType + " renderer class = " + renderer.getClass().getName());
        }
        familyRendererMap.put(rendererType, renderer);
    }

    public ResponseStateManager getResponseStateManager() {
        return this._responseStateManager;
    }

    public Iterator<String> getComponentFamilies() {
        return this._renderers.keySet().iterator();
    }

    public Iterator<String> getRendererTypes(String componentFamily) {
        Map<String, Renderer> map = this._renderers.get(componentFamily);
        if (map != null) {
            return map.keySet().iterator();
        }
        return Collections.emptyIterator();
    }

    public ResponseWriter createResponseWriter(Writer writer, String contentTypeListString, String characterEncoding) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        String selectedContentType = null;
        String writerContentType = null;
        boolean isAjaxRequest = facesContext.getPartialViewContext().isAjaxRequest();
        String contentTypeListStringFromAccept = null;
        if (contentTypeListString != null) {
            selectedContentType = ContentTypeUtils.chooseWriterContentType(contentTypeListString, ContentTypeUtils.HTML_ALLOWED_CONTENT_TYPES, isAjaxRequest ? ContentTypeUtils.AJAX_XHTML_ALLOWED_CONTENT_TYPES : ContentTypeUtils.XHTML_ALLOWED_CONTENT_TYPES);
        }
        if (selectedContentType == null && (contentTypeListStringFromAccept = ContentTypeUtils.getContentTypeFromAcceptHeader(facesContext)) != null) {
            selectedContentType = ContentTypeUtils.chooseWriterContentType(contentTypeListStringFromAccept, ContentTypeUtils.HTML_ALLOWED_CONTENT_TYPES, isAjaxRequest ? ContentTypeUtils.AJAX_XHTML_ALLOWED_CONTENT_TYPES : ContentTypeUtils.XHTML_ALLOWED_CONTENT_TYPES);
        }
        if (selectedContentType == null) {
            if (contentTypeListString == null && contentTypeListStringFromAccept == null) {
                selectedContentType = this.myfacesConfig.getDefaultResponseWriterContentTypeMode();
            } else {
                String[] contentTypes;
                if (contentTypeListString != null && ContentTypeUtils.containsContentType("*/*", contentTypes = ContentTypeUtils.splitContentTypeListString(contentTypeListString))) {
                    selectedContentType = this.myfacesConfig.getDefaultResponseWriterContentTypeMode();
                }
                if (selectedContentType == null) {
                    if (contentTypeListStringFromAccept != null) {
                        if (contentTypeListString == null) {
                            selectedContentType = this.myfacesConfig.getDefaultResponseWriterContentTypeMode();
                        } else {
                            contentTypes = ContentTypeUtils.splitContentTypeListString(contentTypeListStringFromAccept);
                            if (ContentTypeUtils.containsContentType("*/*", contentTypes)) {
                                selectedContentType = this.myfacesConfig.getDefaultResponseWriterContentTypeMode();
                            }
                        }
                    } else if (isAjaxRequest) {
                        selectedContentType = this.myfacesConfig.getDefaultResponseWriterContentTypeMode();
                    }
                    if (selectedContentType == null) {
                        throw new IllegalArgumentException("ContentTypeList does not contain a supported content type: " + (contentTypeListString != null ? contentTypeListString : contentTypeListStringFromAccept));
                    }
                }
            }
        }
        if (isAjaxRequest) {
            writerContentType = selectedContentType.contains("application/xhtml+xml") ? "application/xhtml+xml" : "text/html";
        } else {
            String string = writerContentType = ContentTypeUtils.isXHTMLContentType(selectedContentType) ? "application/xhtml+xml" : "text/html";
        }
        if (characterEncoding == null) {
            characterEncoding = "ISO-8859-1";
        }
        if (this.myfacesConfig.isEarlyFlushEnabled()) {
            return new EarlyFlushHtmlResponseWriterImpl(writer, selectedContentType, characterEncoding, this.myfacesConfig.isWrapScriptContentWithXmlCommentTag(), writerContentType);
        }
        return new HtmlResponseWriterImpl(writer, selectedContentType, characterEncoding, this.myfacesConfig.isWrapScriptContentWithXmlCommentTag(), writerContentType);
    }

    public ResponseStream createResponseStream(OutputStream outputStream) {
        return new MyFacesResponseStream(outputStream);
    }

    private static class LazyRendererWrapper
    extends RendererWrapper {
        private String rendererClass;
        private Renderer delegate;

        public LazyRendererWrapper(String rendererClass) {
            this.rendererClass = rendererClass;
        }

        public Renderer getWrapped() {
            if (this.delegate == null) {
                this.delegate = (Renderer)ClassUtils.newInstance((Class)ClassUtils.simpleClassForName(this.rendererClass));
            }
            return this.delegate;
        }
    }

    private static class MyFacesResponseStream
    extends ResponseStream {
        private OutputStream output;

        public MyFacesResponseStream(OutputStream output) {
            this.output = output;
        }

        public void write(int b) throws IOException {
            this.output.write(b);
        }

        public void write(byte[] b) throws IOException {
            this.output.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.output.write(b, off, len);
        }

        public void flush() throws IOException {
            this.output.flush();
        }

        public void close() throws IOException {
            this.output.close();
        }
    }
}

