/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.component.search;

import jakarta.faces.component.UIComponent;
import jakarta.faces.component.search.SearchExpressionContext;
import jakarta.faces.component.search.SearchExpressionHint;
import jakarta.faces.component.search.SearchKeywordContext;
import jakarta.faces.component.search.SearchKeywordResolver;

public class AllSearchKeywordResolver
extends SearchKeywordResolver {
    public static final String ALL_KEYWORD = "all";

    @Override
    public void resolve(SearchKeywordContext expressionContext, UIComponent current, String keyword) {
        UIComponent parent = current.getParent();
        while (parent.getParent() != null) {
            parent = parent.getParent();
        }
        expressionContext.invokeContextCallback(parent);
    }

    @Override
    public boolean isResolverForKeyword(SearchExpressionContext searchExpressionContext, String keyword) {
        return ALL_KEYWORD.equalsIgnoreCase(keyword);
    }

    @Override
    public boolean isPassthrough(SearchExpressionContext searchExpressionContext, String keyword) {
        return searchExpressionContext.getExpressionHints() != null && searchExpressionContext.getExpressionHints().contains((Object)SearchExpressionHint.RESOLVE_CLIENT_SIDE);
    }

    @Override
    public boolean isLeaf(SearchExpressionContext searchExpressionContext, String keyword) {
        return true;
    }
}

