/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.spi.impl;

import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.myfaces.config.webparameters.MyfacesConfig;
import org.apache.myfaces.spi.InjectionProvider;
import org.apache.myfaces.spi.InjectionProviderFactory;
import org.apache.myfaces.spi.ServiceProviderFinderFactory;
import org.apache.myfaces.spi.impl.AllAnnotationInjectionProvider;
import org.apache.myfaces.spi.impl.NoAnnotationInjectionProvider;
import org.apache.myfaces.spi.impl.NoInjectionAnnotationInjectionProvider;
import org.apache.myfaces.spi.impl.ResourceAnnotationInjectionProvider;
import org.apache.myfaces.util.lang.ClassUtils;

public class DefaultInjectionProviderFactory
extends InjectionProviderFactory {
    private static Logger log = Logger.getLogger(DefaultInjectionProviderFactory.class.getName());
    public static final String INJECTION_PROVIDER_INSTANCE_KEY = InjectionProvider.class.getName() + ".INJECTION_PROVIDER_INSTANCE";

    @Override
    public InjectionProvider getInjectionProvider(ExternalContext externalContext) {
        InjectionProvider instance = null;
        if (externalContext == null) {
            log.info("No ExternalContext using fallback InjectionProvider.");
            instance = this.resolveFallbackInjectionProvider();
        } else {
            instance = (InjectionProvider)externalContext.getApplicationMap().get(INJECTION_PROVIDER_INSTANCE_KEY);
        }
        if (instance == null) {
            if (!this.resolveInjectionProviderFromExternalContext(externalContext)) {
                if (!this.resolveInjectionProviderFromService(externalContext)) {
                    instance = this.resolveFallbackInjectionProvider();
                    externalContext.getApplicationMap().put(INJECTION_PROVIDER_INSTANCE_KEY, instance);
                } else {
                    instance = (InjectionProvider)externalContext.getApplicationMap().get(INJECTION_PROVIDER_INSTANCE_KEY);
                }
            } else {
                instance = (InjectionProvider)externalContext.getApplicationMap().get(INJECTION_PROVIDER_INSTANCE_KEY);
            }
            log.fine("Using InjectionProvider " + instance.getClass().getName());
        }
        return instance;
    }

    @Override
    public void release() {
    }

    private boolean resolveInjectionProviderFromExternalContext(ExternalContext externalContext) {
        try {
            Object obj;
            String injectionProvider = externalContext.getInitParameter(MyfacesConfig.INJECTION_PROVIDER);
            if (injectionProvider != null && (obj = this.createClass(injectionProvider, externalContext)) instanceof InjectionProvider) {
                externalContext.getApplicationMap().put(INJECTION_PROVIDER_INSTANCE_KEY, obj);
                return true;
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | InvocationTargetException e) {
            log.log(Level.SEVERE, "", e);
        }
        return false;
    }

    private boolean resolveInjectionProviderFromService(ExternalContext externalContext) {
        try {
            List<String> classList = ServiceProviderFinderFactory.getServiceProviderFinder(externalContext).getServiceProviderList(MyfacesConfig.INJECTION_PROVIDER);
            for (String className : classList) {
                InjectionProvider discoverableInjectionProvider;
                Object obj = this.createClass(className, externalContext);
                if (!InjectionProvider.class.isAssignableFrom(obj.getClass()) || !(discoverableInjectionProvider = (InjectionProvider)obj).isAvailable()) continue;
                externalContext.getApplicationMap().put(INJECTION_PROVIDER_INSTANCE_KEY, discoverableInjectionProvider);
                return true;
            }
        }
        catch (ClassNotFoundException | NoClassDefFoundError classList) {
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            log.log(Level.SEVERE, "", e);
        }
        return false;
    }

    private Object createClass(String className, ExternalContext externalContext) throws InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        Class clazz = ClassUtils.classForName(className);
        try {
            return ClassUtils.newInstance(clazz, new Class[]{ExternalContext.class}, externalContext);
        }
        catch (NoSuchMethodException e) {
            return ClassUtils.newInstance(clazz);
        }
    }

    private InjectionProvider resolveFallbackInjectionProvider() {
        return this.resolveFallbackInjectionProvider(FacesContext.getCurrentInstance().getExternalContext());
    }

    private InjectionProvider resolveFallbackInjectionProvider(ExternalContext externalContext) {
        try {
            ClassUtils.classForName("jakarta.annotation.PreDestroy");
        }
        catch (ClassNotFoundException e) {
            return new NoAnnotationInjectionProvider();
        }
        try {
            InitialContext context = new InitialContext();
            try {
                ClassUtils.classForName("jakarta.ejb.EJB");
                return new AllAnnotationInjectionProvider(context);
            }
            catch (ClassNotFoundException e) {
                return new ResourceAnnotationInjectionProvider(context);
            }
        }
        catch (NamingException e) {
            log.log(Level.SEVERE, "No InitialContext found. Using NoInjectionAnnotationProcessor.", e);
            return new NoInjectionAnnotationInjectionProvider();
        }
        catch (NoClassDefFoundError e) {
            log.log(Level.SEVERE, "No InitialContext class definition found. Using NoInjectionAnnotationProcessor.");
            return new NoInjectionAnnotationInjectionProvider();
        }
    }
}

