/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.core.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.apache.myfaces.extensions.cdi.core.api.config.AbstractAttributeAware;
import org.apache.myfaces.extensions.cdi.core.api.config.CodiConfig;
import org.apache.myfaces.extensions.cdi.core.api.config.CodiCoreConfig;
import org.apache.myfaces.extensions.cdi.core.api.config.ConfigEntry;
import org.apache.myfaces.extensions.cdi.core.impl.util.ProxyUtils;

public abstract class AbstractStartupObserver {
    protected Logger logger = Logger.getLogger(this.getClass().getName());
    @Inject
    protected CodiCoreConfig codiCoreConfig;
    protected String separator = System.getProperty("line.separator");

    protected String getConfigInfo(CodiConfig config) {
        StringBuilder info = new StringBuilder();
        ArrayList<String> methodNames = new ArrayList<String>();
        for (Class currentClass = ProxyUtils.getUnproxiedClass(config.getClass()); currentClass != null && !Object.class.getName().equals(currentClass.getName()) && !AbstractAttributeAware.class.getName().equals(currentClass.getName()); currentClass = currentClass.getSuperclass()) {
            info.append("config implementation: ");
            info.append(currentClass.getName());
            info.append(this.separator);
            for (Method currentMethod : currentClass.getDeclaredMethods()) {
                if (!currentMethod.isAnnotationPresent(ConfigEntry.class) || methodNames.contains(currentMethod.getName())) continue;
                methodNames.add(currentMethod.getName());
                info.append("   method:\t").append(currentMethod.getName());
                info.append(this.separator);
                try {
                    Object value = currentMethod.invoke((Object)config, new Object[0]);
                    info.append("   value:\t").append(value.toString());
                }
                catch (IllegalAccessException e) {
                    info.append("   value:\t[unknown]");
                }
                catch (InvocationTargetException e) {
                    info.append("   value: [unknown]");
                }
                info.append(this.separator);
                info.append(this.separator);
            }
        }
        return info.toString();
    }
}

