/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.core.impl.provider;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.enterprise.inject.Typed;
import org.apache.myfaces.extensions.cdi.core.api.InvocationOrder;
import org.apache.myfaces.extensions.cdi.core.api.UnhandledException;
import org.apache.myfaces.extensions.cdi.core.api.provider.ServiceProvider;
import org.apache.myfaces.extensions.cdi.core.api.provider.ServiceProviderContext;
import org.apache.myfaces.extensions.cdi.core.api.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Typed
@InvocationOrder(value=100)
public class SimpleServiceProvider<T>
extends ServiceProvider<T> {
    protected List<Class<?>> foundServiceClasses = new ArrayList();

    protected SimpleServiceProvider(Class<T> serviceType, ServiceProviderContext serviceProviderContext) {
        super(serviceType, serviceProviderContext);
    }

    protected List<T> loadServiceImplementations() {
        List<Class<?>> result = this.resolveServiceImplementations();
        if (result == null) {
            return Collections.emptyList();
        }
        ArrayList<T> foundServices = new ArrayList<T>();
        for (Class<?> serviceClass : result) {
            foundServices.add(this.createInstance(serviceClass));
        }
        return foundServices;
    }

    protected List<Class<?>> resolveServiceImplementations() {
        for (URL configFile : this.getConfigFileList()) {
            this.loadConfiguredServices(configFile);
        }
        return this.foundServiceClasses;
    }

    protected List<URL> getConfigFileList() {
        ArrayList<URL> serviceFiles = new ArrayList<URL>();
        try {
            String configFileLocation = this.getConfigFileLocation();
            Enumeration<URL> serviceFileEnumerator = this.serviceProviderContext.getClassLoader().getResources(configFileLocation);
            if (!serviceFileEnumerator.hasMoreElements()) {
                serviceFileEnumerator = ((Object)((Object)this)).getClass().getClassLoader().getResources(configFileLocation);
            }
            while (serviceFileEnumerator.hasMoreElements()) {
                serviceFiles.add(serviceFileEnumerator.nextElement());
            }
        }
        catch (Exception e) {
            throw new UnhandledException("Failed to load " + this.serviceType.getName() + " configured in " + this.getConfigFileLocation(), (Throwable)e);
        }
        return serviceFiles;
    }

    protected String getConfigFileLocation() {
        return "META-INF/services/" + this.serviceType.getName();
    }

    protected void loadConfiguredServices(URL serviceFile) {
        InputStream inputStream = null;
        try {
            String serviceClassName;
            inputStream = serviceFile.openStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            while ((serviceClassName = bufferedReader.readLine()) != null) {
                if ("".equals(serviceClassName = this.extractConfiguredServiceClassName(serviceClassName))) continue;
                this.loadService(serviceClassName);
            }
        }
        catch (Exception e) {
            throw new UnhandledException("Failed to process service-config: " + serviceFile, (Throwable)e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception e) {
                    throw new UnhandledException("Failed to close " + serviceFile, (Throwable)e);
                }
            }
        }
    }

    protected String extractConfiguredServiceClassName(String currentConfigLine) {
        int startOfComment = currentConfigLine.indexOf(35);
        if (startOfComment > -1) {
            currentConfigLine = currentConfigLine.substring(0, startOfComment);
        }
        return currentConfigLine.trim();
    }

    protected void loadService(String serviceClassName) {
        Class<T> serviceClass = this.loadClass(serviceClassName);
        if (serviceClass != null && !this.foundServiceClasses.contains(serviceClass) && this.isServiceSupported(serviceClass)) {
            this.foundServiceClasses.add(serviceClass);
        } else if (serviceClass == null) {
            throw new IllegalStateException(serviceClassName + " couldn't be loaded. " + "Please ensure that this class is in the classpath or remove the entry from " + this.getConfigFileLocation() + ".");
        }
    }

    protected boolean isServiceSupported(Class<T> serviceClass) {
        return true;
    }

    protected Class<? extends T> loadClass(String serviceClassName) {
        Class<?> targetClass = ClassUtils.tryToLoadClassForName((String)serviceClassName);
        if (targetClass == null && (targetClass = SimpleServiceProvider.loadClassForName(serviceClassName, this.serviceProviderContext.getClassLoader())) == null && (targetClass = SimpleServiceProvider.loadClassForName(serviceClassName, ClassUtils.getClassLoader(null))) == null) {
            return null;
        }
        return targetClass.asSubclass(this.serviceType);
    }

    protected static Class<?> loadClassForName(String serviceClassName, ClassLoader classLoader) {
        if (classLoader == null) {
            return null;
        }
        try {
            return classLoader.loadClass(serviceClassName);
        }
        catch (Exception e) {
            return SimpleServiceProvider.loadClassForName(serviceClassName, classLoader.getParent());
        }
    }

    protected T createInstance(Class<?> serviceClass) {
        try {
            Constructor<?> constructor = serviceClass.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return (T)constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public String toString() {
        return "Config file: " + this.getConfigFileLocation();
    }
}

