/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.jsf.impl.scope.conversation;

import java.util.Collection;
import java.util.Date;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.apache.myfaces.extensions.cdi.core.api.scope.conversation.config.WindowContextConfig;
import org.apache.myfaces.extensions.cdi.core.impl.scope.conversation.spi.WindowContextManager;
import org.apache.myfaces.extensions.cdi.jsf.impl.scope.conversation.spi.EditableWindowContext;
import org.apache.myfaces.extensions.cdi.jsf.impl.scope.conversation.spi.EditableWindowContextManager;
import org.apache.myfaces.extensions.cdi.jsf.impl.scope.conversation.spi.WindowContextQuotaHandler;
import org.apache.myfaces.extensions.cdi.jsf.impl.util.ConversationUtils;
import org.apache.myfaces.extensions.cdi.jsf.impl.util.ExceptionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ApplicationScoped
public class DefaultWindowContextQuotaHandler
implements WindowContextQuotaHandler {
    private static final long serialVersionUID = 4354405166761604711L;
    private int maxWindowContextCount;

    public DefaultWindowContextQuotaHandler() {
    }

    @Inject
    public DefaultWindowContextQuotaHandler(WindowContextConfig windowContextConfig) {
        this.maxWindowContextCount = windowContextConfig.getMaxWindowContextCount();
    }

    @Override
    public boolean isWindowContextQuotaViolated(int activeWindowContextCount) {
        return this.maxWindowContextCount < activeWindowContextCount;
    }

    @Override
    public void handleQuotaViolation() {
        if (!this.cleanupWindowContext()) {
            throw ExceptionUtils.tooManyOpenWindowException();
        }
    }

    private boolean cleanupWindowContext() {
        WindowContextManager windowContextManager = ConversationUtils.getWindowContextManager();
        if (windowContextManager instanceof EditableWindowContextManager) {
            EditableWindowContextManager editableWindowContextManager = (EditableWindowContextManager)windowContextManager;
            Collection<EditableWindowContext> activeWindowContexts = editableWindowContextManager.getWindowContexts();
            int activeWindowContextCountBeforeCleanup = activeWindowContexts.size();
            this.removeEldestWindowContext(editableWindowContextManager, activeWindowContexts);
            if (activeWindowContextCountBeforeCleanup > editableWindowContextManager.getWindowContexts().size()) {
                return true;
            }
        }
        return false;
    }

    private void removeEldestWindowContext(EditableWindowContextManager editableWindowContextManager, Collection<EditableWindowContext> activeWindowContexts) {
        EditableWindowContext windowContextToRemove = this.findEldestWindowContext(activeWindowContexts);
        if (windowContextToRemove != null) {
            editableWindowContextManager.closeWindowContext(windowContextToRemove);
        }
    }

    private EditableWindowContext findEldestWindowContext(Collection<EditableWindowContext> activeWindowContexts) {
        Date lastAccess = new Date();
        EditableWindowContext result = null;
        for (EditableWindowContext windowContext : activeWindowContexts) {
            if (!lastAccess.after(windowContext.getLastAccess())) continue;
            lastAccess = windowContext.getLastAccess();
            result = windowContext;
        }
        return result;
    }
}

