/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.jsf.impl.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.inject.Typed;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import org.apache.myfaces.extensions.cdi.core.api.config.view.ViewConfig;
import org.apache.myfaces.extensions.cdi.core.api.provider.BeanManagerProvider;
import org.apache.myfaces.extensions.cdi.core.api.scope.conversation.ConversationRequired;
import org.apache.myfaces.extensions.cdi.core.api.scope.conversation.config.ConversationConfig;
import org.apache.myfaces.extensions.cdi.core.impl.util.AnyLiteral;
import org.apache.myfaces.extensions.cdi.core.impl.util.CodiUtils;
import org.apache.myfaces.extensions.cdi.jsf.api.config.view.PageBeanDescriptor;
import org.apache.myfaces.extensions.cdi.jsf.api.config.view.ViewConfigDescriptor;
import org.apache.myfaces.extensions.cdi.jsf.impl.config.view.ViewConfigCache;
import org.apache.myfaces.extensions.cdi.jsf.impl.scope.conversation.spi.EditableWindowContext;
import org.apache.myfaces.extensions.cdi.jsf.impl.util.ConversationUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Typed
public abstract class ConversationRequiredUtils {
    private ConversationRequiredUtils() {
    }

    public static void ensureExistingConversation(FacesContext facesContext) {
        UIViewRoot newViewRoot;
        String oldViewId = ConversationRequiredUtils.getViewId(facesContext);
        if (oldViewId == null) {
            return;
        }
        ViewConfigDescriptor entry = ViewConfigCache.getViewConfigDescriptor(oldViewId);
        if (entry == null) {
            return;
        }
        BeanManager beanManager = BeanManagerProvider.getInstance().getBeanManager();
        ConversationConfig conversationConfig = (ConversationConfig)CodiUtils.getContextualReferenceByClass((BeanManager)beanManager, ConversationConfig.class, (Annotation[])new Annotation[0]);
        if (!conversationConfig.isConversationRequiredEnabled()) {
            return;
        }
        String newViewId = ConversationRequiredUtils.checkConversationRequired(beanManager, entry);
        if (newViewId != null && !oldViewId.equals(newViewId) && (newViewRoot = facesContext.getApplication().getViewHandler().createView(facesContext, newViewId)) != null) {
            facesContext.setViewRoot(newViewRoot);
        }
    }

    private static String checkConversationRequired(BeanManager beanManager, ViewConfigDescriptor viewConfigDescriptor) {
        Class currentView = viewConfigDescriptor.getViewConfig();
        List pageBeanDescriptorList = viewConfigDescriptor.getPageBeanDescriptors();
        for (PageBeanDescriptor pageBeanDescriptor : pageBeanDescriptorList) {
            Class pageBeanClass = pageBeanDescriptor.getBeanClass();
            ConversationRequired conversationRequired = ConversationRequiredUtils.resolveConversationRequiredAnnotation(viewConfigDescriptor, pageBeanDescriptorList, pageBeanClass);
            if (conversationRequired == null || ConversationRequiredUtils.isEntryPoint(currentView, conversationRequired.defaultEntryPoint(), conversationRequired.entryPoints())) continue;
            EditableWindowContext editableWindowContext = (EditableWindowContext)ConversationUtils.getWindowContextManager().getCurrentWindowContext();
            Set foundBeans = beanManager.getBeans((Type)pageBeanDescriptor.getBeanClass(), new Annotation[]{new AnyLiteral()});
            for (Bean currentBean : foundBeans) {
                Class<?> conversationGroup;
                HashSet<Bean> beanSet = new HashSet<Bean>(1);
                beanSet.add(currentBean);
                Bean foundBean = beanManager.resolve(beanSet);
                if (!pageBeanDescriptor.getBeanName().equals(foundBean.getName()) || editableWindowContext.isConversationActive(conversationGroup = ConversationRequiredUtils.getConversationGroup(conversationRequired, foundBean), foundBean.getQualifiers().toArray(new Annotation[foundBean.getQualifiers().size()]))) continue;
                return ViewConfigCache.getViewConfigDescriptor(conversationRequired.defaultEntryPoint()).getViewId();
            }
        }
        return null;
    }

    private static Class<?> getConversationGroup(ConversationRequired conversationRequired, Bean<?> foundBean) {
        Class conversationGroup = ConversationRequired.class.equals((Object)conversationRequired.conversationGroup()) ? ConversationUtils.getConversationGroup(foundBean) : conversationRequired.conversationGroup();
        return conversationGroup;
    }

    private static ConversationRequired resolveConversationRequiredAnnotation(ViewConfigDescriptor viewConfigDescriptor, List<PageBeanDescriptor> pageBeanDescriptorList, Class<?> pageBeanClass) {
        List conversationRequiredMetaData;
        ConversationRequired conversationRequired = pageBeanClass.getAnnotation(ConversationRequired.class);
        if (conversationRequired == null && pageBeanDescriptorList.size() == 1 && (conversationRequiredMetaData = viewConfigDescriptor.getMetaData(ConversationRequired.class)).size() == 1) {
            conversationRequired = (ConversationRequired)conversationRequiredMetaData.iterator().next();
        }
        return conversationRequired;
    }

    private static boolean isEntryPoint(Class<? extends ViewConfig> currentView, Class<? extends ViewConfig> defaultEntryPoint, Class<? extends ViewConfig>[] entryPoints) {
        if (currentView.equals(defaultEntryPoint)) {
            return true;
        }
        for (Class<? extends ViewConfig> entryPoint : entryPoints) {
            if (!currentView.equals(entryPoint)) continue;
            return true;
        }
        return false;
    }

    private static String getViewId(FacesContext facesContext) {
        UIViewRoot uiViewRoot = facesContext.getViewRoot();
        if (uiViewRoot == null) {
            return null;
        }
        return uiViewRoot.getViewId();
    }
}

