/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.bv.impl;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.inject.Typed;
import javax.validation.Validation;
import javax.validation.ValidatorFactory;
import org.apache.myfaces.extensions.cdi.core.api.util.ClassUtils;

@Typed
class ValidatorFactoryStorage {
    private static Map<ClassLoader, ValidatorFactory> defaultValidatorFactoryCache = new ConcurrentHashMap<ClassLoader, ValidatorFactory>();

    private ValidatorFactoryStorage() {
    }

    static ValidatorFactory getOrCreateValidatorFactory() {
        ClassLoader classLoader = ValidatorFactoryStorage.getClassLoader();
        ValidatorFactory defaultValidatorFactory = defaultValidatorFactoryCache.get(classLoader);
        if (defaultValidatorFactory == null) {
            defaultValidatorFactory = Validation.buildDefaultValidatorFactory();
            defaultValidatorFactoryCache.put(classLoader, defaultValidatorFactory);
        }
        return defaultValidatorFactory;
    }

    private static ClassLoader getClassLoader() {
        return ClassUtils.getClassLoader(null);
    }
}

