/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator.generic.renderkit;

import java.lang.reflect.Method;
import java.util.logging.Level;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.render.Renderer;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.apache.myfaces.extensions.validator.core.renderkit.ExtValRendererWrapper;
import org.apache.myfaces.extensions.validator.internal.UsageCategory;
import org.apache.myfaces.extensions.validator.internal.UsageInformation;
import org.apache.myfaces.extensions.validator.util.ProxyUtils;

@UsageInformation(value={UsageCategory.INTERNAL})
public final class ExtValGenericRendererWrapper
extends ExtValRendererWrapper
implements MethodInterceptor {
    public static Renderer newInstance(Renderer renderer) {
        Class<?> currentClass = renderer.getClass();
        if (ProxyUtils.isProxiedClass(currentClass)) {
            return renderer;
        }
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(renderer.getClass());
        enhancer.setCallback((Callback)new ExtValGenericRendererWrapper(renderer));
        enhancer.setClassLoader(Thread.currentThread().getContextClassLoader());
        return (Renderer)enhancer.create();
    }

    public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
        if (method.getName().equals("getConvertedValue") && args[1] instanceof UIComponent && method.getParameterTypes().length == 3) {
            return this.getConvertedValue((FacesContext)args[0], (UIComponent)args[1], args[2]);
        }
        if (method.getName().equals("decode") && args[1] instanceof UIComponent) {
            this.decode((FacesContext)args[0], (UIComponent)args[1]);
        } else if (method.getName().equals("encodeBegin") && args[1] instanceof UIComponent) {
            this.encodeBegin((FacesContext)args[0], (UIComponent)args[1]);
        } else if (method.getName().equals("encodeChildren") && args[1] instanceof UIComponent) {
            this.encodeChildren((FacesContext)args[0], (UIComponent)args[1]);
        } else if (method.getName().equals("encodeEnd") && args[1] instanceof UIComponent) {
            this.encodeEnd((FacesContext)args[0], (UIComponent)args[1]);
        } else {
            if (method.getName().equals("convertClientId") && args[1] instanceof String) {
                return this.convertClientId((FacesContext)args[0], (String)args[1]);
            }
            if (method.getName().equals("getRendersChildren")) {
                return this.getRendersChildren();
            }
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest("method " + method.getName() + " called without rendering-interceptors");
            }
            try {
                method.setAccessible(true);
                return method.invoke((Object)this.wrapped, args);
            }
            catch (Throwable t) {
                return proxy.invokeSuper(obj, args);
            }
        }
        return null;
    }

    public ExtValGenericRendererWrapper(Renderer wrapped) {
        super(wrapped);
    }
}

