/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator.trinidad.interceptor;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.apache.myfaces.extensions.validator.core.InvocationOrder;
import org.apache.myfaces.extensions.validator.core.interceptor.ComponentInitializationAwareMetaDataExtractionInterceptor;
import org.apache.myfaces.extensions.validator.core.metadata.MetaDataEntry;
import org.apache.myfaces.extensions.validator.core.property.PropertyInformation;
import org.apache.myfaces.extensions.validator.core.validation.parameter.DisableClientSideValidation;
import org.apache.myfaces.extensions.validator.internal.UsageCategory;
import org.apache.myfaces.extensions.validator.internal.UsageInformation;
import org.apache.myfaces.extensions.validator.util.ExtValUtils;

@InvocationOrder(value=300)
@UsageInformation(value={UsageCategory.INTERNAL})
public class TrinidadMetaDataExtractionInterceptor
extends ComponentInitializationAwareMetaDataExtractionInterceptor {
    protected void afterExtractingForComponentInitialization(PropertyInformation propertyInformation) {
        this.processMetaDataEntries(propertyInformation.getMetaDataEntries());
    }

    private void processMetaDataEntries(MetaDataEntry[] metaDataEntries) {
        for (MetaDataEntry entry : metaDataEntries) {
            if (!this.processEntry(entry) || !this.isClientValidationDisabled(entry)) continue;
            this.disableClientSideValidation(entry);
        }
    }

    private boolean processEntry(MetaDataEntry entry) {
        return entry.getValue() instanceof Annotation;
    }

    private boolean isClientValidationDisabled(MetaDataEntry entry) {
        return ExtValUtils.getValidationParameterExtractor().extract((Annotation)entry.getValue(Annotation.class), (Object)ExtValUtils.getValidationParameterClassFor(DisableClientSideValidation.class)).iterator().hasNext();
    }

    private void disableClientSideValidation(MetaDataEntry entry) {
        if (entry.getProperty("disable_client_side_validation") == null) {
            entry.setProperty("disable_client_side_validation", new ArrayList());
        }
        List keysToDisable = (List)entry.getProperty("disable_client_side_validation", List.class);
        keysToDisable.add(entry.getKey());
    }
}

