/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator.core.el;

import java.io.Externalizable;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.logging.Logger;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.CompositeComponentExpressionHolder;
import javax.faces.el.ValueBinding;
import org.apache.myfaces.extensions.validator.core.ExtValCoreConfiguration;
import org.apache.myfaces.extensions.validator.core.JsfProjectStage;
import org.apache.myfaces.extensions.validator.core.el.ELHelper;
import org.apache.myfaces.extensions.validator.core.el.ExtValELResolver;
import org.apache.myfaces.extensions.validator.core.el.FaceletsTaglibExpressionHelper;
import org.apache.myfaces.extensions.validator.core.el.ValueBindingExpression;
import org.apache.myfaces.extensions.validator.core.property.PropertyDetails;
import org.apache.myfaces.extensions.validator.internal.Priority;
import org.apache.myfaces.extensions.validator.internal.ToDo;
import org.apache.myfaces.extensions.validator.internal.UsageCategory;
import org.apache.myfaces.extensions.validator.internal.UsageInformation;
import org.apache.myfaces.extensions.validator.util.ProxyUtils;
import org.apache.myfaces.extensions.validator.util.ReflectionUtils;

@UsageInformation(value={UsageCategory.INTERNAL})
public class DefaultELHelper
implements ELHelper {
    private static final boolean DEACTIVATE_EL_RESOLVER = ExtValCoreConfiguration.get().deactivateElResolver();
    protected final Logger logger = Logger.getLogger(this.getClass().getName());
    protected final boolean projectStageDevelopment = JsfProjectStage.is(JsfProjectStage.Development);

    public DefaultELHelper() {
        this.logger.fine(this.getClass().getName() + " instantiated");
    }

    public Class getTypeOfExpression(FacesContext facesContext, ValueBindingExpression valueBindingExpression) {
        Object bean = this.getValueOfExpression(facesContext, valueBindingExpression);
        return bean != null ? ProxyUtils.getUnproxiedClass(bean.getClass()) : null;
    }

    public Object getBean(String beanName) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        return facesContext.getApplication().getELResolver().getValue(facesContext.getELContext(), null, (Object)beanName);
    }

    public Object getValueOfExpression(FacesContext facesContext, ValueBindingExpression valueBindingExpression) {
        return valueBindingExpression != null ? facesContext.getApplication().evaluateExpressionGet(facesContext, valueBindingExpression.getExpressionString(), Object.class) : null;
    }

    public boolean isELTermValid(FacesContext facesContext, String valueBindingExpression) {
        try {
            facesContext.getApplication().evaluateExpressionGet(facesContext, valueBindingExpression, Object.class);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private ValueBindingExpression getValueBindingExpression(UIComponent uiComponent, boolean allowBlankCharacters) {
        FacesContext facesContext;
        String valueBindingExpression = DefaultELHelper.getOriginalValueBindingExpression(uiComponent);
        if (valueBindingExpression == null) {
            this.logger.finest(uiComponent.getClass() + " has no value binding - component id: " + uiComponent.getId());
            return null;
        }
        if (!allowBlankCharacters) {
            valueBindingExpression = valueBindingExpression.replace(" ", "");
        }
        if (this.getTypeOfExpression(facesContext = FacesContext.getCurrentInstance(), new ValueBindingExpression(valueBindingExpression).getBaseExpression()) == null) {
            ValueBindingExpression result = FaceletsTaglibExpressionHelper.tryToCreateValueBindingForFaceletsBinding(uiComponent);
            if (result == null) {
                this.logger.fine("couldn't resolve expression: " + valueBindingExpression);
                return null;
            }
            Class entityClass = this.getTypeOfExpression(facesContext, result.getBaseExpression());
            if (entityClass == null) {
                this.logger.fine("couldn't resolve expression: " + result.getExpressionString());
                return null;
            }
            return result;
        }
        return new ValueBindingExpression(valueBindingExpression);
    }

    public PropertyDetails getPropertyDetailsOfValueBinding(UIComponent uiComponent) {
        if (DEACTIVATE_EL_RESOLVER) {
            return this.getPropertyDetailsViaReflectionFallback(uiComponent);
        }
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ValueExpression valueExpression = uiComponent.getValueExpression("value");
        if (valueExpression == null) {
            return null;
        }
        ExtValELResolver elResolver = this.createExtValELResolver(facesContext);
        this.inspectTarget(valueExpression, ExtValELResolver.createContextWrapper(facesContext.getELContext(), elResolver), false);
        ExtValELResolver compositeComponentELResolver = null;
        while (elResolver.getBaseObject() instanceof CompositeComponentExpressionHolder) {
            ValueExpression newValueExpression = ((CompositeComponentExpressionHolder)elResolver.getBaseObject()).getExpression(elResolver.getProperty());
            if (newValueExpression == null) continue;
            elResolver = this.createExtValELResolver(facesContext);
            this.inspectTarget(newValueExpression, ExtValELResolver.createContextWrapper(facesContext.getELContext(), elResolver), false);
        }
        if (elResolver.getCompositeComponentExpression() != null) {
            ValueExpression compositeExpression = elResolver.getCompositeComponentExpression();
            compositeComponentELResolver = this.createExtValELResolver(facesContext);
            this.inspectTarget(compositeExpression, ExtValELResolver.createContextWrapper(facesContext.getELContext(), compositeComponentELResolver), true);
        }
        if (elResolver.getPath() == null || elResolver.getBaseObject() == null || elResolver.getProperty() == null) {
            return null;
        }
        String key = compositeComponentELResolver != null ? compositeComponentELResolver.getPath() + elResolver.getPath().substring(elResolver.getPath().indexOf(".")) : elResolver.getPath();
        return new PropertyDetails(key, elResolver.getBaseObject(), elResolver.getProperty());
    }

    private void inspectTarget(ValueExpression valueExpression, ELContext elContext, boolean inspectCompositeComponent) {
        block2: {
            try {
                valueExpression.setValue(elContext, null);
            }
            catch (Exception e) {
                if (!inspectCompositeComponent) break block2;
                throw new IllegalStateException("error at binding: " + valueExpression.getExpressionString() + " -- an el-resolver error occurred! maybe you used an invalid binding.", e);
            }
        }
    }

    private ExtValELResolver createExtValELResolver(FacesContext facesContext) {
        return new ExtValELResolver(facesContext.getApplication().getELResolver(), this.projectStageDevelopment);
    }

    protected PropertyDetails getPropertyDetailsViaReflectionFallback(UIComponent uiComponent) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ValueBindingExpression valueBindingExpression = this.getValueBindingExpression(uiComponent, false);
        ValueBindingExpression currentValueBindingExpression = new ValueBindingExpression(valueBindingExpression.getExpressionString());
        String path = null;
        while (currentValueBindingExpression.getBaseExpression() != null) {
            path = path == null ? this.getPropertyName(currentValueBindingExpression) : this.getPropertyName(currentValueBindingExpression) + "." + path;
            currentValueBindingExpression = currentValueBindingExpression.getBaseExpression();
        }
        path = currentValueBindingExpression.getProperty() + "." + path;
        Object baseObject = this.getValueOfExpression(facesContext, valueBindingExpression.getBaseExpression());
        return new PropertyDetails(path, baseObject, this.getPropertyName(valueBindingExpression));
    }

    private String getPropertyName(ValueBindingExpression valueBindingExpression) {
        String propertyName = valueBindingExpression.getProperty();
        if (propertyName.contains(".")) {
            propertyName = this.extractPropertyNameOfPropertyPath(propertyName);
        }
        return propertyName;
    }

    @ToDo(value=Priority.MEDIUM, description="support for more dynamic bindings - details see inline")
    private String extractPropertyNameOfPropertyPath(String propertyChain) {
        String[] properties = propertyChain.split("\\.");
        Object currentPropertyValue = this.getBean(properties[0]);
        for (int i = 1; i < properties.length; ++i) {
            String currentPropertyName = properties[i];
            Class currentClassOfPropertyValue = ProxyUtils.getUnproxiedClass(currentPropertyValue.getClass());
            Method currentMethod = ReflectionUtils.tryToGetMethod(currentClassOfPropertyValue, "get" + currentPropertyName.substring(0, 1).toUpperCase() + currentPropertyName.substring(1));
            if (currentMethod == null && currentPropertyValue instanceof Map) {
                ((Map)currentPropertyValue).get(currentPropertyName);
                continue;
            }
            currentPropertyValue = ReflectionUtils.tryToInvokeMethod(currentPropertyValue, currentMethod);
        }
        if (currentPropertyValue instanceof String) {
            return (String)currentPropertyValue;
        }
        this.logger.severe("unexpected value within map syntax: " + propertyChain + " last property name: " + currentPropertyValue);
        return null;
    }

    static String getOriginalValueBindingExpression(UIComponent uiComponent) {
        ValueExpression valueExpression = uiComponent.getValueExpression("value");
        return valueExpression != null ? valueExpression.getExpressionString() : null;
    }

    public boolean isELTermWellFormed(Object o) {
        if (o instanceof ValueBinding || o instanceof Externalizable) {
            return false;
        }
        String s = o.toString();
        return (s.contains("#") || s.contains("$")) && s.contains("{") && s.contains("}");
    }

    public Object getBindingOfComponent(UIComponent uiComponent, String name) {
        return uiComponent.getValueExpression(name);
    }
}

