/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator.beanval.startup;

import javax.faces.event.PhaseListener;
import javax.validation.ValidatorFactory;
import org.apache.myfaces.extensions.validator.beanval.BeanValidationModuleValidationInterceptor;
import org.apache.myfaces.extensions.validator.beanval.HtmlCoreComponentsComponentInitializer;
import org.apache.myfaces.extensions.validator.beanval.MappedConstraintSourceBeanValidationModuleValidationInterceptor;
import org.apache.myfaces.extensions.validator.beanval.ValidatorFactoryProxy;
import org.apache.myfaces.extensions.validator.beanval.interceptor.BeanValidationViewRootInterceptor;
import org.apache.myfaces.extensions.validator.beanval.interceptor.ExtValBeanValidationMetaDataExtractionInterceptor;
import org.apache.myfaces.extensions.validator.beanval.metadata.transformer.mapper.NotNullNameMapper;
import org.apache.myfaces.extensions.validator.beanval.metadata.transformer.mapper.SizeNameMapper;
import org.apache.myfaces.extensions.validator.beanval.payload.DisableClientSideValidation;
import org.apache.myfaces.extensions.validator.beanval.payload.ViolationSeverity;
import org.apache.myfaces.extensions.validator.beanval.storage.DefaultModelValidationStorageManager;
import org.apache.myfaces.extensions.validator.beanval.storage.ModelValidationStorage;
import org.apache.myfaces.extensions.validator.beanval.storage.mapper.BeanValidationGroupStorageNameMapper;
import org.apache.myfaces.extensions.validator.beanval.storage.mapper.ModelValidationStorageNameMapper;
import org.apache.myfaces.extensions.validator.beanval.validation.ModelValidationPhaseListener;
import org.apache.myfaces.extensions.validator.core.ExtValContext;
import org.apache.myfaces.extensions.validator.core.ExtValCoreConfiguration;
import org.apache.myfaces.extensions.validator.core.factory.AbstractNameMapperAwareFactory;
import org.apache.myfaces.extensions.validator.core.factory.FactoryNames;
import org.apache.myfaces.extensions.validator.core.initializer.component.ComponentInitializer;
import org.apache.myfaces.extensions.validator.core.interceptor.MetaDataExtractionInterceptor;
import org.apache.myfaces.extensions.validator.core.interceptor.RendererInterceptor;
import org.apache.myfaces.extensions.validator.core.interceptor.ViewRootInterceptor;
import org.apache.myfaces.extensions.validator.core.mapper.NameMapper;
import org.apache.myfaces.extensions.validator.core.startup.AbstractStartupListener;
import org.apache.myfaces.extensions.validator.core.storage.GroupStorage;
import org.apache.myfaces.extensions.validator.core.storage.StorageManager;
import org.apache.myfaces.extensions.validator.core.storage.StorageManagerHolder;
import org.apache.myfaces.extensions.validator.internal.UsageCategory;
import org.apache.myfaces.extensions.validator.internal.UsageInformation;
import org.apache.myfaces.extensions.validator.util.ExtValUtils;
import org.apache.myfaces.extensions.validator.util.JsfUtils;

@UsageInformation(value={UsageCategory.INTERNAL})
public class BeanValidationStartupListener
extends AbstractStartupListener {
    private static final long serialVersionUID = -5025748399876833394L;

    protected void init() {
        this.registerValidatorFactory();
        this.registerViewRootInterceptors();
        this.registerBeanValidationInterceptors();
        this.registerMetaDataTransformerNameMapper();
        this.registerGroupStorageNameMapper();
        this.registerModelValidationStorageNameMapper();
        this.registerComponentInitializers();
        this.registerMetaDataExtractionInterceptors();
        this.registerPhaseListeners();
        this.registerViolationSeverityPayload();
        this.registerDisableClientSideValidationPayload();
    }

    protected void registerValidatorFactory() {
        ExtValContext.getContext().addGlobalProperty(ValidatorFactory.class.getName(), (Object)new ValidatorFactoryProxy(), false);
    }

    protected void registerViewRootInterceptors() {
        if (!ExtValCoreConfiguration.get().deactivateActionBasedGroupValidation()) {
            ExtValContext.getContext().addViewRootInterceptor((ViewRootInterceptor)new BeanValidationViewRootInterceptor());
        }
    }

    protected void registerBeanValidationInterceptors() {
        ExtValContext.getContext().registerRendererInterceptor((RendererInterceptor)new BeanValidationModuleValidationInterceptor());
        ExtValContext.getContext().registerRendererInterceptor((RendererInterceptor)new MappedConstraintSourceBeanValidationModuleValidationInterceptor());
    }

    protected void registerMetaDataTransformerNameMapper() {
        ExtValUtils.registerValidationStrategyToMetaDataTransformerNameMapper((NameMapper)new SizeNameMapper());
        ExtValUtils.registerValidationStrategyToMetaDataTransformerNameMapper((NameMapper)new NotNullNameMapper());
    }

    protected void registerGroupStorageNameMapper() {
        StorageManager storageManager = this.getStorageManagerHolder().getStorageManager(GroupStorage.class);
        if (storageManager instanceof AbstractNameMapperAwareFactory) {
            ((AbstractNameMapperAwareFactory)storageManager).register((NameMapper)new BeanValidationGroupStorageNameMapper());
        } else {
            this.logger.warning(storageManager.getClass().getName() + " has to implement AbstractNameMapperAwareFactory " + ((Object)((Object)this)).getClass().getName() + " couldn't register " + BeanValidationGroupStorageNameMapper.class.getName());
        }
    }

    protected void registerModelValidationStorageNameMapper() {
        DefaultModelValidationStorageManager modelValidationStorageManager = new DefaultModelValidationStorageManager();
        modelValidationStorageManager.register(new ModelValidationStorageNameMapper());
        this.getStorageManagerHolder().setStorageManager(ModelValidationStorage.class, (StorageManager)modelValidationStorageManager, false);
    }

    protected void registerComponentInitializers() {
        ExtValContext.getContext().addComponentInitializer((ComponentInitializer)new HtmlCoreComponentsComponentInitializer());
    }

    protected StorageManagerHolder getStorageManagerHolder() {
        return (StorageManagerHolder)ExtValContext.getContext().getFactoryFinder().getFactory(FactoryNames.STORAGE_MANAGER_FACTORY, StorageManagerHolder.class);
    }

    protected void registerMetaDataExtractionInterceptors() {
        ExtValContext.getContext().addMetaDataExtractionInterceptor((MetaDataExtractionInterceptor)new ExtValBeanValidationMetaDataExtractionInterceptor());
    }

    protected void registerPhaseListeners() {
        JsfUtils.registerPhaseListener((PhaseListener)new ModelValidationPhaseListener());
    }

    protected void registerViolationSeverityPayload() {
        ExtValContext extValContext = ExtValContext.getContext();
        extValContext.addGlobalProperty(ViolationSeverity.Info.class.getName(), ViolationSeverity.Info.class, false);
        extValContext.addGlobalProperty(ViolationSeverity.Warn.class.getName(), ViolationSeverity.Warn.class, false);
        extValContext.addGlobalProperty(ViolationSeverity.Fatal.class.getName(), ViolationSeverity.Fatal.class, false);
    }

    private void registerDisableClientSideValidationPayload() {
        ExtValContext.getContext().addGlobalProperty(DisableClientSideValidation.class.getName(), DisableClientSideValidation.class, false);
    }
}

