/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.orchestra.lib.jsf;

import java.util.Map;
import javax.faces.FacesException;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.orchestra.CoreConfig;
import org.apache.myfaces.orchestra.conversation.ConversationContext;
import org.apache.myfaces.orchestra.conversation.ConversationManager;
import org.apache.myfaces.orchestra.lib.jsf.RequestHandler;

class ContextLockRequestHandler
implements RequestHandler {
    private Log log = LogFactory.getLog(ContextLockRequestHandler.class);
    private ConversationContext context;
    private boolean lockAcquired = false;

    ContextLockRequestHandler() {
    }

    public void init(FacesContext facesContext) throws FacesException {
        if (this.getSerializeRequests(facesContext)) {
            ConversationManager manager = ConversationManager.getInstance(false);
            if (manager != null) {
                this.context = manager.getCurrentRootConversationContext();
                if (this.context != null) {
                    try {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)("Locking context " + this.context.getId()));
                        }
                        this.context.lockInterruptablyForCurrentThread();
                        this.lockAcquired = true;
                    }
                    catch (InterruptedException e) {
                        throw new FacesException((Throwable)e);
                    }
                } else {
                    this.log.debug((Object)"No conversation context specified for this request");
                }
            } else {
                this.log.debug((Object)"No conversation manager exists for this request");
            }
        }
    }

    public void deinit() throws FacesException {
        if (this.context != null) {
            if (this.lockAcquired) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Unlocking context " + this.context.getId()));
                }
                this.context.unlockForCurrentThread();
            } else {
                this.log.debug((Object)"Odd situation: lock never acquired. Perhaps InterruptedException occurred while waiting to get the context lock?");
            }
        }
    }

    private boolean getSerializeRequests(FacesContext facesContext) {
        ExternalContext ec = facesContext.getExternalContext();
        Map reqScope = ec.getRequestMap();
        Boolean serializeRequests = (Boolean)reqScope.get(CoreConfig.SERIALIZE_REQUESTS);
        if (serializeRequests != null) {
            return serializeRequests;
        }
        String value = ec.getInitParameter(CoreConfig.SERIALIZE_REQUESTS);
        return !"false".equals(value);
    }
}

