/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.myfaces.orchestra.urlParamNav;

import javax.faces.application.NavigationHandler;
import javax.faces.context.FacesContext;

/**
 * A navigation handler that exists only for backwards compatibility.
 * <p>
 * In orchestra-core 1.0 this class was necessary when using the UrlParameterViewHandler.
 * In release 1.1, all the functionality implemented here has been moved to the
 * UrlParameterViewHandler class and there is no longer anything here. However this class
 * has been left to avoid breaking faces-config.xml configurations that reference it.
 */
public class UrlParameterNavigationHandler extends NavigationHandler
{
    private final NavigationHandler original;

    public UrlParameterNavigationHandler(final NavigationHandler original)
    {
        this.original = original;
    }

    public void handleNavigation(final FacesContext context, String fromAction, String outcome)
    {
        original.handleNavigation(context, fromAction, outcome);
    }
}
