/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.orchestra.urlParamNav;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Locale;
import javax.faces.FacesException;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import org.apache.myfaces.orchestra.lib.OrchestraException;

public class UrlParameterViewHandler
extends ViewHandler {
    private static final Method CALC_CHAR_ENC_METHOD = UrlParameterViewHandler.getMethodOpt(ViewHandler.class, "calculateCharacterEncoding", new Class[]{FacesContext.class});
    private static final Method INIT_VIEW_METHOD = UrlParameterViewHandler.getMethodOpt(ViewHandler.class, "initView", new Class[]{FacesContext.class});
    private final ViewHandler original;

    private static Method getMethodOpt(Class clazz, String methodName, Class[] args) {
        try {
            return clazz.getMethod(methodName, args);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public UrlParameterViewHandler(ViewHandler original) {
        this.original = original;
    }

    public String calculateCharacterEncoding(FacesContext context) {
        try {
            Object ret = CALC_CHAR_ENC_METHOD.invoke((Object)this.original, context);
            return (String)ret;
        }
        catch (Exception e) {
            throw new OrchestraException("Unable to invoke calculateCharacterEncoding on wrapped ViewHandler");
        }
    }

    public void initView(FacesContext context) throws FacesException {
        try {
            INIT_VIEW_METHOD.invoke((Object)this.original, context);
        }
        catch (Exception e) {
            throw new OrchestraException("Unable to invoke initView on wrapped ViewHandler");
        }
    }

    public Locale calculateLocale(FacesContext context) {
        return this.original.calculateLocale(context);
    }

    public String calculateRenderKitId(FacesContext context) {
        return this.original.calculateRenderKitId(context);
    }

    public UIViewRoot createView(FacesContext context, String viewId) {
        return this.original.createView(context, viewId);
    }

    public String getActionURL(FacesContext context, String viewId) {
        int pos;
        if (viewId != null && (pos = (viewId = UrlParameterViewHandler.expandExpressions(context, viewId)).indexOf(63)) > -1) {
            String realViewId = viewId.substring(0, pos);
            String params = viewId.substring(pos);
            return this.original.getActionURL(context, realViewId) + params;
        }
        return this.original.getActionURL(context, viewId);
    }

    public String getResourceURL(FacesContext context, String path) {
        return this.original.getResourceURL(context, path);
    }

    public void renderView(FacesContext context, UIViewRoot viewToRender) throws IOException, FacesException {
        this.original.renderView(context, viewToRender);
    }

    public UIViewRoot restoreView(FacesContext context, String viewId) {
        return this.original.restoreView(context, viewId);
    }

    public void writeState(FacesContext context) throws IOException {
        this.original.writeState(context);
    }

    private static String expandExpressions(FacesContext context, String url) {
        int pos = url.indexOf("#{");
        if (pos > -1 && url.indexOf("}", pos) > -1) {
            ValueBinding vb = context.getApplication().createValueBinding(url);
            return (String)vb.getValue(context);
        }
        return url;
    }
}

