/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import org.apache.myfaces.tobago.internal.context.ResourceManagerFactory;
import org.apache.myfaces.tobago.renderkit.RendererBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRendererBaseWrapper
extends RendererBase {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractRendererBaseWrapper.class);

    @Override
    public final void onComponentCreated(FacesContext facesContext, UIComponent component, UIComponent parent) {
        this.getRenderer(facesContext).onComponentCreated(facesContext, component, parent);
    }

    @Override
    public final void prepareRender(FacesContext facesContext, UIComponent component) throws IOException {
        this.getRenderer(facesContext).prepareRender(facesContext, component);
    }

    @Override
    public final boolean getPrepareRendersChildren() {
        return this.getRenderer(FacesContext.getCurrentInstance()).getPrepareRendersChildren();
    }

    @Override
    public final void prepareRendersChildren(FacesContext context, UIComponent component) throws IOException {
        this.getRenderer(context).prepareRendersChildren(context, component);
    }

    public final boolean getRendersChildren() {
        return this.getRenderer(FacesContext.getCurrentInstance()).getRendersChildren();
    }

    public final void decode(FacesContext facesContext, UIComponent component) {
        this.getRenderer(facesContext).decode(facesContext, component);
    }

    @Override
    protected final Object getCurrentValueAsObject(UIInput input) {
        return this.getRenderer(FacesContext.getCurrentInstance()).getCurrentValueAsObject(input);
    }

    @Override
    protected final String getCurrentValue(FacesContext facesContext, UIComponent component) {
        return this.getRenderer(facesContext).getCurrentValue(facesContext, component);
    }

    @Override
    protected final Object getValue(UIComponent component) {
        return this.getRenderer(FacesContext.getCurrentInstance()).getValue(component);
    }

    @Override
    public final Converter getConverter(FacesContext facesContext, UIComponent component) {
        return this.getRenderer(facesContext).getConverter(facesContext, component);
    }

    @Override
    public final Object getConvertedValue(FacesContext facesContext, UIComponent component, Object submittedValue) throws ConverterException {
        return this.getRenderer(facesContext).getConvertedValue(facesContext, component, submittedValue);
    }

    public final void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        this.getRenderer(facesContext).encodeBegin(facesContext, component);
    }

    public final void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
        this.getRenderer(facesContext).encodeChildren(facesContext, component);
    }

    public final void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        this.getRenderer(facesContext).encodeEnd(facesContext, component);
    }

    public final String convertClientId(FacesContext facesContext, String clientId) {
        return this.getRenderer(facesContext).convertClientId(facesContext, clientId);
    }

    protected final RendererBase getRenderer(FacesContext facesContext) {
        RendererBase renderer = (RendererBase)ResourceManagerFactory.getResourceManager(facesContext).getRenderer(facesContext.getViewRoot(), this.getRendererType());
        if (renderer == null) {
            throw new RuntimeException("No renderer found for rendererType='" + this.getRendererType() + "' in wrapper class '" + ((Object)((Object)this)).getClass().getName() + "'");
        }
        return renderer;
    }

    protected abstract String getRendererType();
}

