/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.standard.standard.tag;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import org.apache.myfaces.tobago.component.UISelectManyBox;
import org.apache.myfaces.tobago.internal.component.AbstractUISuggest;
import org.apache.myfaces.tobago.internal.util.FacesContextUtils;
import org.apache.myfaces.tobago.layout.LayoutBase;
import org.apache.myfaces.tobago.layout.Measure;
import org.apache.myfaces.tobago.renderkit.SelectManyRendererBase;
import org.apache.myfaces.tobago.renderkit.css.Classes;
import org.apache.myfaces.tobago.renderkit.css.Style;
import org.apache.myfaces.tobago.renderkit.html.Select2Options;
import org.apache.myfaces.tobago.renderkit.html.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.renderkit.util.SelectItemUtils;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectManyBoxRenderer
extends SelectManyRendererBase {
    private static final Logger LOG = LoggerFactory.getLogger(SelectManyBoxRenderer.class);

    public boolean getRendersChildren() {
        return true;
    }

    public void prepareRender(FacesContext facesContext, UIComponent component) throws IOException {
        super.prepareRender(facesContext, component);
        SelectManyBoxRenderer.addSelect2LanguageJs(facesContext);
    }

    public static void addSelect2LanguageJs(FacesContext facesContext) {
        String file = "script/contrib/select2/i18n/" + facesContext.getViewRoot().getLocale().getLanguage() + ".js";
        FacesContextUtils.addScriptFile((FacesContext)facesContext, (String)file);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        if (!(component instanceof UISelectManyBox)) {
            LOG.error("Wrong type: Need " + UISelectManyBox.class.getName() + ", but was " + component.getClass().getName());
            return;
        }
        UISelectManyBox select = (UISelectManyBox)component;
        TobagoResponseWriter writer = HtmlRendererUtils.getTobagoResponseWriter(facesContext);
        AbstractUISuggest suggest = select.getSuggest();
        String id = select.getClientId(facesContext);
        Iterable<SelectItem> items = SelectItemUtils.getItemIterator(facesContext, (UIComponent)select);
        boolean readonly = select.isReadonly();
        boolean disabled = suggest == null && !select.isAllowCustom() && !items.iterator().hasNext() || select.isDisabled() || select.isReadonly();
        Style style = new Style(facesContext, (LayoutBase)select);
        Select2Options select2Options = Select2Options.of(select);
        if (suggest != null) {
            select2Options.setMinimumInputLength(suggest.getMinimumCharacters());
        }
        ComponentUtils.putDataAttribute((UIComponent)select, (Object)"tobago-select2", (Object)select2Options.toJson());
        String title = HtmlRendererUtils.getTitleFromTipAndMessages(facesContext, (UIComponent)select);
        writer.startElement("div", (UIComponent)select);
        writer.writeStyleAttribute(style);
        writer.writeClassAttribute(Classes.create((UIComponent)select, (String)"container"));
        style.setTop(Measure.ZERO);
        style.setLeft(Measure.ZERO);
        writer.startElement("select", (UIComponent)select);
        writer.writeNameAttribute(id);
        writer.writeIdAttribute(id);
        HtmlRendererUtils.writeDataAttributes(facesContext, writer, (UIComponent)select);
        writer.writeAttribute("disabled", disabled);
        writer.writeAttribute("readonly", readonly);
        writer.writeAttribute("required", select.isRequired());
        if (suggest != null) {
            writer.writeAttribute("data-tobago-suggest-id", suggest.getClientId(facesContext), false);
        }
        HtmlRendererUtils.renderFocus(id, select.isFocus(), ComponentUtils.isError((UIInput)select), facesContext, writer);
        Integer tabIndex = select.getTabIndex();
        if (tabIndex != null) {
            writer.writeAttribute("tabindex", tabIndex.intValue());
        }
        writer.writeStyleAttribute(style);
        writer.writeClassAttribute(Classes.create((UIComponent)select));
        writer.writeAttribute("multiple", "multiple", false);
        if (title != null) {
            writer.writeAttribute("title", title, true);
        }
        HtmlRendererUtils.renderCommandFacet((UIComponent)select, facesContext, writer);
        Object[] values = select.getSelectedValues();
        String[] submittedValues = this.getSubmittedValues((UIInput)select);
        HtmlRendererUtils.renderSelectItems((UIInput)select, items, values, submittedValues, writer, facesContext);
        writer.endElement("select");
        writer.endElement("div");
    }
}

