/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.myfaces.tobago.component;

public final class Facets {

  public static final String ACTION = "action";
  public static final String CHANGE = "change";
  public static final String CHECKBOX = "checkbox";
  public static final String CLICK = "click";
  public static final String COMPLETE = "complete";
  public static final String CONFIRMATION = "confirmation";
  public static final String CONSTRAINTS = "constraints";
  public static final String CONTEXT_MENU = "contextMenu";
  public static final String DROP_DOWN_MENU = "dropDownMenu";
  public static final String LABEL = "label";
  public static final String LAYOUT = "layout";
  public static final String LAYOUT_DEFAULT = "layoutDefault";
  public static final String MENUBAR = "menuBar";
  public static final String PAGER_PAGE = "pagerPage";
  public static final String PAGER_ROW = "pagerRow";
  public static final String POPUP = "popup";
  public static final String RADIO = "radio";
  public static final String RELOAD = "reload";
  public static final String RESIZE = "resize";
  public static final String SORTER = "sorter";
  public static final String TOOL_BAR = "toolBar";

  private Facets() {
    // to prevent instantiation
  }

  /**
   * @deprecated since 2.0.0. Please use {@link #POPUP} Using compatible names for  backward compatibility.
   */
  @Deprecated
  public static final String PICKER_POPUP = POPUP;
}
