// ---------- Attention: Generated code, please do not modify! -----------  

/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.myfaces.tobago.internal.taglib;

import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.UITab;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/** 
 * JSP Tag class, generated from template {@code tag1.2.stg} with class 
 * {@link org.apache.myfaces.tobago.internal.taglib.component.TabTagDeclaration}.
 */
public final class TabTag extends TobagoELTag {
  private static final Logger LOG = LoggerFactory.getLogger(TabTag.class);
  private javax.el.ValueExpression  tip;
  private javax.el.ValueExpression  disabled;
  private javax.el.ValueExpression  image;
  private javax.el.ValueExpression  markup;
  private javax.el.ValueExpression  label;
  private javax.el.ValueExpression  accessKey;

  @Override
  public String getComponentType() {
    return UITab.COMPONENT_TYPE;
  }
  @Override
  public String getRendererType() {
    return "Tab";
  }

  @Override
  protected void setProperties(final UIComponent uiComponent) {
    super.setProperties(uiComponent);
    final UITab component = (UITab) uiComponent;
    final FacesContext context = FacesContext.getCurrentInstance();
    final Application application = context.getApplication();
    if (tip != null) {
      component.setValueExpression("tip", tip);
    }

    if (disabled != null) {
      if (!disabled.isLiteralText()) {
        component.setValueExpression("disabled", disabled);
      } else {
        component.setDisabled(Boolean.parseBoolean(disabled.getExpressionString()));
      }
    }
    if (image != null) {
      component.setValueExpression("image", image);
    }

    if (markup != null) {
      if (!markup.isLiteralText()) {
        component.setValueExpression("markup", markup);
      } else {
        component.setMarkup(org.apache.myfaces.tobago.context.Markup.valueOf(markup.getExpressionString()));
      }
    }
    if (label != null) {
      component.setValueExpression("label", label);
    }

    if (accessKey != null) {
      if (!accessKey.isLiteralText()) {
        component.setValueExpression("accessKey", accessKey);
      } else {
        component.setAccessKey(accessKey.getExpressionString().charAt(0));
      }
    }
  }

  public javax.el.ValueExpression getTip() {
    return tip;
  }

  public void setTip(final javax.el.ValueExpression tip) {
    this.tip = tip;
  }

  public javax.el.ValueExpression getDisabled() {
    return disabled;
  }

  public void setDisabled(final javax.el.ValueExpression disabled) {
    this.disabled = disabled;
  }

  public javax.el.ValueExpression getImage() {
    return image;
  }

  public void setImage(final javax.el.ValueExpression image) {
    this.image = image;
  }

  public javax.el.ValueExpression getMarkup() {
    return markup;
  }

  public void setMarkup(final javax.el.ValueExpression markup) {
    this.markup = markup;
  }

  public javax.el.ValueExpression getLabel() {
    return label;
  }

  public void setLabel(final javax.el.ValueExpression label) {
    this.label = label;
  }

  public javax.el.ValueExpression getAccessKey() {
    return accessKey;
  }

  public void setAccessKey(final javax.el.ValueExpression accessKey) {
    this.accessKey = accessKey;
  }



  @Override
  public void release() {
    super.release();
    tip = null;
    disabled = null;
    image = null;
    markup = null;
    label = null;
    accessKey = null;
  }
}