/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.standard.standard.tag;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.validator.LengthValidator;
import javax.faces.validator.Validator;
import org.apache.myfaces.tobago.component.UITextarea;
import org.apache.myfaces.tobago.config.TobagoConfig;
import org.apache.myfaces.tobago.layout.LayoutBase;
import org.apache.myfaces.tobago.renderkit.InputRendererBase;
import org.apache.myfaces.tobago.renderkit.css.Classes;
import org.apache.myfaces.tobago.renderkit.css.Style;
import org.apache.myfaces.tobago.renderkit.html.Command;
import org.apache.myfaces.tobago.renderkit.html.CommandMap;
import org.apache.myfaces.tobago.renderkit.html.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.renderkit.util.RenderUtils;
import org.apache.myfaces.tobago.sanitizer.Sanitizer;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextareaRenderer
extends InputRendererBase {
    private static final Logger LOG = LoggerFactory.getLogger(TextareaRenderer.class);

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        if (!(component instanceof UITextarea)) {
            LOG.error("Wrong type: Need " + UITextarea.class.getName() + ", but was " + component.getClass().getName());
            return;
        }
        UITextarea input = (UITextarea)component;
        String title = HtmlRendererUtils.getTitleFromTipAndMessages(facesContext, component);
        String clientId = input.getClientId(facesContext);
        TobagoResponseWriter writer = HtmlRendererUtils.getTobagoResponseWriter(facesContext);
        writer.startElement("textarea", (UIComponent)input);
        writer.writeNameAttribute(clientId);
        writer.writeIdAttribute(clientId);
        HtmlRendererUtils.writeDataAttributes(facesContext, writer, (UIComponent)input);
        Integer rows = input.getRows();
        if (rows != null) {
            writer.writeAttribute("rows", rows.intValue());
        }
        if (title != null) {
            writer.writeAttribute("title", title, true);
        }
        writer.writeAttribute("readonly", input.isReadonly());
        writer.writeAttribute("disabled", input.isDisabled());
        writer.writeAttribute("required", input.isRequired());
        Integer tabIndex = input.getTabIndex();
        if (tabIndex != null) {
            writer.writeAttribute("tabindex", tabIndex.intValue());
        }
        writer.writeClassAttribute(Classes.create((UIComponent)input));
        Style style = new Style(facesContext, (LayoutBase)input);
        writer.writeStyleAttribute(style);
        String onchange = ComponentUtils.getStringAttribute((UIComponent)input, (String)"onchange");
        if (onchange != null) {
            CommandMap map = new CommandMap();
            Command change = new Command();
            change.setScript(onchange);
            map.addCommand("change", change);
        }
        int maxLength = -1;
        String pattern = null;
        for (Validator validator : input.getValidators()) {
            if (!(validator instanceof LengthValidator)) continue;
            LengthValidator lengthValidator = (LengthValidator)validator;
            maxLength = lengthValidator.getMaximum();
        }
        if (maxLength > 0) {
            writer.writeAttribute("maxlength", maxLength);
        }
        if (pattern != null) {
            writer.writeAttribute("pattern", pattern, false);
        }
        HtmlRendererUtils.renderCommandFacet((UIComponent)input, facesContext, writer);
        HtmlRendererUtils.renderFocus(clientId, input.isFocus(), ComponentUtils.isError((UIInput)input), facesContext, writer);
        String currentValue = RenderUtils.currentValue((UIComponent)input);
        if (currentValue != null) {
            if (ComponentUtils.getDataAttribute((UIComponent)input, (String)"html-editor") != null && "auto".equals(input.getSanitize())) {
                Sanitizer sanitizer = TobagoConfig.getInstance((FacesContext)facesContext).getSanitizer();
                currentValue = sanitizer.sanitize(currentValue);
            }
            if (currentValue.startsWith("\r\n")) {
                currentValue = "\r\n" + currentValue;
            } else if (currentValue.startsWith("\n")) {
                currentValue = "\n" + currentValue;
            } else if (currentValue.startsWith("\r")) {
                currentValue = "\r" + currentValue;
            }
            writer.writeText(currentValue);
        }
        writer.endElement("textarea");
    }
}

