/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.standard.standard.tag;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.UINamingContainer;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.UITreeSelect;
import org.apache.myfaces.tobago.internal.component.AbstractUIData;
import org.apache.myfaces.tobago.internal.component.AbstractUITreeListbox;
import org.apache.myfaces.tobago.internal.component.AbstractUITreeNode;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.apache.myfaces.tobago.model.Selectable;
import org.apache.myfaces.tobago.renderkit.RendererBase;
import org.apache.myfaces.tobago.renderkit.css.Classes;
import org.apache.myfaces.tobago.renderkit.html.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeSelectRenderer
extends RendererBase {
    private static final Logger LOG = LoggerFactory.getLogger(TreeSelectRenderer.class);

    public void decode(FacesContext facesContext, UIComponent component) {
        UITreeSelect select = (UITreeSelect)component;
        AbstractUITreeNode node = (AbstractUITreeNode)ComponentUtils.findAncestor((UIComponent)select, AbstractUITreeNode.class);
        AbstractUIData data = (AbstractUIData)ComponentUtils.findAncestor((UIComponent)node, AbstractUIData.class);
        if (ComponentUtils.isOutputOnly((UIComponent)select)) {
            return;
        }
        String clientId = select.getClientId(facesContext);
        String name = data.getSelectableAsEnum().isSingle() ? this.getClientIdWithoutRowIndex(data, clientId) : clientId;
        String parameter = (String)facesContext.getExternalContext().getRequestParameterMap().get(name);
        if (LOG.isDebugEnabled()) {
            LOG.debug("parameter = '" + parameter + "'");
        }
        boolean selected = clientId.equals(parameter);
        if (!select.isValueStoredInState()) {
            select.setSubmittedValue((Object)(selected ? "true" : "false"));
        }
    }

    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        String label;
        UITreeSelect select = (UITreeSelect)component;
        AbstractUITreeNode node = (AbstractUITreeNode)ComponentUtils.findAncestor((UIComponent)select, AbstractUITreeNode.class);
        AbstractUIData data = (AbstractUIData)ComponentUtils.findAncestor((UIComponent)node, AbstractUIData.class);
        TobagoResponseWriter writer = HtmlRendererUtils.getTobagoResponseWriter(facesContext);
        if (data instanceof AbstractUITreeListbox) {
            writer.write(StringUtils.defaultString((String)select.getLabel()));
            return;
        }
        String id = select.getClientId(facesContext);
        String currentValue = this.getCurrentValue(facesContext, (UIComponent)select);
        boolean checked = select.isValueStoredInState() ? data.getSelectedState().isSelected(node.getPath()) : "true".equals(currentValue);
        boolean folder = data.isFolder();
        Selectable selectable = data.getSelectableAsEnum();
        writer.startElement("span", null);
        writer.writeClassAttribute(Classes.create((UIComponent)select));
        HtmlRendererUtils.writeDataAttributes(facesContext, writer, (UIComponent)select);
        if (!(!select.isShowCheckbox() || selectable == Selectable.NONE || selectable.isLeafOnly() && folder)) {
            writer.startElement("input", null);
            if (selectable.isSingle()) {
                writer.writeAttribute("type", "radio", false);
                writer.writeNameAttribute(this.getClientIdWithoutRowIndex(data, id));
            } else {
                writer.writeAttribute("type", "checkbox", false);
                writer.writeNameAttribute(id);
            }
            writer.writeAttribute("value", id, false);
            writer.writeIdAttribute(id);
            writer.writeAttribute("checked", checked);
            HtmlRendererUtils.renderCommandFacet((UIComponent)select, facesContext, writer);
            writer.endElement("input");
        }
        if (StringUtils.isNotEmpty((String)(label = select.getLabel()))) {
            writer.startElement("label", null);
            writer.writeClassAttribute(Classes.create((UIComponent)select, (String)"label"));
            String title = HtmlRendererUtils.getTitleFromTipAndMessages(facesContext, (UIComponent)select);
            if (title != null) {
                writer.writeAttribute("title", title, true);
            }
            writer.writeAttribute("for", id, false);
            writer.writeText(label);
            writer.endElement("label");
        }
        writer.endElement("span");
    }

    private String getClientIdWithoutRowIndex(AbstractUIData data, String id) {
        char separatorChar = UINamingContainer.getSeparatorChar((FacesContext)FacesContext.getCurrentInstance());
        return id.replace("" + separatorChar + data.getRowIndex() + separatorChar, "" + separatorChar);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
    }
}

