/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.internal.component.AbstractUISelectOneChoice;
import org.apache.myfaces.tobago.internal.renderkit.renderer.SelectOneRendererBase;
import org.apache.myfaces.tobago.internal.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.internal.util.JsonUtils;
import org.apache.myfaces.tobago.internal.util.RenderUtils;
import org.apache.myfaces.tobago.internal.util.SelectItemUtils;
import org.apache.myfaces.tobago.renderkit.css.BootstrapClass;
import org.apache.myfaces.tobago.renderkit.css.CssItem;
import org.apache.myfaces.tobago.renderkit.css.TobagoClass;
import org.apache.myfaces.tobago.renderkit.html.DataAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.renderkit.html.MarkupLanguageAttributes;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class SelectOneChoiceRenderer
extends SelectOneRendererBase {
    public boolean getRendersChildren() {
        return true;
    }

    @Override
    protected void encodeBeginField(FacesContext facesContext, UIComponent component) throws IOException {
        AbstractUISelectOneChoice select = (AbstractUISelectOneChoice)component;
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        String clientId = select.getClientId(facesContext);
        String fieldId = this.getFieldId(facesContext, (UIComponent)select);
        Iterable<SelectItem> items = SelectItemUtils.getItemIterator(facesContext, (UIComponent)select);
        String title = HtmlRendererUtils.getTitleFromTipAndMessages(facesContext, (UIComponent)select);
        boolean disabled = !items.iterator().hasNext() || select.isDisabled() || select.isReadonly();
        Markup markup = select.getMarkup();
        writer.startElement(HtmlElements.SELECT);
        writer.writeIdAttribute(fieldId);
        writer.writeAttribute(DataAttributes.MARKUP, JsonUtils.encode(markup), false);
        writer.writeNameAttribute(clientId);
        HtmlRendererUtils.writeDataAttributes(facesContext, writer, (UIComponent)select);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.DISABLED, disabled);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TABINDEX, select.getTabIndex());
        writer.writeClassAttribute((CssItem)TobagoClass.SELECT_ONE_CHOICE, TobagoClass.SELECT_ONE_CHOICE.createMarkup(markup), this.getCssItems(facesContext, select), new CssItem[]{BootstrapClass.borderColor(ComponentUtils.getMaximumSeverity((UIComponent)select)), select.getCustomClass()});
        if (title != null) {
            writer.writeAttribute(HtmlAttributes.TITLE, title, true);
        }
        writer.writeCommandMapAttribute(JsonUtils.encode(RenderUtils.getBehaviorCommands(facesContext, select)));
        HtmlRendererUtils.renderFocus(clientId, select.isFocus(), ComponentUtils.isError((UIInput)select), facesContext, writer);
        HtmlRendererUtils.renderSelectItems((UIInput)select, TobagoClass.SELECT_ONE_CHOICE__OPTION, items, select.getValue(), (String)select.getSubmittedValue(), writer, facesContext);
    }

    @Override
    protected void encodeEndField(FacesContext facesContext, UIComponent component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        writer.endElement(HtmlElements.SELECT);
    }

    @Override
    protected String getFieldId(FacesContext facesContext, UIComponent component) {
        AbstractUISelectOneChoice select = (AbstractUISelectOneChoice)component;
        return select.getFieldId(facesContext);
    }

    protected CssItem[] getCssItems(FacesContext facesContext, AbstractUISelectOneChoice select) {
        return new CssItem[]{BootstrapClass.FORM_CONTROL};
    }
}

