/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.component;

import java.lang.invoke.MethodHandles;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.internal.component.AbstractUIFormBase;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.util.DebugUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractUIPage
extends AbstractUIFormBase
implements ClientBehaviorHolder {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @Deprecated
    public static final String COMPONENT_TYPE = "org.apache.myfaces.tobago.Page";
    public static final Charset FORM_ACCEPT_CHARSET = StandardCharsets.UTF_8;
    private String formId;

    public boolean getRendersChildren() {
        return true;
    }

    public String getFormId(FacesContext facesContext) {
        if (this.formId == null) {
            this.formId = this.getClientId(facesContext) + "::" + "form";
        }
        return this.formId;
    }

    @Override
    public void processDecodes(FacesContext context) {
        this.decode(context);
        this.markSubmittedForm(context);
        Iterator kids = this.getFacetsAndChildren();
        while (kids.hasNext()) {
            UIComponent kid = (UIComponent)kids.next();
            kid.processDecodes(context);
        }
    }

    public void markSubmittedForm(FacesContext facesContext) {
        UIViewRoot viewRoot = facesContext.getViewRoot();
        this.setSubmitted(false);
        String sourceId = (String)facesContext.getExternalContext().getRequestParameterMap().get("javax.faces.source");
        UIComponent command = null;
        if (sourceId != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("sourceId = '" + sourceId + "'");
            }
            command = viewRoot.findComponent(sourceId);
        } else {
            LOG.warn("No sourceId found!");
        }
        if (command == null && sourceId != null && sourceId.matches(".*:\\d+:.*")) {
            sourceId = sourceId.replaceAll(":\\d+:", ":");
            try {
                command = viewRoot.findComponent(sourceId);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace(sourceId);
            LOG.trace("command:{}", (Object)command);
            LOG.trace(DebugUtils.toString((UIComponent)viewRoot, 0));
        }
        if (command != null) {
            AbstractUIFormBase form = ComponentUtils.findForm(command);
            if (form != null) {
                form.setSubmitted(true);
            } else {
                LOG.warn("No form found - this actually can not happen, because there is a form on each page!");
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("form:{}", (Object)form);
                LOG.trace(form.getClientId(facesContext));
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Illegal actionId! Render response...");
            }
            facesContext.renderResponse();
        }
    }

    public abstract String getLabel();

    public abstract String getFocusId();
}

