/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import java.io.IOException;
import org.apache.myfaces.tobago.component.Facets;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.internal.component.AbstractUICollapsiblePanel;
import org.apache.myfaces.tobago.internal.component.AbstractUISection;
import org.apache.myfaces.tobago.internal.renderkit.renderer.CollapsiblePanelRendererBase;
import org.apache.myfaces.tobago.internal.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.internal.util.RenderUtils;
import org.apache.myfaces.tobago.model.CollapseMode;
import org.apache.myfaces.tobago.renderkit.css.TobagoClass;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class SectionRenderer<T extends AbstractUISection>
extends CollapsiblePanelRendererBase<T> {
    @Override
    public void encodeBeginInternal(FacesContext facesContext, T component) throws IOException {
        HtmlElements tag;
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        String clientId = component.getClientId(facesContext);
        boolean collapsed = ((AbstractUICollapsiblePanel)component).isCollapsed();
        Markup markup = component.getMarkup();
        boolean autoSpacing = component.getAutoSpacing(facesContext);
        writer.startElement(HtmlElements.TOBAGO_SECTION);
        writer.writeIdAttribute(clientId);
        writer.writeClassAttribute(collapsed ? TobagoClass.COLLAPSED : null, autoSpacing ? TobagoClass.AUTO__SPACING : null, component.getCustomClass());
        HtmlRendererUtils.writeDataAttributes(facesContext, writer, component);
        switch (((AbstractUISection)component).getLevel()) {
            case 1: {
                tag = HtmlElements.H1;
                break;
            }
            case 2: {
                tag = HtmlElements.H2;
                break;
            }
            case 3: {
                tag = HtmlElements.H3;
                break;
            }
            case 4: {
                tag = HtmlElements.H4;
                break;
            }
            case 5: {
                tag = HtmlElements.H5;
                break;
            }
            default: {
                tag = HtmlElements.H6;
            }
        }
        if (((AbstractUICollapsiblePanel)component).getCollapsedMode() != CollapseMode.none) {
            this.encodeHidden(writer, clientId, collapsed);
        }
        writer.startElement(HtmlElements.DIV);
        writer.writeClassAttribute(TobagoClass.HEADER);
        writer.startElement(tag);
        String image = ((AbstractUISection)component).getImage();
        HtmlRendererUtils.encodeIconOrImage(writer, image);
        UIComponent labelFacet = ComponentUtils.getFacet(component, Facets.label);
        String labelString = ((AbstractUISection)component).getLabel();
        if (labelFacet != null) {
            this.insideBegin(facesContext, Facets.label);
            for (UIComponent child : RenderUtils.getFacetChildren(labelFacet)) {
                child.encodeAll(facesContext);
            }
            this.insideEnd(facesContext, Facets.label);
        } else if (labelString != null) {
            writer.startElement(HtmlElements.SPAN);
            writer.writeText(labelString);
            writer.endElement(HtmlElements.SPAN);
        }
        writer.endElement(tag);
        UIComponent bar = ComponentUtils.getFacet(component, Facets.bar);
        if (bar != null) {
            this.insideBegin(facesContext, Facets.bar);
            bar.encodeAll(facesContext);
            this.insideEnd(facesContext, Facets.bar);
        }
        writer.endElement(HtmlElements.DIV);
        writer.startElement(HtmlElements.DIV);
        writer.writeClassAttribute(TobagoClass.SECTION__CONTENT);
    }

    @Override
    public void encodeEndInternal(FacesContext facesContext, T component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        writer.endElement(HtmlElements.DIV);
        writer.endElement(HtmlElements.TOBAGO_SECTION);
    }
}

