/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.config;

import jakarta.faces.application.Application;
import jakarta.faces.context.FacesContext;
import jakarta.servlet.ServletContext;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.myfaces.tobago.context.Theme;
import org.apache.myfaces.tobago.context.ThemeImpl;
import org.apache.myfaces.tobago.exception.TobagoConfigurationException;
import org.apache.myfaces.tobago.internal.config.ContentSecurityPolicy;
import org.apache.myfaces.tobago.internal.config.SecurityAnnotation;
import org.apache.myfaces.tobago.internal.config.TobagoConfigFragment;
import org.apache.myfaces.tobago.internal.config.TobagoConfigLoader;
import org.apache.myfaces.tobago.internal.config.TobagoConfigMerger;
import org.apache.myfaces.tobago.internal.config.TobagoConfigSorter;
import org.apache.myfaces.tobago.sanitizer.Sanitizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TobagoConfig {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String TOBAGO_CONFIG = "org.apache.myfaces.tobago.config.TobagoConfig";
    private List<Theme> supportedThemes;
    private List<String> supportedThemeNames = new ArrayList<String>();
    private Theme defaultTheme;
    private String defaultThemeName;
    private Map<String, ThemeImpl> availableThemes;
    private boolean themeCookie = false;
    private boolean themeSession = true;
    private boolean createSessionSecret = true;
    private boolean checkSessionSecret = true;
    private boolean preventFrameAttacks = true;
    private final ContentSecurityPolicy contentSecurityPolicy;
    private SecurityAnnotation securityAnnotation;
    private boolean setNosniffHeader = true;
    private Map<String, String> defaultValidatorInfo;
    private Sanitizer sanitizer;
    private boolean decodeLineFeed = true;
    private Map<String, String> mimeTypes;
    private boolean enableTobagoExceptionHandler = true;
    private boolean locked = false;

    public static TobagoConfig getInstance(FacesContext facesContext) {
        Map applicationMap = facesContext.getExternalContext().getApplicationMap();
        TobagoConfig tobagoConfig = (TobagoConfig)applicationMap.get(TOBAGO_CONFIG);
        if (tobagoConfig != null) {
            return tobagoConfig;
        }
        tobagoConfig = new TobagoConfig((ServletContext)facesContext.getExternalContext().getContext(), new String[0]);
        applicationMap.put(TOBAGO_CONFIG, tobagoConfig);
        return tobagoConfig;
    }

    public static TobagoConfig getInstance(ServletContext servletContext) {
        TobagoConfig tobagoConfig = (TobagoConfig)servletContext.getAttribute(TOBAGO_CONFIG);
        if (tobagoConfig != null) {
            return tobagoConfig;
        }
        tobagoConfig = new TobagoConfig(servletContext, new String[0]);
        servletContext.setAttribute(TOBAGO_CONFIG, (Object)tobagoConfig);
        return tobagoConfig;
    }

    public TobagoConfig(ServletContext servletContext, String ... alternative) {
        this.supportedThemes = new ArrayList<Theme>();
        this.availableThemes = new HashMap<String, ThemeImpl>();
        this.securityAnnotation = SecurityAnnotation.disable;
        this.contentSecurityPolicy = new ContentSecurityPolicy(ContentSecurityPolicy.Mode.OFF.getValue());
        this.mimeTypes = new HashMap<String, String>();
        ArrayList<TobagoConfigFragment> fragments = new ArrayList<TobagoConfigFragment>();
        try {
            TobagoConfigLoader.load(fragments, servletContext, alternative);
            TobagoConfigSorter.sort(fragments);
            TobagoConfigMerger.merge(fragments, this);
            this.initDefaultValidatorInfo();
            this.lock();
            if (LOG.isInfoEnabled()) {
                LOG.info(this.toString());
            }
        }
        catch (Exception e) {
            String error = "Tobago can't be initialized! Application will not run correctly!";
            LOG.error("Tobago can't be initialized! Application will not run correctly!", (Throwable)e);
            throw new TobagoConfigurationException("Tobago can't be initialized! Application will not run correctly!", e);
        }
    }

    public void lock() {
        this.locked = true;
        this.supportedThemes = Collections.unmodifiableList(this.supportedThemes);
        for (Theme theme : this.supportedThemes) {
            ((ThemeImpl)theme).lock();
        }
        this.supportedThemeNames = Collections.unmodifiableList(this.supportedThemeNames);
        this.availableThemes = Collections.unmodifiableMap(this.availableThemes);
        this.contentSecurityPolicy.lock();
        this.mimeTypes = Collections.unmodifiableMap(this.mimeTypes);
    }

    private void checkUnlocked() throws IllegalStateException {
        if (this.locked) {
            throw new TobagoConfigurationException("The configuration must not be changed after initialization!");
        }
    }

    public void addSupportedThemeName(String name) {
        this.checkUnlocked();
        this.supportedThemeNames.add(name);
    }

    public List<String> getSupportedThemeNames() {
        return this.supportedThemeNames;
    }

    public Theme getTheme(String name) {
        if (name == null) {
            LOG.debug("searching theme: null");
            return this.defaultTheme;
        }
        Theme found = this.getThemeIfExists(name);
        if (found != null) {
            return found;
        }
        LOG.debug("searching theme '{}' not found. Using default: {}", (Object)name, (Object)this.defaultTheme);
        return this.defaultTheme;
    }

    public Theme getThemeIfExists(String name) {
        if (this.defaultTheme != null && this.defaultTheme.getName().equals(name)) {
            return this.defaultTheme;
        }
        for (Theme theme : this.supportedThemes) {
            if (!theme.getName().equals(name)) continue;
            return theme;
        }
        return null;
    }

    public void setDefaultThemeName(String defaultThemeName) {
        this.checkUnlocked();
        this.defaultThemeName = defaultThemeName;
    }

    public String getDefaultThemeName() {
        return this.defaultThemeName;
    }

    public List<Theme> getSupportedThemes() {
        return this.supportedThemes;
    }

    public void setDefaultTheme(Theme defaultTheme) {
        this.defaultTheme = defaultTheme;
    }

    public Theme getDefaultTheme() {
        return this.defaultTheme;
    }

    public void addAvailableTheme(ThemeImpl availableTheme) {
        this.checkUnlocked();
        String name = availableTheme.getName();
        if (this.availableThemes.containsKey(name)) {
            ThemeImpl base = this.availableThemes.get(name);
            this.availableThemes.put(name, ThemeImpl.merge(base, availableTheme));
        } else {
            this.availableThemes.put(name, availableTheme);
        }
    }

    public Map<String, ThemeImpl> getAvailableThemes() {
        return this.availableThemes;
    }

    public boolean isThemeCookie() {
        return this.themeCookie;
    }

    public void setThemeCookie(boolean themeCookie) {
        this.themeCookie = themeCookie;
    }

    public boolean isThemeSession() {
        return this.themeSession;
    }

    public void setThemeSession(boolean themeSession) {
        this.themeSession = themeSession;
    }

    public boolean isCreateSessionSecret() {
        return this.createSessionSecret;
    }

    public void setCreateSessionSecret(boolean createSessionSecret) {
        this.checkUnlocked();
        this.createSessionSecret = createSessionSecret;
    }

    public boolean isCheckSessionSecret() {
        return this.checkSessionSecret;
    }

    public void setCheckSessionSecret(boolean checkSessionSecret) {
        this.checkUnlocked();
        this.checkSessionSecret = checkSessionSecret;
    }

    public boolean isPreventFrameAttacks() {
        return this.preventFrameAttacks;
    }

    public void setPreventFrameAttacks(boolean preventFrameAttacks) {
        this.checkUnlocked();
        this.preventFrameAttacks = preventFrameAttacks;
    }

    public ContentSecurityPolicy getContentSecurityPolicy() {
        return this.contentSecurityPolicy;
    }

    public boolean isSetNosniffHeader() {
        return this.setNosniffHeader;
    }

    public void setSetNosniffHeader(boolean setNosniffHeader) {
        this.checkUnlocked();
        this.setNosniffHeader = setNosniffHeader;
    }

    public SecurityAnnotation getSecurityAnnotation() {
        return this.securityAnnotation;
    }

    public void setSecurityAnnotation(SecurityAnnotation securityAnnotation) {
        this.checkUnlocked();
        this.securityAnnotation = securityAnnotation;
    }

    public Map<String, String> getDefaultValidatorInfo() {
        if (this.defaultValidatorInfo == null) {
            this.initDefaultValidatorInfo();
        }
        return this.defaultValidatorInfo;
    }

    public Sanitizer getSanitizer() {
        return this.sanitizer;
    }

    public void setSanitizer(Sanitizer sanitizer) {
        this.checkUnlocked();
        this.sanitizer = sanitizer;
    }

    public boolean isDecodeLineFeed() {
        return this.decodeLineFeed;
    }

    public void setDecodeLineFeed(boolean decodeLineFeed) {
        this.checkUnlocked();
        this.decodeLineFeed = decodeLineFeed;
    }

    public boolean isEnableTobagoExceptionHandler() {
        return this.enableTobagoExceptionHandler;
    }

    public void setEnableTobagoExceptionHandler(boolean enableTobagoExceptionHandler) {
        this.checkUnlocked();
        this.enableTobagoExceptionHandler = enableTobagoExceptionHandler;
    }

    public Map<String, String> getMimeTypes() {
        return this.mimeTypes;
    }

    private void initDefaultValidatorInfo() {
        FacesContext facesContext;
        if (this.defaultValidatorInfo != null) {
            this.checkUnlocked();
        }
        if ((facesContext = FacesContext.getCurrentInstance()) != null) {
            try {
                Application application = facesContext.getApplication();
                Map map = application.getDefaultValidatorInfo();
                this.defaultValidatorInfo = map.size() > 0 ? Collections.unmodifiableMap(map) : Collections.emptyMap();
            }
            catch (Exception e) {
                LOG.error("Can't initialize default validators (this happens with JBoss GateIn 3.6.0).", (Throwable)e);
                this.defaultValidatorInfo = Collections.emptyMap();
            }
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("TobagoConfigImpl{");
        builder.append("\nsupportedThemes=[");
        for (Theme supportedTheme : this.supportedThemes) {
            builder.append(supportedTheme.getName());
            builder.append(", ");
        }
        builder.append("], \ndefaultTheme=");
        builder.append(this.defaultTheme != null ? this.defaultTheme.getName() : null);
        builder.append(", \navailableThemes=");
        builder.append(this.availableThemes.keySet());
        builder.append(", \nthemeCookie=");
        builder.append(this.themeCookie);
        builder.append(", \nthemeSession=");
        builder.append(this.themeSession);
        builder.append(", \ncreateSessionSecret=");
        builder.append(this.createSessionSecret);
        builder.append(", \ncheckSessionSecret=");
        builder.append(this.checkSessionSecret);
        builder.append(", \npreventFrameAttacks=");
        builder.append(this.preventFrameAttacks);
        builder.append(", \ncontentSecurityPolicy=");
        builder.append(this.contentSecurityPolicy);
        builder.append(", \nsecurityAnnotation=");
        builder.append((Object)this.securityAnnotation);
        builder.append(", \nsetNosniffHeader=");
        builder.append(this.setNosniffHeader);
        builder.append(", \ndefaultValidatorInfo=");
        builder.append(this.defaultValidatorInfo);
        builder.append(", \nsanitizer=");
        builder.append(this.sanitizer);
        builder.append(", \ndecodeLineFeed=");
        builder.append(this.decodeLineFeed);
        builder.append(", \nthemes=");
        HashSet<ThemeImpl> all = new HashSet<ThemeImpl>(this.availableThemes.values());
        builder.append(all);
        builder.append(", \nmimeTypes=");
        builder.append(this.mimeTypes);
        builder.append(", \nenableTobagoExceptionHandler=");
        builder.append(this.enableTobagoExceptionHandler);
        builder.append('}');
        return builder.toString();
    }
}

