/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.webapp;

import jakarta.el.ValueExpression;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import java.io.IOException;
import java.io.Writer;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.renderkit.html.HtmlTypes;
import org.apache.myfaces.tobago.renderkit.html.MarkupLanguageAttributes;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TobagoResponseWriterBase
extends TobagoResponseWriter {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected static final String XML_VERSION_1_0_ENCODING_UTF_8 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
    protected static final char[] XML_VERSION_1_0_ENCODING_UTF_8_CHARS = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n".toCharArray();
    private int level = 0;
    private int inlineStack = 0;
    private UIComponent component;
    private Map<Integer, String> levelToChangedElementTag = new HashMap<Integer, String>();
    private boolean startStillOpen;
    private final Writer writer;
    private final String contentType;
    private final Charset charset;
    private final boolean prettyPrint;

    @Deprecated(since="4.3.0", forRemoval=true)
    protected TobagoResponseWriterBase(Writer writer, String contentType, String characterEncoding) {
        this(writer, contentType, characterEncoding != null ? Charset.forName(characterEncoding) : StandardCharsets.UTF_8, true);
    }

    protected TobagoResponseWriterBase(Writer writer, String contentType, Charset charset, boolean prettyPrint) {
        this.writer = writer;
        this.contentType = contentType;
        this.charset = charset != null ? charset : StandardCharsets.UTF_8;
        this.prettyPrint = prettyPrint;
    }

    protected final Writer getWriter() {
        return this.writer;
    }

    protected final UIComponent getComponent() {
        return this.component;
    }

    protected final void setComponent(UIComponent component) {
        this.component = component;
    }

    protected final boolean isStartStillOpen() {
        return this.startStillOpen;
    }

    protected final void setStartStillOpen(boolean startStillOpen) {
        this.startStillOpen = startStillOpen;
    }

    protected final String findValue(Object value, String property) {
        if (value != null) {
            return value instanceof String ? (String)value : value.toString();
        }
        if (property != null) {
            if (this.component != null) {
                Object object = this.component.getAttributes().get(property);
                if (object != null) {
                    return object instanceof String ? (String)object : object.toString();
                }
                return null;
            }
            String trace = this.getCallingClassStackTraceElementString();
            LOG.warn("Don't know what to do! Property defined, but no component to get a value. (value=null, property='" + property + "') " + trace.substring(trace.indexOf(40)));
            return null;
        }
        String trace = this.getCallingClassStackTraceElementString();
        LOG.warn("Don't know what to do! No value and no property defined. (value=null, property=null)" + trace.substring(trace.indexOf(40)));
        return null;
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        this.writer.write(cbuf, off, len);
    }

    @Override
    public void write(String string) throws IOException {
        this.writeInternal(this.writer, string);
    }

    protected final void writeInternal(Writer sink, String string) throws IOException {
        this.closeOpenTag();
        sink.write(string);
    }

    public void write(int j) throws IOException {
        this.closeOpenTag();
        this.writer.write(j);
    }

    public void write(char[] chars) throws IOException {
        this.closeOpenTag();
        this.writer.write(chars);
    }

    public void write(String string, int j, int k) throws IOException {
        this.closeOpenTag();
        this.writer.write(string, j, k);
    }

    public void close() throws IOException {
        this.closeOpenTag();
        this.writer.close();
    }

    @Override
    public void flush() throws IOException {
        this.closeOpenTag();
    }

    protected void closeOpenTag() throws IOException {
        if (this.startStillOpen) {
            this.handlePassThroughAttributes();
            this.writer.write(62);
            this.startStillOpen = false;
        }
    }

    protected void handlePassThroughAttributes() throws IOException {
        if (this.component != null && this.component.getPassThroughAttributes(false) != null) {
            for (Map.Entry entry : this.component.getPassThroughAttributes().entrySet()) {
                String key = (String)entry.getKey();
                if ("elementName".equals(key)) continue;
                Object value = entry.getValue();
                if (value instanceof ValueExpression) {
                    value = ((ValueExpression)value).getValue(FacesContext.getCurrentInstance().getELContext());
                }
                if (value instanceof Boolean) {
                    if (Boolean.FALSE.equals(value)) continue;
                    this.writer.write(32);
                    this.writer.write(key);
                    continue;
                }
                this.writeAttributeInternal(this.writer, key, value != null ? value.toString() : "", true);
            }
        }
    }

    public void startDocument() throws IOException {
    }

    public void endDocument() throws IOException {
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getCharacterEncoding() {
        return this.charset.name();
    }

    protected Charset getCharset() {
        return this.charset;
    }

    protected boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    @Override
    public void startElement(String name, UIComponent currentComponent) throws IOException {
        this.closeOpenTag();
        boolean inline = HtmlElements.isInline(name);
        this.component = currentComponent;
        this.startElementInternal(this.writer, name, inline);
    }

    @Override
    public void startElement(HtmlElements name, UIComponent currentComponent) throws IOException {
        this.closeOpenTag();
        this.component = currentComponent;
        this.startElementInternal(this.writer, name.getValue(), name.isInline());
    }

    @Override
    public void startElement(HtmlElements name) throws IOException {
        this.startElement(name, null);
    }

    protected void startElementInternal(Writer sink, String name, boolean inline) throws IOException {
        Map passThroughAttributes;
        Object value;
        String localElementName = null;
        boolean localElementInline = inline;
        if (this.component != null && this.component.getPassThroughAttributes(false) != null && (value = (passThroughAttributes = this.component.getPassThroughAttributes(false)).get("elementName")) != null) {
            if (value instanceof ValueExpression) {
                value = ((ValueExpression)value).getValue(FacesContext.getCurrentInstance().getELContext());
            }
            if (!name.equals(localElementName = value.toString().toLowerCase(Locale.ROOT).trim())) {
                this.levelToChangedElementTag.put(this.level, localElementName);
                localElementInline = HtmlElements.isInline(localElementName);
            }
        }
        if (localElementInline) {
            ++this.inlineStack;
        }
        if (this.prettyPrint && this.inlineStack <= 1) {
            sink.write(10);
            for (int i = 0; i < this.level; ++i) {
                sink.write(32);
            }
        }
        sink.write(60);
        if (localElementName != null) {
            sink.write(localElementName);
        } else {
            sink.write(name);
        }
        this.startStillOpen = true;
        ++this.level;
    }

    @Override
    public void endElement(String name) throws IOException {
        --this.level;
        String elementTagToRender = this.levelToChangedElementTag.get(this.level);
        if (elementTagToRender == null) {
            elementTagToRender = name;
        }
        this.renderNonTobagoEndElement(elementTagToRender);
    }

    private void renderNonTobagoEndElement(String element) throws IOException {
        boolean inline = HtmlElements.isInline(element);
        if (HtmlElements.isVoid(element)) {
            this.closeEmptyTag();
        } else {
            this.endElementInternal(this.writer, element, inline);
        }
        this.startStillOpen = false;
        if (inline) {
            --this.inlineStack;
            assert (this.inlineStack >= 0);
        }
    }

    @Override
    public void endElement(HtmlElements name) throws IOException {
        --this.level;
        String elementTagToRender = this.levelToChangedElementTag.remove(this.level);
        if (elementTagToRender != null) {
            this.renderNonTobagoEndElement(elementTagToRender);
        } else {
            boolean inline = name.isInline();
            if (name.isVoid()) {
                this.closeEmptyTag();
            } else {
                this.endElementInternal(this.writer, name.getValue(), inline);
            }
            this.startStillOpen = false;
            if (inline) {
                --this.inlineStack;
                assert (this.inlineStack >= 0);
            }
        }
    }

    @Override
    public void writeComment(Object obj) throws IOException {
        this.closeOpenTag();
        String comment = obj.toString();
        if (this.prettyPrint) {
            this.writer.write(10);
            for (int i = 0; i < this.level; ++i) {
                this.writer.write(32);
            }
        }
        this.write("<!--");
        this.write(comment);
        this.write("-->");
    }

    @Override
    @Deprecated(since="3.0.0", forRemoval=true)
    public void writeAttribute(String name, Object value, String property) throws IOException {
        String attribute = this.findValue(value, property);
        this.writeAttributeInternal(this.writer, name, attribute, true);
    }

    protected final String getCallingClassStackTraceElementString() {
        StackTraceElement[] stackTrace = new Exception().getStackTrace();
        int j = 1;
        while (stackTrace[j].getClassName().contains("ResponseWriter")) {
            ++j;
        }
        return stackTrace[j].toString();
    }

    @Override
    public void writeURIAttribute(String name, Object value, String property) throws IOException {
        if (value != null) {
            URI uri = URI.create(value.toString());
            this.writeAttribute(name, (Object)uri.toASCIIString(), property);
        }
    }

    @Override
    public void writeAttribute(MarkupLanguageAttributes name, String value, boolean escape) throws IOException {
        this.writeAttributeInternal(this.writer, name, value, escape);
    }

    @Override
    public void writeAttribute(MarkupLanguageAttributes name, HtmlTypes types) throws IOException {
        this.writeAttributeInternal(this.writer, name, types.getValue(), false);
    }

    @Override
    public void writeURIAttribute(MarkupLanguageAttributes name, String value) throws IOException {
        if (value != null) {
            URI uri = URI.create(value);
            this.writeAttribute(name, uri.toASCIIString(), true);
        }
    }

    protected void endElementInternal(Writer sink, String name, boolean inline) throws IOException {
        if (this.startStillOpen) {
            this.handlePassThroughAttributes();
            sink.write(62);
        }
        if (inline) {
            sink.write("</");
        } else {
            if (this.prettyPrint) {
                sink.write(10);
                for (int i = 0; i < this.level; ++i) {
                    sink.write(32);
                }
            }
            sink.write("</");
        }
        sink.write(name);
        sink.write(62);
    }

    protected abstract void closeEmptyTag() throws IOException;

    protected void writeAttributeInternal(Writer sink, MarkupLanguageAttributes name, String value, boolean escape) throws IOException {
        if (!this.startStillOpen) {
            String trace = this.getCallingClassStackTraceElementString();
            String error = "Cannot write attribute when start-tag not open. name = '" + String.valueOf(name) + "' value = '" + value + "' " + trace.substring(trace.indexOf(40));
            LOG.error(error);
            throw new IllegalStateException(error);
        }
        String attributeName = name.getValue();
        if (this.component != null && this.component.getPassThroughAttributes(false) != null && this.component.getPassThroughAttributes(false).containsKey(attributeName)) {
            return;
        }
        this.writeAttributeInternal(sink, attributeName, value, escape);
    }

    private void writeAttributeInternal(Writer sink, String attributeName, String value, boolean escape) throws IOException {
        if (value != null) {
            sink.write(32);
            sink.write(attributeName);
            sink.write("='");
            this.writerAttributeValue(value, escape);
            sink.write(39);
        }
    }

    protected abstract void writerAttributeValue(String var1, boolean var2) throws IOException;
}

