/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Locale;
import org.apache.myfaces.tobago.component.Facets;
import org.apache.myfaces.tobago.event.SheetAction;
import org.apache.myfaces.tobago.internal.component.AbstractUIPaginator;
import org.apache.myfaces.tobago.internal.component.AbstractUIPaginatorPage;
import org.apache.myfaces.tobago.internal.component.AbstractUISheet;
import org.apache.myfaces.tobago.internal.renderkit.renderer.PaginatorRenderer;
import org.apache.myfaces.tobago.renderkit.css.BootstrapClass;
import org.apache.myfaces.tobago.renderkit.css.Icons;
import org.apache.myfaces.tobago.renderkit.css.TobagoClass;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.renderkit.html.HtmlInputTypes;
import org.apache.myfaces.tobago.renderkit.html.MarkupLanguageAttributes;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.util.ResourceUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class PaginatorPageRenderer<T extends AbstractUIPaginatorPage>
extends PaginatorRenderer<T> {
    @Override
    public void encodeBeginInternal(FacesContext facesContext, T paginator) throws IOException {
        boolean disabled;
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        AbstractUISheet sheet = ((AbstractUIPaginator)paginator).getPageable();
        boolean visible = ((AbstractUIPaginator)paginator).isAlwaysVisible() || sheet.needMoreThanOnePage();
        writer.startElement(HtmlElements.TOBAGO_PAGINATOR_PAGE);
        String clientId = paginator.getClientId(facesContext);
        writer.writeIdAttribute(clientId);
        writer.writeClassAttribute(visible ? null : BootstrapClass.D_NONE, paginator.getCustomClass());
        writer.startElement(HtmlElements.UL);
        writer.writeClassAttribute(BootstrapClass.PAGINATION);
        if (sheet.isShowPageRangeArrows()) {
            disabled = sheet.isAtBeginning();
            this.encodeLink(facesContext, disabled, SheetAction.first, null, Icons.SKIP_START, null);
            this.encodeLink(facesContext, disabled, SheetAction.prev, null, Icons.CARET_LEFT, null);
        }
        writer.startElement(HtmlElements.LI);
        writer.writeClassAttribute(BootstrapClass.PAGE_ITEM);
        writer.startElement(HtmlElements.SPAN);
        writer.writeClassAttribute(TobagoClass.PAGING, BootstrapClass.PAGE_LINK, BootstrapClass.TEXT_NOWRAP);
        writer.writeAttribute(HtmlAttributes.TITLE, ResourceUtils.getString(facesContext, "sheet.setPage"), true);
        if (sheet.getRowCount() != 0) {
            int pages;
            Locale locale = facesContext.getViewRoot().getLocale();
            int first = sheet.getCurrentPage() + 1;
            boolean unknown = !sheet.hasRowCount();
            int n = pages = unknown ? -1 : sheet.getPages();
            String key = unknown ? (first == pages ? "sheet.pageX" : "sheet.pageXtoY") : (first == pages ? "sheet.pageXofZ" : "sheet.pageXtoYofZ");
            String inputMarker = "{#}";
            Object[] args = new Object[]{"{#}", pages == -1 ? "?" : Integer.valueOf(pages)};
            MessageFormat detail = new MessageFormat(ResourceUtils.getString(facesContext, key), locale);
            String formatted = detail.format(args);
            int pos = formatted.indexOf("{#}");
            if (pos >= 0) {
                writer.writeText(formatted.substring(0, pos));
                writer.startElement(HtmlElements.SPAN);
                writer.writeText(Integer.toString(first));
                writer.endElement(HtmlElements.SPAN);
                writer.startElement(HtmlElements.INPUT);
                writer.writeIdAttribute(((AbstractUIPaginator)paginator).getFieldId(facesContext));
                writer.writeNameAttribute(clientId);
                writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TYPE, HtmlInputTypes.TEXT);
                writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.VALUE, first);
                if (!unknown) {
                    writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.MAXLENGTH, Integer.toString(pages).length());
                }
                writer.endElement(HtmlElements.INPUT);
                writer.writeText(formatted.substring(pos + "{#}".length()));
            } else {
                writer.writeText(formatted);
            }
        }
        ComponentUtils.removeFacet((UIComponent)sheet, Facets.pagerPage);
        writer.endElement(HtmlElements.SPAN);
        writer.endElement(HtmlElements.LI);
        if (sheet.isShowPageRangeArrows()) {
            disabled = sheet.isAtEnd();
            this.encodeLink(facesContext, disabled, SheetAction.next, null, Icons.CARET_RIGHT, null);
            this.encodeLink(facesContext, disabled || !sheet.hasRowCount(), SheetAction.last, null, Icons.SKIP_END, null);
        }
        writer.endElement(HtmlElements.UL);
    }

    @Override
    public void encodeEndInternal(FacesContext facesContext, T component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        writer.endElement(HtmlElements.TOBAGO_PAGINATOR_PAGE);
    }
}

