/*
 * Licensed to the Apache Software Foundation (ASF) under one or more contributor license
 * agreements. See the NOTICE file distributed with this work for additional information regarding
 * copyright ownership. The ASF licenses this file to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the License. You may obtain a
 * copy of the License at http://www.apache.org/licenses/LICENSE-2.0 Unless required by applicable
 * law or agreed to in writing, software distributed under the License is distributed on an "AS IS"
 * BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License
 * for the specific language governing permissions and limitations under the License.
 */

package javax.portlet.faces;

import java.util.Map;

import javax.faces.context.FacesContext;

import javax.portlet.faces.Bridge;

  /** Utility class designed to make it easy for Faces subsystems including the
   * bridge itself to determine whether this request is running in a portlet
   * container and/or which portlet request phase it is executing in.
   */
public class BridgeUtil
{
  /** Indicates whether the current request is executing in the portlet container.  
   * If it returns <code>true</code> the request is a portlet request, otherwise it
   * is not.
   */
  public static boolean isPortletRequest() 
  {
    FacesContext ctx = FacesContext.getCurrentInstance();
    
    // This method might be called during App startup (via a context listener) and hence no FacesContext
    // For example a renderkit might createComponents during such time -- as the bridge overrides faces Application
    // which implements createComponent and calls this method (to see if we need to wrap/replace with the NamingContainer
    if (ctx == null)  return false;
    
    Map<String, Object> m = ctx.getExternalContext().getRequestMap();
    Bridge.PortletPhase phase = (Bridge.PortletPhase) m.get(Bridge.PORTLET_LIFECYCLE_PHASE);
    if (phase != null)
    {
      return true;
    }
    else 
    {
      return false;
    }
  }
  
  /** Return describes the portlet request phase currently being executed.  If 
   * <code>null</code> then this request is not being executed in a portlet 
   * container.
   */
  public static Bridge.PortletPhase getPortletRequestPhase() 
  {
    Map<String, Object> m = FacesContext.getCurrentInstance().getExternalContext().getRequestMap();
    return (Bridge.PortletPhase) m.get(Bridge.PORTLET_LIFECYCLE_PHASE);
  }
  
}
