/*
 * Licensed to the Apache Software Foundation (ASF) under one or more contributor license
 * agreements. See the NOTICE file distributed with this work for additional information regarding
 * copyright ownership. The ASF licenses this file to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the License. You may obtain a
 * copy of the License at http://www.apache.org/licenses/LICENSE-2.0 Unless required by applicable
 * law or agreed to in writing, software distributed under the License is distributed on an "AS IS"
 * BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License
 * for the specific language governing permissions and limitations under the License.
 */

package org.apache.myfaces.portlet.faces.preference;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import javax.portlet.PortletPreferences;
import javax.portlet.faces.preference.Preference;
import javax.portlet.ReadOnlyException;


public class PreferenceValuesList<String>
  extends ArrayList<java.lang.String>
{
  private Preference mPreference;
  
  public PreferenceValuesList(PortletPreferences preferences, Preference preference)
  {
    this(preference, Arrays.asList(preference, preferences.getValues(preference.getName(), null)));
    
    mPreference = preference;
  }
  
  public PreferenceValuesList(PortletPreferences preferences, Preference preference, int initialCapacity)
  {
    this(preference, Arrays.asList(preference, preferences.getValues(preference.getName(), null)));                                                                                                       
    this.ensureCapacity(initialCapacity);
    
    mPreference = preference;  
  }
  
  public PreferenceValuesList(Preference preference, List list)
  {
    super(list);
    mPreference = preference;  
  }
  
  public boolean add(java.lang.String s)
  {
    // add it first to the list in case its accessed again
    boolean added = false;
    if (!mPreference.isReadOnly())
    {
      added = super.add(s);
    
      // add it to the preference
      if (added)
      {
        try {
          mPreference.setValues((java.lang.String[]) this.toArray());
        } 
        catch (ReadOnlyException e)
        {
          // should never happen
        }
      }
    }
    return added;

  }
  
  public void add(int index,
           java.lang.String element)
  
  {
    if (!mPreference.isReadOnly())
    {
      // add it first to the list in case its accessed again
      super.add(index, element);
    
      // add it to the preference
      try {
        mPreference.setValues((java.lang.String[]) this.toArray());
      } 
      catch (ReadOnlyException e)
      {
        // should never happen
      }
    }
  }
  
  public boolean addAll(List<java.lang.String> c)
  {
    // add it first to the list in case its accessed again
    boolean added = false;
    if (!mPreference.isReadOnly())
    {
      added = super.addAll(c);
    
      // add it to the preference
      if (added)
      {
        try {
          mPreference.setValues((java.lang.String[]) this.toArray());
        } 
        catch (ReadOnlyException e)
        {
          // should never happen
        }
      }
    }
    return added;
  }
  
  public boolean addAll(int index,
                        List<java.lang.String> c)
  {
    // add it first to the list in case its accessed again
    boolean added = false;
    if (!mPreference.isReadOnly())
    {
      added = super.addAll(index, c);
    
      // add it to the preference
      if (added)
      {
        try {
          mPreference.setValues((java.lang.String[]) this.toArray());
        } 
        catch (ReadOnlyException e)
        {
          // should never happen
        }
      }
    }
    return added;
  }
  
  public void clear()
  {
    if (!mPreference.isReadOnly())
    {
      // clear the list first
      super.clear();
    
      // reset the preferences
      try {
        mPreference.reset();
      } 
      catch (ReadOnlyException e)
      {
        // should never happen
      }
    } 
  }
  
  public java.lang.String remove(int index)
  {
    java.lang.String removedValue = null;
    if (!mPreference.isReadOnly())
    {
      // remove from list
      removedValue = super.remove(index);
    
      // update the preferences
      try {
        mPreference.setValues((java.lang.String[]) this.toArray());
      } 
      catch (ReadOnlyException e)
      {
        // should never happen
      }
    }
    return removedValue;
  }
  
  public boolean remove(java.lang.String o)
  {
    boolean removed = false;
    if (!mPreference.isReadOnly())
    {
      // remove fro mlist
      removed = super.remove(o);
    
      // update the preferences
      try {
        mPreference.setValues((java.lang.String[]) this.toArray());
      } 
      catch (ReadOnlyException e)
      {
        // should never happen
      }
    }
    return removed;
  }
  
  public java.lang.String set(int index,
               java.lang.String element)
  {
    // add it first to the list in case its accessed again
    java.lang.String added = null;
    if (!mPreference.isReadOnly())
    {
      added = super.set(index, element);
    
      // add it to the preference
      if (added != null)
      {
        try {
          mPreference.setValues((java.lang.String[]) this.toArray());
        } 
        catch (ReadOnlyException e)
        {
          // should never happen
        }
      }
    }
    return added;
  }
  
  public java.lang.String get(int index)
  {
    // add it first to the list in case its accessed again
    java.lang.String ret = (java.lang.String) super.get(index);
    return ret;

  }
  
}
