/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.webapp.filter;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.PortletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUpload;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.portlet.PortletFileUpload;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.webapp.filter.portlet.ActionRequestWrapper;
import org.apache.myfaces.webapp.filter.portlet.PortletChacheFileSizeErrorsFileUpload;

public class PortletMultipartRequestWrapper
extends ActionRequestWrapper {
    private static Log log = LogFactory.getLog(PortletMultipartRequestWrapper.class);
    public static final String UPLOADED_FILES_ATTRIBUTE = "org.apache.myfaces.uploadedFiles";
    public static final String WWW_FORM_URLENCODED_TYPE = "application/x-www-form-urlencoded";
    ActionRequest request = null;
    HashMap parametersMap = null;
    PortletFileUpload fileUpload = null;
    HashMap fileItems = null;
    long maxFileSize;
    long maxSize;
    int thresholdSize;
    String repositoryPath;
    boolean cacheFileSizeErrors;

    public PortletMultipartRequestWrapper(Object request, int maxFileSize, int thresholdSize, String repositoryPath) {
        super((PortletRequest)((ActionRequest)request));
        this.request = (ActionRequest)request;
        this.maxFileSize = maxFileSize;
        this.thresholdSize = thresholdSize;
        this.repositoryPath = repositoryPath;
        this.maxSize = maxFileSize;
        this.cacheFileSizeErrors = false;
    }

    public PortletMultipartRequestWrapper(Object request, int maxFileSize, int thresholdSize, String repositoryPath, int maxRequestSize, boolean cacheFileSizeErrors) {
        super((PortletRequest)((ActionRequest)request));
        this.request = (ActionRequest)request;
        this.maxFileSize = maxFileSize;
        this.maxSize = maxRequestSize;
        this.thresholdSize = thresholdSize;
        this.repositoryPath = repositoryPath;
        this.cacheFileSizeErrors = cacheFileSizeErrors;
    }

    public PortletMultipartRequestWrapper(Object request, long maxFileSize, int thresholdSize, String repositoryPath) {
        super((PortletRequest)((ActionRequest)request));
        this.request = (ActionRequest)request;
        this.maxFileSize = maxFileSize;
        this.thresholdSize = thresholdSize;
        this.repositoryPath = repositoryPath;
        this.maxSize = maxFileSize;
        this.cacheFileSizeErrors = false;
    }

    public PortletMultipartRequestWrapper(Object request, long maxFileSize, int thresholdSize, String repositoryPath, long maxRequestSize, boolean cacheFileSizeErrors) {
        super((PortletRequest)((ActionRequest)request));
        this.request = (ActionRequest)request;
        this.maxFileSize = maxFileSize;
        this.maxSize = maxRequestSize;
        this.thresholdSize = thresholdSize;
        this.repositoryPath = repositoryPath;
        this.cacheFileSizeErrors = cacheFileSizeErrors;
    }

    private void parseRequest() {
        this.fileUpload = this.cacheFileSizeErrors ? new PortletChacheFileSizeErrorsFileUpload() : new PortletFileUpload();
        this.fileUpload.setSizeMax(this.maxSize);
        this.fileUpload.setFileSizeMax(this.maxFileSize);
        if (this.repositoryPath != null && this.repositoryPath.trim().length() > 0) {
            this.fileUpload.setFileItemFactory((FileItemFactory)new DiskFileItemFactory(this.thresholdSize, new File(this.repositoryPath)));
        } else {
            this.fileUpload.setFileItemFactory((FileItemFactory)new DiskFileItemFactory(this.thresholdSize, new File(System.getProperty("java.io.tmpdir"))));
        }
        String charset = this.request.getCharacterEncoding();
        this.fileUpload.setHeaderEncoding(charset);
        List requestParameters = null;
        try {
            requestParameters = this.cacheFileSizeErrors ? ((PortletChacheFileSizeErrorsFileUpload)this.fileUpload).parseRequestCatchingFileSizeErrors(this.request, (FileUpload)this.fileUpload) : this.fileUpload.parseRequest(this.request);
        }
        catch (FileUploadBase.FileSizeLimitExceededException e) {
            this.request.setAttribute("org.apache.myfaces.custom.fileupload.exception", (Object)"fileSizeLimitExceeded");
            this.request.setAttribute("org.apache.myfaces.custom.fileupload.maxSize", (Object)new Integer((int)this.maxFileSize));
            if (log.isWarnEnabled()) {
                log.warn((Object)"FileSizeLimitExceededException while uploading file.", (Throwable)e);
            }
            requestParameters = Collections.EMPTY_LIST;
        }
        catch (FileUploadBase.SizeLimitExceededException e) {
            this.request.setAttribute("org.apache.myfaces.custom.fileupload.exception", (Object)"sizeLimitExceeded");
            this.request.setAttribute("org.apache.myfaces.custom.fileupload.maxSize", (Object)new Integer((int)this.maxSize));
            if (log.isWarnEnabled()) {
                log.warn((Object)"SizeLimitExceededException while uploading file.", (Throwable)e);
            }
            requestParameters = Collections.EMPTY_LIST;
        }
        catch (FileUploadException fue) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Exception while uploading file.", (Throwable)fue);
            }
            requestParameters = Collections.EMPTY_LIST;
        }
        this.parametersMap = new HashMap(requestParameters.size());
        this.fileItems = new HashMap();
        for (FileItem fileItem : requestParameters) {
            if (fileItem.isFormField()) {
                String name = fileItem.getFieldName();
                String value = null;
                if (charset == null) {
                    value = fileItem.getString();
                } else {
                    try {
                        value = new String(fileItem.get(), charset);
                    }
                    catch (UnsupportedEncodingException e) {
                        value = fileItem.getString();
                    }
                }
                this.addTextParameter(name, value);
                continue;
            }
            if (fileItem.getName() == null) continue;
            this.fileItems.put(fileItem.getFieldName(), fileItem);
        }
        for (Map.Entry entry : this.request.getParameterMap().entrySet()) {
            Object value = entry.getValue();
            if (value instanceof String[]) {
                String[] valuesArray = (String[])entry.getValue();
                for (int i = 0; i < valuesArray.length; ++i) {
                    this.addTextParameter((String)entry.getKey(), valuesArray[i]);
                }
                continue;
            }
            if (value instanceof String) {
                String strValue = (String)entry.getValue();
                this.addTextParameter((String)entry.getKey(), strValue);
                continue;
            }
            if (value == null) continue;
            throw new IllegalStateException("value of type : " + value.getClass() + " for key : " + entry.getKey() + " cannot be handled.");
        }
    }

    private void addTextParameter(String name, String value) {
        if (!this.parametersMap.containsKey(name)) {
            String[] valuesArray = new String[]{value};
            this.parametersMap.put(name, valuesArray);
        } else {
            String[] storedValues = (String[])this.parametersMap.get(name);
            int lengthSrc = storedValues.length;
            String[] valuesArray = new String[lengthSrc + 1];
            System.arraycopy(storedValues, 0, valuesArray, 0, lengthSrc);
            valuesArray[lengthSrc] = value;
            this.parametersMap.put(name, valuesArray);
        }
    }

    public Enumeration getParameterNames() {
        if (this.parametersMap == null) {
            this.parseRequest();
        }
        return Collections.enumeration(this.parametersMap.keySet());
    }

    public String getParameter(String name) {
        String[] values;
        if (this.parametersMap == null) {
            this.parseRequest();
        }
        if ((values = (String[])this.parametersMap.get(name)) == null) {
            return null;
        }
        return values[0];
    }

    public String[] getParameterValues(String name) {
        if (this.parametersMap == null) {
            this.parseRequest();
        }
        return (String[])this.parametersMap.get(name);
    }

    public Map getParameterMap() {
        if (this.parametersMap == null) {
            this.parseRequest();
        }
        return this.parametersMap;
    }

    public FileItem getFileItem(String fieldName) {
        if (this.fileItems == null) {
            this.parseRequest();
        }
        return (FileItem)this.fileItems.get(fieldName);
    }

    public Map getFileItems() {
        if (this.fileItems == null) {
            this.parseRequest();
        }
        return this.fileItems;
    }

    public Object getAttribute(String string) {
        if (string.equals(UPLOADED_FILES_ATTRIBUTE)) {
            return this.getFileItems();
        }
        return super.getAttribute(string);
    }

    public String getContentType() {
        return WWW_FORM_URLENCODED_TYPE;
    }
}

