/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.tree2;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.myfaces.custom.tree2.TreeModel;
import org.apache.myfaces.custom.tree2.TreeNode;
import org.apache.myfaces.custom.tree2.TreeState;
import org.apache.myfaces.custom.tree2.TreeStateBase;
import org.apache.myfaces.custom.tree2.TreeWalker;
import org.apache.myfaces.custom.tree2.TreeWalkerBase;

public class TreeModelBase
implements TreeModel {
    private static final long serialVersionUID = 3969414475396945742L;
    private TreeNode root;
    private TreeState treeState = new TreeStateBase();

    public TreeModelBase(TreeNode root) {
        this.root = root;
    }

    public TreeState getTreeState() {
        return this.treeState;
    }

    public void setTreeState(TreeState treeState) {
        this.treeState = treeState;
    }

    public String[] getPathInformation(String nodeId) {
        if (nodeId == null) {
            throw new IllegalArgumentException("Cannot determine parents for a null node.");
        }
        ArrayList<String> pathList = new ArrayList<String>();
        pathList.add(nodeId);
        while (nodeId.lastIndexOf(SEPARATOR) != -1) {
            nodeId = nodeId.substring(0, nodeId.lastIndexOf(SEPARATOR));
            pathList.add(nodeId);
        }
        String[] pathInfo = new String[pathList.size()];
        for (int i = 0; i < pathInfo.length; ++i) {
            pathInfo[i] = (String)pathList.get(pathInfo.length - i - 1);
        }
        return pathInfo;
    }

    public boolean isLastChild(String nodeId) {
        TreeNode parentNode;
        if (nodeId.lastIndexOf(SEPARATOR) == -1) {
            return true;
        }
        String parentId = nodeId.substring(0, nodeId.lastIndexOf(SEPARATOR));
        String childString = nodeId.substring(nodeId.lastIndexOf(SEPARATOR) + 1);
        int childId = Integer.parseInt(childString);
        return childId + 1 == (parentNode = this.getNodeById(parentId)).getChildCount();
    }

    public TreeNode getNodeById(String nodeId) {
        if (nodeId == null) {
            return null;
        }
        TreeNode node = null;
        StringTokenizer st = new StringTokenizer(nodeId, SEPARATOR);
        while (st.hasMoreTokens()) {
            int nodeIndex = Integer.parseInt(st.nextToken());
            if (node == null) {
                node = this.root;
                continue;
            }
            node = (TreeNode)node.getChildren().get(nodeIndex);
        }
        return node;
    }

    public TreeWalker getTreeWalker() {
        return new TreeWalkerBase();
    }
}

