/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.rendered;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.List;
import java.util.Map;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.ext.awt.image.rendered.AbstractRed;
import org.apache.batik.ext.awt.image.rendered.CachableRed;
import org.apache.batik.ext.awt.image.rendered.TileBlock;
import org.apache.batik.ext.awt.image.rendered.TileCache;
import org.apache.batik.ext.awt.image.rendered.TileGenerator;
import org.apache.batik.ext.awt.image.rendered.TileStore;
import org.apache.batik.util.HaltingThread;

public abstract class AbstractTiledRed
extends AbstractRed
implements TileGenerator {
    private TileStore tiles;
    private static int defaultTileSize = 128;

    public static int getDefaultTileSize() {
        return defaultTileSize;
    }

    protected AbstractTiledRed() {
    }

    protected AbstractTiledRed(Rectangle rectangle, Map map) {
        super(rectangle, map);
    }

    protected AbstractTiledRed(CachableRed cachableRed, Map map) {
        super(cachableRed, map);
    }

    protected AbstractTiledRed(CachableRed cachableRed, Rectangle rectangle, Map map) {
        super(cachableRed, rectangle, map);
    }

    protected AbstractTiledRed(CachableRed cachableRed, Rectangle rectangle, ColorModel colorModel, SampleModel sampleModel, Map map) {
        super(cachableRed, rectangle, colorModel, sampleModel, map);
    }

    protected AbstractTiledRed(CachableRed cachableRed, Rectangle rectangle, ColorModel colorModel, SampleModel sampleModel, int n, int n2, Map map) {
        super(cachableRed, rectangle, colorModel, sampleModel, n, n2, map);
    }

    protected void init(CachableRed cachableRed, Rectangle rectangle, ColorModel colorModel, SampleModel sampleModel, int n, int n2, Map map) {
        this.init(cachableRed, rectangle, colorModel, sampleModel, n, n2, null, map);
    }

    protected void init(CachableRed cachableRed, Rectangle rectangle, ColorModel colorModel, SampleModel sampleModel, int n, int n2, TileStore tileStore, Map map) {
        super.init(cachableRed, rectangle, colorModel, sampleModel, n, n2, map);
        this.tiles = tileStore;
        if (this.tiles == null) {
            this.tiles = this.createTileStore();
        }
    }

    protected AbstractTiledRed(List list, Rectangle rectangle, Map map) {
        super(list, rectangle, map);
    }

    protected AbstractTiledRed(List list, Rectangle rectangle, ColorModel colorModel, SampleModel sampleModel, Map map) {
        super(list, rectangle, colorModel, sampleModel, map);
    }

    protected AbstractTiledRed(List list, Rectangle rectangle, ColorModel colorModel, SampleModel sampleModel, int n, int n2, Map map) {
        super(list, rectangle, colorModel, sampleModel, n, n2, map);
    }

    protected void init(List list, Rectangle rectangle, ColorModel colorModel, SampleModel sampleModel, int n, int n2, Map map) {
        super.init(list, rectangle, colorModel, sampleModel, n, n2, map);
        this.tiles = this.createTileStore();
    }

    public TileStore getTileStore() {
        return this.tiles;
    }

    protected void setTileStore(TileStore tileStore) {
        this.tiles = tileStore;
    }

    protected TileStore createTileStore() {
        return TileCache.getTileMap(this);
    }

    public WritableRaster copyData(WritableRaster writableRaster) {
        this.copyToRasterByBlocks(writableRaster);
        return writableRaster;
    }

    public Raster getData(Rectangle rectangle) {
        int n = this.getXTile(rectangle.x);
        int n2 = this.getXTile(rectangle.x + rectangle.width - 1);
        int n3 = this.getYTile(rectangle.y);
        int n4 = this.getYTile(rectangle.y + rectangle.height - 1);
        if (n == n2 && n3 == n4) {
            Raster raster = this.getTile(n, n3);
            return raster.createChild(rectangle.x, rectangle.y, rectangle.width, rectangle.height, rectangle.x, rectangle.y, null);
        }
        return super.getData(rectangle);
    }

    public Raster getTile(int n, int n2) {
        return this.tiles.getTile(n, n2);
    }

    public Raster genTile(int n, int n2) {
        WritableRaster writableRaster = this.makeTile(n, n2);
        this.genRect(writableRaster);
        return writableRaster;
    }

    public abstract void genRect(WritableRaster var1);

    public void setTile(int n, int n2, Raster raster) {
        this.tiles.setTile(n, n2, raster);
    }

    public void copyToRasterByBlocks(WritableRaster writableRaster) {
        Raster raster;
        int n;
        boolean bl = GraphicsUtil.is_INT_PACK_Data(this.getSampleModel(), false);
        Rectangle rectangle = this.getBounds();
        Rectangle rectangle2 = writableRaster.getBounds();
        int n2 = this.getXTile(rectangle2.x);
        int n3 = this.getYTile(rectangle2.y);
        int n4 = this.getXTile(rectangle2.x + rectangle2.width - 1);
        int n5 = this.getYTile(rectangle2.y + rectangle2.height - 1);
        if (n2 < this.minTileX) {
            n2 = this.minTileX;
        }
        if (n3 < this.minTileY) {
            n3 = this.minTileY;
        }
        if (n4 >= this.minTileX + this.numXTiles) {
            n4 = this.minTileX + this.numXTiles - 1;
        }
        if (n5 >= this.minTileY + this.numYTiles) {
            n5 = this.minTileY + this.numYTiles - 1;
        }
        if (n4 < n2 || n5 < n3) {
            return;
        }
        int n6 = n2;
        int n7 = n4;
        int n8 = n3;
        int n9 = n5;
        int n10 = n2 * this.tileWidth + this.tileGridXOff;
        if (n10 < rectangle2.x && rectangle.x != rectangle2.x) {
            ++n6;
        }
        if ((n = n3 * this.tileHeight + this.tileGridYOff) < rectangle2.y && rectangle.y != rectangle2.y) {
            ++n8;
        }
        if ((n10 = (n4 + 1) * this.tileWidth + this.tileGridXOff - 1) >= rectangle2.x + rectangle2.width && rectangle.x + rectangle.width != rectangle2.x + rectangle2.width) {
            --n7;
        }
        if ((n = (n5 + 1) * this.tileHeight + this.tileGridYOff - 1) >= rectangle2.y + rectangle2.height && rectangle.y + rectangle.height != rectangle2.y + rectangle2.height) {
            --n9;
        }
        int n11 = n7 - n6 + 1;
        int n12 = n9 - n8 + 1;
        boolean[] blArray = null;
        if (n11 > 0 && n12 > 0) {
            blArray = new boolean[n11 * n12];
        }
        boolean[] blArray2 = new boolean[2 * (n4 - n2 + 1) + 2 * (n5 - n3 + 1)];
        int n13 = 0;
        int n14 = 0;
        int n15 = n3;
        while (n15 <= n5) {
            int n16 = n2;
            while (n16 <= n4) {
                boolean bl2;
                raster = this.tiles.getTileNoCompute(n16, n15);
                boolean bl3 = bl2 = raster != null;
                if (n15 >= n8 && n15 <= n9 && n16 >= n6 && n16 <= n7) {
                    blArray[n16 - n6 + (n15 - n8) * n11] = bl2;
                } else {
                    blArray2[n13++] = bl2;
                }
                if (bl2) {
                    ++n14;
                    if (bl) {
                        GraphicsUtil.copyData_INT_PACK(raster, writableRaster);
                    } else {
                        GraphicsUtil.copyData_FALLBACK(raster, writableRaster);
                    }
                }
                ++n16;
            }
            ++n15;
        }
        if (n11 > 0 && n12 > 0) {
            TileBlock tileBlock = new TileBlock(n6, n8, n11, n12, blArray, 0, 0, n11, n12);
            this.drawBlock(tileBlock, writableRaster);
        }
        if (HaltingThread.hasBeenHalted()) {
            return;
        }
        n13 = 0;
        n = n3;
        while (n <= n5) {
            n10 = n2;
            while (n10 <= n4) {
                Raster raster2 = this.tiles.getTileNoCompute(n10, n);
                if (n >= n8 && n <= n9 && n10 >= n6 && n10 <= n7) {
                    if (raster2 == null) {
                        raster = this.makeTile(n10, n);
                        if (bl) {
                            GraphicsUtil.copyData_INT_PACK(writableRaster, (WritableRaster)raster);
                        } else {
                            GraphicsUtil.copyData_FALLBACK(writableRaster, (WritableRaster)raster);
                        }
                        this.tiles.setTile(n10, n, raster);
                    }
                } else if (!blArray2[n13++]) {
                    raster2 = this.getTile(n10, n);
                    if (HaltingThread.hasBeenHalted()) {
                        return;
                    }
                    if (bl) {
                        GraphicsUtil.copyData_INT_PACK(raster2, writableRaster);
                    } else {
                        GraphicsUtil.copyData_FALLBACK(raster2, writableRaster);
                    }
                }
                ++n10;
            }
            ++n;
        }
    }

    public void copyToRaster(WritableRaster writableRaster) {
        Rectangle rectangle = writableRaster.getBounds();
        int n = this.getXTile(rectangle.x);
        int n2 = this.getYTile(rectangle.y);
        int n3 = this.getXTile(rectangle.x + rectangle.width - 1);
        int n4 = this.getYTile(rectangle.y + rectangle.height - 1);
        if (n < this.minTileX) {
            n = this.minTileX;
        }
        if (n2 < this.minTileY) {
            n2 = this.minTileY;
        }
        if (n3 >= this.minTileX + this.numXTiles) {
            n3 = this.minTileX + this.numXTiles - 1;
        }
        if (n4 >= this.minTileY + this.numYTiles) {
            n4 = this.minTileY + this.numYTiles - 1;
        }
        boolean bl = GraphicsUtil.is_INT_PACK_Data(this.getSampleModel(), false);
        int n5 = n3 - n + 1;
        boolean[] blArray = new boolean[n5 * (n4 - n2 + 1)];
        int n6 = n2;
        while (n6 <= n4) {
            int n7 = n;
            while (n7 <= n3) {
                Raster raster = this.tiles.getTileNoCompute(n7, n6);
                if (raster != null) {
                    blArray[n7 - n + (n6 - n2) * n5] = true;
                    if (bl) {
                        GraphicsUtil.copyData_INT_PACK(raster, writableRaster);
                    } else {
                        GraphicsUtil.copyData_FALLBACK(raster, writableRaster);
                    }
                }
                ++n7;
            }
            ++n6;
        }
        int n8 = n2;
        while (n8 <= n4) {
            int n9 = n;
            while (n9 <= n3) {
                if (!blArray[n9 - n + (n8 - n2) * n5]) {
                    Raster raster = this.getTile(n9, n8);
                    if (bl) {
                        GraphicsUtil.copyData_INT_PACK(raster, writableRaster);
                    } else {
                        GraphicsUtil.copyData_FALLBACK(raster, writableRaster);
                    }
                }
                ++n9;
            }
            ++n8;
        }
    }

    protected void drawBlock(TileBlock tileBlock, WritableRaster writableRaster) {
        TileBlock[] tileBlockArray = tileBlock.getBestSplit();
        if (tileBlockArray == null) {
            return;
        }
        this.drawBlockInPlace(tileBlockArray, writableRaster);
    }

    protected void drawBlockAndCopy(TileBlock[] tileBlockArray, WritableRaster writableRaster) {
        int n;
        int n2;
        if (tileBlockArray.length == 1) {
            TileBlock tileBlock = tileBlockArray[0];
            n2 = tileBlock.getXLoc() * this.tileWidth + this.tileGridXOff;
            n = tileBlock.getYLoc() * this.tileHeight + this.tileGridYOff;
            if (n2 == writableRaster.getMinX() && n == writableRaster.getMinY()) {
                this.drawBlockInPlace(tileBlockArray, writableRaster);
                return;
            }
        }
        int n3 = 0;
        n2 = 0;
        while (n2 < tileBlockArray.length) {
            n = tileBlockArray[n2].getWidth() * this.tileWidth * (tileBlockArray[n2].getHeight() * this.tileHeight);
            if (n > n3) {
                n3 = n;
            }
            ++n2;
        }
        DataBufferInt dataBufferInt = new DataBufferInt(n3);
        int[] nArray = new int[]{0xFF0000, 65280, 255, -16777216};
        boolean bl = GraphicsUtil.is_INT_PACK_Data(writableRaster.getSampleModel(), false);
        int n4 = 0;
        while (n4 < tileBlockArray.length) {
            TileBlock tileBlock = tileBlockArray[n4];
            int n5 = tileBlock.getXLoc() * this.tileWidth + this.tileGridXOff;
            int n6 = tileBlock.getYLoc() * this.tileHeight + this.tileGridYOff;
            Rectangle rectangle = new Rectangle(n5, n6, tileBlock.getWidth() * this.tileWidth, tileBlock.getHeight() * this.tileHeight);
            rectangle = rectangle.intersection(this.bounds);
            Point point = new Point(rectangle.x, rectangle.y);
            WritableRaster writableRaster2 = Raster.createPackedRaster(dataBufferInt, rectangle.width, rectangle.height, rectangle.width, nArray, point);
            this.genRect(writableRaster2);
            if (bl) {
                GraphicsUtil.copyData_INT_PACK(writableRaster2, writableRaster);
            } else {
                GraphicsUtil.copyData_FALLBACK(writableRaster2, writableRaster);
            }
            if (HaltingThread.hasBeenHalted()) {
                return;
            }
            ++n4;
        }
    }

    protected void drawBlockInPlace(TileBlock[] tileBlockArray, WritableRaster writableRaster) {
        int n = 0;
        while (n < tileBlockArray.length) {
            TileBlock tileBlock = tileBlockArray[n];
            int n2 = tileBlock.getXLoc() * this.tileWidth + this.tileGridXOff;
            int n3 = tileBlock.getYLoc() * this.tileHeight + this.tileGridYOff;
            Rectangle rectangle = new Rectangle(n2, n3, tileBlock.getWidth() * this.tileWidth, tileBlock.getHeight() * this.tileHeight);
            rectangle = rectangle.intersection(this.bounds);
            WritableRaster writableRaster2 = writableRaster.createWritableChild(rectangle.x, rectangle.y, rectangle.width, rectangle.height, rectangle.x, rectangle.y, null);
            this.genRect(writableRaster2);
            if (HaltingThread.hasBeenHalted()) {
                return;
            }
            ++n;
        }
    }
}

