/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.convert;

import java.awt.Color;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;

abstract class ColorFormat
extends Format {
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(ColorFormat.class);

    ColorFormat() {
    }

    public final Color parse(String source, ParsePosition status) {
        return (Color)this.parseObject(source, status);
    }

    public final Color parse(String source) throws ParseException {
        return (Color)this.parseObject(source);
    }

    public Object parseObject(String source) throws ParseException {
        ParsePosition status = new ParsePosition(0);
        Object result = null;
        boolean illegalArgument = false;
        try {
            result = this.parseObject(source, status);
        }
        catch (IllegalArgumentException ie) {
            _LOG.warning(ie);
            illegalArgument = true;
        }
        int index = status.getIndex();
        if (illegalArgument || index == 0 || source != null && index < source.length()) {
            throw new ParseException("Format.parseObject(String) failed", status.getErrorIndex());
        }
        return result;
    }

    public abstract Object parseObject(String var1, ParsePosition var2);

    public final String format(Color color) {
        return this.format(color, new StringBuffer(), new FieldPosition(0)).toString();
    }

    public final StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition fieldPosition) {
        if (obj instanceof Color) {
            return this.format((Color)obj, toAppendTo, fieldPosition);
        }
        if (obj instanceof Number) {
            return this.format(new Color(((Number)obj).intValue()), toAppendTo, fieldPosition);
        }
        throw new IllegalArgumentException(_LOG.getMessage("CANNOT_FORMAT_GIVEN_OBJECT_AS_COLOR"));
    }

    public abstract StringBuffer format(Color var1, StringBuffer var2, FieldPosition var3);
}

