/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.resource;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.resource.ResourceLoader;

public class RegexResourceLoader
extends ResourceLoader {
    private final List<RegexResourceNode> _loaders = new ArrayList<RegexResourceNode>();
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(RegexResourceLoader.class);

    protected URL findResource(String path) throws IOException {
        for (RegexResourceNode node : this._loaders) {
            Matcher matcher = node.getPattern().matcher(path);
            if (!matcher.matches()) continue;
            return node.getResourceLoader().getResource(matcher.group(1));
        }
        return null;
    }

    protected void register(String regex, ResourceLoader loader) {
        Pattern pattern = Pattern.compile(regex);
        this._checkPathRegex(regex);
        this._loaders.add(new RegexResourceNode(pattern, loader));
    }

    protected void deregister(String regex) {
        Iterator<RegexResourceNode> nodeIterator = this._loaders.iterator();
        while (nodeIterator.hasNext()) {
            if (!regex.equals(nodeIterator.next().getPattern().pattern())) continue;
            nodeIterator.remove();
            return;
        }
    }

    private void _checkPathRegex(String regex) {
        if (!regex.startsWith("/") && !regex.startsWith("(/")) {
            throw new IllegalArgumentException(_LOG.getMessage("RESOURCE_PATH_REGULAR_EXPRESSION_HAS_NO_LEADING_SLASH", regex));
        }
    }

    private static class RegexResourceNode {
        private ResourceLoader _loader;
        private Pattern _pattern;

        public RegexResourceNode(Pattern pattern, ResourceLoader loader) {
            this._pattern = pattern;
            this._loader = loader;
        }

        public Pattern getPattern() {
            return this._pattern;
        }

        public ResourceLoader getResourceLoader() {
            return this._loader;
        }
    }
}

