/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.config.upload;

import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidadinternal.config.upload.UploadedFiles;
import org.apache.myfaces.trinidadinternal.share.util.CaboHttpUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UploadRequestWrapper
extends HttpServletRequestWrapper {
    private Map<String, String[]> _extractedAndDecodedParams;
    private Map<String, String[]> _extractedParams;
    private String _encoding;
    private boolean _parametersRetrieved;
    private static final String _WWW_FORM_URLENCODED_TYPE = "application/x-www-form-urlencoded";
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(UploadRequestWrapper.class);

    public UploadRequestWrapper(HttpServletRequest request, Map<String, String[]> params) {
        super(request);
        Map originalMap = super.getParameterMap();
        this._extractedParams = new HashMap<String, String[]>(originalMap);
        this._extractedParams.putAll(params);
        this._encoding = super.getCharacterEncoding();
    }

    public String getContentType() {
        return _WWW_FORM_URLENCODED_TYPE;
    }

    public String getCharacterEncoding() {
        return this._encoding;
    }

    public void setCharacterEncoding(String encoding) throws UnsupportedEncodingException {
        if (this._parametersRetrieved) {
            _LOG.warning("UNABLE_SET_REQUEST_CHARACTER", (Object)encoding);
            return;
        }
        if (encoding.equals(this._encoding)) {
            return;
        }
        this._encoding = encoding;
        if (_LOG.isFine()) {
            _LOG.fine("Switching encoding of wrapper to " + encoding);
        }
        this._extractedAndDecodedParams = new HashMap<String, String[]>(this._extractedParams.size());
        byte[] buffer = new byte[256];
        for (Map.Entry<String, String[]> entry : this._extractedParams.entrySet()) {
            String key = entry.getKey();
            key = CaboHttpUtils.decodeRequestParameter(key, encoding, buffer);
            String[] oldValue = entry.getValue();
            int length = oldValue.length;
            String[] newValue = new String[length];
            for (int i = 0; i < length; ++i) {
                newValue[i] = CaboHttpUtils.decodeRequestParameter(oldValue[i], encoding, buffer);
                if (!_LOG.isFinest()) continue;
                _LOG.finest("Parameter " + key + ":" + newValue[i]);
            }
            this._extractedAndDecodedParams.put(key, newValue);
        }
        UploadedFiles.setCharacterEncoding((HttpServletRequest)this, encoding);
    }

    public String getParameter(String param) {
        String[] value = this._getParameterValues(param);
        if (value == null) {
            return null;
        }
        return value[0];
    }

    public Map<String, String[]> getParameterMap() {
        Map<String, String[]> map = this._getMap();
        return Collections.unmodifiableMap(map);
    }

    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(this._getMap().keySet());
    }

    public String[] getParameterValues(String param) {
        String[] value = this._getParameterValues(param);
        if (value == null) {
            return null;
        }
        return (String[])value.clone();
    }

    private String[] _getParameterValues(String param) {
        return this._getMap().get(param);
    }

    private Map<String, String[]> _getMap() {
        this._parametersRetrieved = true;
        if (this._extractedAndDecodedParams != null) {
            return this._extractedAndDecodedParams;
        }
        return this._extractedParams;
    }
}

