/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.context;

import java.awt.Color;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.myfaces.trinidad.change.ChangeManager;
import org.apache.myfaces.trinidad.change.NullChangeManager;
import org.apache.myfaces.trinidad.change.SessionChangeManager;
import org.apache.myfaces.trinidad.component.UIXCollection;
import org.apache.myfaces.trinidad.config.RegionManager;
import org.apache.myfaces.trinidad.context.AccessibilityProfile;
import org.apache.myfaces.trinidad.context.Agent;
import org.apache.myfaces.trinidad.context.DialogService;
import org.apache.myfaces.trinidad.context.PageFlowScopeProvider;
import org.apache.myfaces.trinidad.context.PageResolver;
import org.apache.myfaces.trinidad.context.PartialPageContext;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.context.RequestContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.render.CoreRenderer;
import org.apache.myfaces.trinidad.util.ClassLoaderUtils;
import org.apache.myfaces.trinidad.util.ComponentUtils;
import org.apache.myfaces.trinidad.util.ExternalContextUtils;
import org.apache.myfaces.trinidad.webapp.UploadedFileProcessor;
import org.apache.myfaces.trinidadinternal.agent.AgentFactory;
import org.apache.myfaces.trinidadinternal.agent.AgentFactoryImpl;
import org.apache.myfaces.trinidadinternal.agent.TrinidadAgentImpl;
import org.apache.myfaces.trinidadinternal.application.StateManagerImpl;
import org.apache.myfaces.trinidadinternal.context.DialogServiceImpl;
import org.apache.myfaces.trinidadinternal.context.RequestContextBean;
import org.apache.myfaces.trinidadinternal.context.TrinidadPhaseListener;
import org.apache.myfaces.trinidadinternal.el.FormatterMap;
import org.apache.myfaces.trinidadinternal.el.HelpProvider;
import org.apache.myfaces.trinidadinternal.el.OracleHelpProvider;
import org.apache.myfaces.trinidadinternal.metadata.RegionMetadata;
import org.apache.myfaces.trinidadinternal.renderkit.core.CoreRenderKit;
import org.apache.myfaces.trinidadinternal.share.config.UIXCookie;
import org.apache.myfaces.trinidadinternal.ui.expl.ColorPaletteUtils;
import org.apache.myfaces.trinidadinternal.util.nls.LocaleUtils;
import org.apache.myfaces.trinidadinternal.webapp.TrinidadFilterImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestContextImpl
extends RequestContext {
    public static final String LAUNCH_PARAMETERS = "org.apache.myfaces.trinidad.PageFlowSourceParameters";
    public static final String LAUNCH_VIEW = "org.apache.myfaces.trinidad.PageFlowSourceView";
    private RequestContextBean _bean;
    private HelpProvider _provider;
    private Map<UIComponent, Set<UIComponent>> _partialListeners;
    private Set<String> _partialTargets;
    private Agent _agent;
    private DialogServiceImpl _dialogService;
    private PageResolver _pageResolver;
    private PageFlowScopeProvider _pageFlowScopeProvider;
    private static final AgentFactory _agentFactory = new AgentFactoryImpl();
    private static final int _DEFAULT_PAGE_FLOW_SCOPE_LIFETIME = 15;
    private static final String _CHANGE_MANAGER_KEY = "org.apache.myfaces.trinidadinternal.ChangeManager";
    private static final String _CHANGE_PERSISTENCE_INIT_PARAM = "org.apache.myfaces.trinidad.CHANGE_PERSISTENCE";
    private static final Map<String, RequestContext.Accessibility> _ACCESSIBILITY_NAMES = new HashMap<String, RequestContext.Accessibility>();
    private static final TrinidadLogger _LOG;

    public RequestContextImpl(RequestContextBean bean) {
        this._bean = bean;
        this._dialogService = new DialogServiceImpl(this);
        this._partialTargets = new HashSet<String>();
    }

    public void init(ExternalContext request) {
        this.attach();
    }

    public DialogService getDialogService() {
        return this._dialogService;
    }

    public PageResolver getPageResolver() {
        return this._pageResolver;
    }

    public PageFlowScopeProvider getPageFlowScopeProvider() {
        return this._pageFlowScopeProvider;
    }

    public Map<String, Object> getPageFlowScope() {
        return this._pageFlowScopeProvider.getPageFlowScope(this.__getFacesContext());
    }

    public void returnFromDialog(Object returnValue, Map<Object, Object> returnParameters) {
        boolean dialogIsInaccessible = this._dialogService.returnFromDialog(returnValue, returnParameters);
        this._pageFlowScopeProvider.popPageFlowScope(this.__getFacesContext(), dialogIsInaccessible);
    }

    public void launchDialog(UIViewRoot dialogRoot, Map<String, Object> dialogParameters, UIComponent source, boolean useWindow, Map<String, Object> windowProperties) {
        this._pageFlowScopeProvider.pushPageFlowScope(this.__getFacesContext(), true);
        this._dialogService.launchDialog(dialogRoot, dialogParameters, source, useWindow, windowProperties);
    }

    public UploadedFileProcessor getUploadedFileProcessor() {
        return (UploadedFileProcessor)this._bean.getProperty(RequestContextBean.UPLOADED_FILE_PROCESSOR_KEY);
    }

    public boolean isPostback() {
        FacesContext context = this.__getFacesContext();
        if (!TrinidadPhaseListener.isPostback(context)) {
            return false;
        }
        UIViewRoot originalViewRoot = (UIViewRoot)context.getExternalContext().getRequestMap().get("org.apache.myfaces.trinidadinternal.InitialViewRoot");
        return originalViewRoot == null || originalViewRoot == context.getViewRoot();
    }

    public boolean isPartialRequest(FacesContext context) {
        return CoreRenderKit.isPartialRequest(context.getExternalContext());
    }

    public boolean isDebugOutput() {
        return Boolean.TRUE.equals(this._bean.getProperty(RequestContextBean.DEBUG_OUTPUT_KEY));
    }

    public boolean isClientValidationDisabled() {
        return RequestContext.ClientValidation.DISABLED == this.getClientValidation();
    }

    public String getOutputMode() {
        if (ExternalContextUtils.isPortlet((ExternalContext)this.__getFacesContext().getExternalContext())) {
            return "portlet";
        }
        return (String)this._bean.getProperty(RequestContextBean.OUTPUT_MODE_KEY);
    }

    public String getSkinFamily() {
        return (String)this._bean.getProperty(RequestContextBean.SKIN_FAMILY_KEY);
    }

    public RequestContext.Accessibility getAccessibilityMode() {
        UIXCookie cookie;
        String name = (String)this._bean.getProperty(RequestContextBean.ACCESSIBILITY_MODE_KEY);
        if (name == null && (cookie = this._getUIXCookie()) != null && cookie.getAccessibilityMode() != null) {
            name = cookie.getAccessibilityMode().toString();
        }
        return _ACCESSIBILITY_NAMES.get(name);
    }

    public AccessibilityProfile getAccessibilityProfile() {
        return (AccessibilityProfile)this._bean.getProperty(RequestContextBean.ACCESSIBILITY_PROFILE_KEY);
    }

    public RequestContext.ClientValidation getClientValidation() {
        RequestContext.ClientValidation clientValidation = (RequestContext.ClientValidation)this._bean.getProperty(RequestContextBean.CLIENT_VALIDATION_KEY);
        if (clientValidation == null) {
            clientValidation = RequestContext.ClientValidation.INLINE;
        }
        if (clientValidation == RequestContext.ClientValidation.INLINE && this.getAccessibilityMode() == RequestContext.Accessibility.SCREEN_READER) {
            clientValidation = RequestContext.ClientValidation.ALERT;
        }
        return clientValidation;
    }

    public boolean isAnimationEnabled() {
        return !Boolean.FALSE.equals(this._bean.getProperty(RequestContextBean.ANIMATION_ENABLED_KEY));
    }

    public char getNumberGroupingSeparator() {
        Object property = this._bean.getProperty(RequestContextBean.NUMBER_GROUPING_SEPARATOR_KEY);
        char c = CoreRenderer.toChar((Object)property);
        if (c != '\uffff') {
            return c;
        }
        return '\u0000';
    }

    public char getDecimalSeparator() {
        Object property = this._bean.getProperty(RequestContextBean.DECIMAL_SEPARATOR_KEY);
        char c = CoreRenderer.toChar((Object)property);
        if (c != '\uffff') {
            return c;
        }
        return '\u0000';
    }

    public TimeZone getTimeZone() {
        TimeZone tz = (TimeZone)this._bean.getProperty(RequestContextBean.TIME_ZONE_KEY);
        if (tz != null) {
            return tz;
        }
        return TimeZone.getDefault();
    }

    public ChangeManager getChangeManager() {
        FacesContext context = this.__getFacesContext();
        Map appMap = context.getExternalContext().getApplicationMap();
        ChangeManager changeManager = (ChangeManager)appMap.get(_CHANGE_MANAGER_KEY);
        if (changeManager == null) {
            changeManager = this._createChangeManager();
            appMap.put(_CHANGE_MANAGER_KEY, changeManager);
        }
        return changeManager;
    }

    private ChangeManager _createChangeManager() {
        FacesContext context = this.__getFacesContext();
        String changeManager = context.getExternalContext().getInitParameter(_CHANGE_PERSISTENCE_INIT_PARAM);
        if (changeManager != null) {
            if ("session".equalsIgnoreCase(changeManager)) {
                _LOG.info("HTTPSESSION_USED_FOR_CHANGE_PERSISTENCE");
                return new SessionChangeManager();
            }
            return this._createChangeManager(changeManager);
        }
        return new NullChangeManager();
    }

    private ChangeManager _createChangeManager(String className) {
        try {
            Class managerClass = ClassLoaderUtils.loadClass((String)className);
            return (ChangeManager)managerClass.newInstance();
        }
        catch (Throwable throwable) {
            _LOG.warning("CHANGE_MANAGER_CREATION_FAILED", (Object)className);
            _LOG.warning(throwable);
            return new NullChangeManager();
        }
    }

    public RegionManager getRegionManager() {
        FacesContext context = this.__getFacesContext();
        return RegionMetadata.getRegionMetadata(context);
    }

    public String getCurrencyCode() {
        return (String)this._bean.getProperty(RequestContextBean.CURRENCY_CODE_KEY);
    }

    public String getOracleHelpServletUrl() {
        return (String)this._bean.getProperty(RequestContextBean.ORACLE_HELP_SERVLET_URL_KEY);
    }

    public boolean isRightToLeft() {
        Boolean b = (Boolean)this._bean.getProperty(RequestContextBean.RIGHT_TO_LEFT_KEY);
        if (b != null) {
            return b;
        }
        FacesContext fContext = this.__getFacesContext();
        if (fContext != null && fContext.getViewRoot() != null) {
            Locale locale = fContext.getViewRoot().getLocale();
            return LocaleUtils.getReadingDirectionForLocale(locale) == 2;
        }
        return false;
    }

    public Locale getFormattingLocale() {
        Object o = this._bean.getProperty(RequestContextBean.FORMATTING_LOCALE_KEY);
        if (o == null) {
            return null;
        }
        if (o instanceof Locale) {
            return (Locale)o;
        }
        if (o instanceof String) {
            o = ((String)o).replace('_', '-');
        }
        return LocaleUtils.getLocaleForIANAString(o.toString());
    }

    public Map<String, Object> getHelpTopic() {
        HelpProvider provider = this._getHelpProvider();
        if (provider == null) {
            return null;
        }
        return provider.getHelpTopicMap();
    }

    public Map<String, Object> getHelpSystem() {
        HelpProvider provider = this._getHelpProvider();
        if (provider == null) {
            return null;
        }
        return provider.getHelpSystemMap();
    }

    public void addPartialTarget(UIComponent newTarget) {
        FacesContext fContext = this.__getFacesContext();
        RenderingContext afContext = RenderingContext.getCurrentInstance();
        PartialPageContext pContext = null;
        if (afContext != null) {
            pContext = afContext.getPartialPageContext();
        }
        newTarget = this._getNearestPPRTarget(newTarget);
        Object savedKey = null;
        if (newTarget instanceof UIXCollection && (savedKey = ((UIXCollection)newTarget).getRowKey()) != null) {
            ((UIXCollection)newTarget).setRowKey(null);
        }
        String clientId = newTarget.getClientId(fContext);
        if (savedKey != null) {
            ((UIXCollection)newTarget).setRowKey(savedKey);
        }
        _LOG.finer("Adding partial target: {0}", (Object)newTarget);
        if (pContext != null) {
            pContext.addPartialTarget(clientId);
        } else {
            this._partialTargets.add(clientId);
        }
    }

    public void addPartialTargets(UIComponent from, String ... targets) {
        if (targets == null) {
            return;
        }
        for (String target : targets) {
            UIComponent component = ComponentUtils.findRelativeComponent((UIComponent)from, (String)target);
            if (component == null) continue;
            this.addPartialTarget(component);
        }
    }

    public void addPartialTriggerListeners(UIComponent listener, String[] triggers) {
        if (listener == null || triggers == null) {
            return;
        }
        Map<UIComponent, Set<UIComponent>> pl = this._getPartialListeners();
        for (int i = 0; i < triggers.length; ++i) {
            Set<UIComponent> listeners;
            String trigger = triggers[i];
            UIComponent master = ComponentUtils.findRelativeComponent((UIComponent)listener, (String)trigger);
            boolean deprecatedFind = false;
            if (master == null) {
                UIComponent from = listener;
                if (listener instanceof NamingContainer) {
                    from = listener.getParent();
                    master = ComponentUtils.findRelativeComponent((UIComponent)from, (String)trigger);
                    deprecatedFind = true;
                }
            }
            if (master == null) {
                _LOG.warning("CANNOT_FIND_PARTIAL_TRIGGER", new Object[]{trigger, listener});
                continue;
            }
            if (deprecatedFind) {
                _LOG.warning("DEPRECATED_TRIGGER_SYNTAX", new Object[]{trigger, listener});
            }
            if ((listeners = pl.get(master)) == null) {
                listeners = new HashSet<UIComponent>();
                pl.put(master, listeners);
            }
            listeners.add(listener);
        }
    }

    public void partialUpdateNotify(UIComponent updated) {
        if (updated != null) {
            this._addTargets(updated);
        }
    }

    public Iterator<String> getPartialTargets() {
        return this._partialTargets.iterator();
    }

    public Set<String> getPartialUpdates() {
        return this._partialTargets;
    }

    public Map<String, List<Color>> getColorPalette() {
        return ColorPaletteUtils.getColorPaletteMap();
    }

    public Map<Object, Map<Object, String>> getFormatter() {
        return FormatterMap.sharedInstance();
    }

    public int getTwoDigitYearStart() {
        Integer twoDigitYearStart = (Integer)this._bean.getProperty(RequestContextBean.TWO_DIGIT_YEAR_START);
        if (twoDigitYearStart != null) {
            return twoDigitYearStart;
        }
        return 1950;
    }

    public Agent getAgent() {
        if (this._agent == null) {
            Agent agent = _agentFactory.createAgent(this.__getFacesContext());
            TrinidadAgentImpl fAgent = new TrinidadAgentImpl(this.__getFacesContext(), agent);
            this._agent = fAgent;
        }
        return this._agent;
    }

    public Object saveComponent(UIComponent component) {
        return StateManagerImpl.saveComponentTree(this.__getFacesContext(), component);
    }

    public UIComponent restoreComponent(Object state) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        return StateManagerImpl.restoreComponentTree(this.__getFacesContext(), state);
    }

    void __setPageResolver(PageResolver pageResolver) {
        this._pageResolver = pageResolver;
    }

    void __setPageFlowScopeProvider(PageFlowScopeProvider pageFlowScopeProvider) {
        this._pageFlowScopeProvider = pageFlowScopeProvider;
    }

    int __getPageFlowScopeLifetime() {
        Integer lifetimeObj = (Integer)this._bean.getProperty(RequestContextBean.PAGE_FLOW_SCOPE_LIFETIME_KEY);
        if (lifetimeObj == null) {
            return 15;
        }
        return lifetimeObj;
    }

    private void _addTargets(Object key) {
        Map<UIComponent, Set<UIComponent>> pl = this._getPartialListeners();
        Set<UIComponent> listeners = pl.get(key);
        if (listeners != null) {
            pl.remove(key);
            for (UIComponent listener : listeners) {
                this.addPartialTarget(listener);
                this.partialUpdateNotify(listener);
            }
        }
    }

    private HelpProvider _getHelpProvider() {
        String url;
        if (this._provider == null && (url = this.getOracleHelpServletUrl()) != null) {
            this._provider = new OracleHelpProvider(url);
        }
        return this._provider;
    }

    FacesContext __getFacesContext() {
        FacesContext fContext = FacesContext.getCurrentInstance();
        if (fContext == null) {
            fContext = TrinidadFilterImpl.getPseudoFacesContext();
        }
        return fContext;
    }

    private UIComponent _getNearestPPRTarget(UIComponent component) {
        while (component.getRendererType() == null) {
            component = component.getParent();
        }
        return component;
    }

    private UIXCookie _getUIXCookie() {
        FacesContext fContext = this.__getFacesContext();
        if (fContext == null) {
            return null;
        }
        Object request = fContext.getExternalContext().getRequest();
        Object response = fContext.getExternalContext().getResponse();
        if (request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
            return UIXCookie.getUIXCookie((HttpServletRequest)request, (HttpServletResponse)response);
        }
        return null;
    }

    private Map<UIComponent, Set<UIComponent>> _getPartialListeners() {
        if (this._partialListeners == null) {
            this._partialListeners = new HashMap<UIComponent, Set<UIComponent>>();
        }
        return this._partialListeners;
    }

    static {
        _ACCESSIBILITY_NAMES.put("default", RequestContext.Accessibility.DEFAULT);
        _ACCESSIBILITY_NAMES.put("inaccessible", RequestContext.Accessibility.INACCESSIBLE);
        _ACCESSIBILITY_NAMES.put("screenReader", RequestContext.Accessibility.SCREEN_READER);
        _LOG = TrinidadLogger.createTrinidadLogger(RequestContextImpl.class);
    }
}

