/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.image.encode;

import java.awt.image.RGBImageFilter;

class AlphaMultiplyFilter
extends RGBImageFilter {
    private static final int _BYTE_MASK = 255;
    private static final int _OPAQUE = 255;
    private static final int _VALUE_THRESHHOLD = 220;
    private int _red;
    private int _green;
    private int _blue;

    public AlphaMultiplyFilter(int rgb) {
        this.canFilterIndexColorModel = true;
        this._red = rgb >> 16 & 0xFF;
        this._green = rgb >> 8 & 0xFF;
        this._blue = rgb & 0xFF;
    }

    public int filterRGB(int x, int y, int rgb) {
        int value;
        int alpha = rgb >> 24 & 0xFF;
        double opacity = (double)alpha / 255.0;
        double transparency = 1.0 - opacity;
        int red = rgb >> 16 & 0xFF;
        int green = rgb >> 8 & 0xFF;
        int blue = rgb & 0xFF;
        red = (int)((double)red * opacity + (double)this._red * transparency);
        green = (int)((double)green * opacity + (double)this._green * transparency);
        blue = (int)((double)blue * opacity + (double)this._blue * transparency);
        if (alpha < 100 && alpha > 0 && (value = Math.max(red, Math.max(green, blue))) > 220) {
            alpha = 0;
        }
        int retVal = alpha << 24 | red << 16 | green << 8 | blue;
        return retVal;
    }
}

