/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.image.util;

import java.awt.Polygon;
import java.awt.Rectangle;
import org.apache.myfaces.trinidad.util.IntegerUtils;

public class MapArea {
    public static final String RECTANGLE_SHAPE = "rect";
    public static final String POLYGON_SHAPE = "poly";
    private String _shape;
    private String _coords;
    private static final char _SEPARATOR = ',';

    public MapArea(String shape, int[] coordinates) {
        this._init(shape, coordinates);
    }

    public MapArea(String shape, String coordinatesString) {
        this._shape = shape;
        this._coords = coordinatesString;
    }

    public MapArea(Rectangle rectangle) {
        int[] coords = null;
        if (rectangle != null) {
            coords = new int[]{rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height};
        }
        this._init(RECTANGLE_SHAPE, coords);
    }

    public MapArea(Polygon polygon) {
        int[] coords = null;
        if (polygon != null && polygon.npoints != 0) {
            coords = new int[polygon.npoints * 2];
            for (int i = 0; i < polygon.npoints; ++i) {
                coords[i * 2] = polygon.xpoints[i];
                coords[i * 2 + 1] = polygon.ypoints[i];
            }
        }
        this._init(POLYGON_SHAPE, coords);
    }

    public String getShape() {
        return this._shape;
    }

    public String getCoordinatesString() {
        return this._coords;
    }

    private void _init(String shape, int[] coordinates) {
        this._shape = shape;
        if (coordinates == null) {
            return;
        }
        StringBuffer buffer = new StringBuffer(coordinates.length * 4);
        for (int i = 0; i < coordinates.length; ++i) {
            buffer.append(IntegerUtils.getString((int)coordinates[i]));
            if (i >= coordinates.length - 1) continue;
            buffer.append(',');
        }
        this._coords = buffer.toString();
    }
}

