/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import javax.faces.context.FacesContext;
import org.apache.myfaces.trinidad.context.AccessibilityProfile;
import org.apache.myfaces.trinidad.context.LocaleContext;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.skin.Icon;
import org.apache.myfaces.trinidad.skin.Skin;
import org.apache.myfaces.trinidadinternal.agent.TrinidadAgent;
import org.apache.myfaces.trinidadinternal.renderkit.core.CoreRenderingContext;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.HtmlRenderer;
import org.apache.myfaces.trinidadinternal.skin.SkinStyleProvider;
import org.apache.myfaces.trinidadinternal.style.StyleContext;
import org.apache.myfaces.trinidadinternal.style.StyleMap;
import org.apache.myfaces.trinidadinternal.style.StyleProvider;

class StyleContextImpl
implements StyleContext {
    private RenderingContext _arc;
    private String _generatedFilesPath;
    private StyleProvider _styleProvider;
    private StyleMap _styleMap;
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(StyleContextImpl.class);

    public StyleContextImpl(RenderingContext arc, String generatedFilesPath) {
        this._arc = arc;
        this._generatedFilesPath = generatedFilesPath;
        assert (this._arc.getAccessibilityProfile() != null);
    }

    public StyleProvider getStyleProvider() {
        if (this._styleProvider == null) {
            Skin skin = ((CoreRenderingContext)this._arc).getSkin();
            this._styleProvider = this._getDefaultStyleProvider(skin);
        }
        return this._styleProvider;
    }

    public StyleProvider getStyleProvider(boolean recompute) {
        if (recompute) {
            this._styleProvider = null;
        }
        return this.getStyleProvider();
    }

    public StyleMap getStyleMap() {
        if (this._styleMap == null) {
            this._styleMap = this.getStyleProvider().getStyleMap(this);
        }
        return this._styleMap;
    }

    public LocaleContext getLocaleContext() {
        return this._arc.getLocaleContext();
    }

    public String getGeneratedFilesPath() {
        return this._generatedFilesPath;
    }

    public TrinidadAgent getAgent() {
        return ((CoreRenderingContext)this._arc).getTrinidadAgent();
    }

    public boolean checkStylesModified() {
        FacesContext context = FacesContext.getCurrentInstance();
        String checkTimestamp = context.getExternalContext().getInitParameter("org.apache.myfaces.trinidad.CHECK_FILE_MODIFICATION");
        return "true".equals(checkTimestamp);
    }

    public boolean disableStandardsMode() {
        FacesContext fContext = FacesContext.getCurrentInstance();
        return HtmlRenderer.isStandardsModeDisabled(fContext);
    }

    public AccessibilityProfile getAccessibilityProfile() {
        return this._arc.getAccessibilityProfile();
    }

    private StyleProvider _getDefaultStyleProvider(Skin skin) {
        String cachePath = this._generatedFilesPath + "/adf/styles/cache/";
        try {
            return SkinStyleProvider.getSkinStyleProvider(skin, cachePath);
        }
        catch (RuntimeException e) {
            _LOG.severe("CANNOT_GET_STYLESHEET_CACHE", (Throwable)e);
            return NullStyleProvider.getInstance();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NullStyleProvider
    implements StyleProvider {
        private static StyleProvider _sInstance;

        private NullStyleProvider() {
        }

        public static StyleProvider getInstance() {
            if (_sInstance == null) {
                _sInstance = new NullStyleProvider();
            }
            return _sInstance;
        }

        @Override
        public String getContentStyleType(StyleContext context) {
            return null;
        }

        @Override
        public Map<String, String> getShortStyleClasses(StyleContext context) {
            return null;
        }

        @Override
        public List<String> getStyleSheetURIs(StyleContext context) {
            return null;
        }

        @Override
        public StyleMap getStyleMap(StyleContext context) {
            return null;
        }

        @Override
        public ConcurrentMap<String, Icon> getIcons(StyleContext context) {
            return null;
        }

        @Override
        public ConcurrentMap<Object, Object> getSkinProperties(StyleContext context) {
            return null;
        }
    }
}

