/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.pages;

import java.io.IOException;
import java.util.Date;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.trinidad.component.core.CoreDocument;
import org.apache.myfaces.trinidad.component.core.CoreForm;
import org.apache.myfaces.trinidad.component.core.CoreImportScript;
import org.apache.myfaces.trinidad.component.core.input.CoreChooseDate;
import org.apache.myfaces.trinidad.component.core.layout.CorePanelGroupLayout;
import org.apache.myfaces.trinidad.component.core.nav.CoreGoButton;
import org.apache.myfaces.trinidad.component.core.output.CoreSpacer;
import org.apache.myfaces.trinidad.component.html.HtmlRowLayout;
import org.apache.myfaces.trinidad.component.html.HtmlTableLayout;
import org.apache.myfaces.trinidad.context.Agent;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.context.RequestContext;
import org.apache.myfaces.trinidadinternal.agent.TrinidadAgent;
import org.apache.myfaces.trinidadinternal.renderkit.core.pages.CalendarUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.pages.GenericEntry;
import org.apache.myfaces.trinidadinternal.renderkit.core.pages.JspUtils;
import org.apache.myfaces.trinidadinternal.share.url.EncoderUtils;

class CalendarDialogJSP {
    private static final String _CANCEL_LABEL_KEY = "af_chooseDate.CANCEL";
    private static final String _DIALOG_TITLE_KEY = "af_chooseDate.DIALOG_TITLE";

    CalendarDialogJSP() {
    }

    public static void service(FacesContext context) throws IOException {
        RenderingContext arc = RenderingContext.getCurrentInstance();
        CoreDocument doc = new CoreDocument();
        context.getViewRoot().getChildren().add(doc);
        doc.setTitle(arc.getTranslatedString(_DIALOG_TITLE_KEY));
        CoreForm form = new CoreForm();
        doc.getChildren().add(form);
        form.setId("a");
        boolean isDesktop = arc.getAgent().getType().equals(Agent.TYPE_DESKTOP);
        UIComponent calendarRow = CalendarDialogJSP._createRow(isDesktop, "end");
        CoreChooseDate ccd = CalendarUtils.createChooseDate(context);
        calendarRow.getChildren().add(ccd);
        String destination = GenericEntry.getGenericEntryURL(context, "cd");
        ccd.getAttributes().put("destination", destination);
        UIComponent spacerRow = CalendarDialogJSP._createRow(isDesktop, null);
        CoreSpacer cos = new CoreSpacer();
        spacerRow.getChildren().add(cos);
        cos.setHeight("8");
        UIComponent buttonRow = CalendarDialogJSP._createRow(isDesktop, "end");
        CoreGoButton cancelButton = JspUtils.createGoButton(arc, _CANCEL_LABEL_KEY);
        buttonRow.getChildren().add(cancelButton);
        Object cap = arc.getAgent().getCapabilities().get(TrinidadAgent.CAP_MULTIPLE_WINDOWS);
        boolean multWindowsSupported = Boolean.TRUE.equals(cap);
        if (multWindowsSupported) {
            cancelButton.setOnclick("return _doCancel()");
        } else {
            StringBuffer cancelDest = new StringBuffer();
            EncoderUtils.appendURLArguments(cancelDest, destination, new String[]{"event", "cancel"});
            cancelButton.setDestination("/" + cancelDest.toString());
            String value = CalendarDialogJSP.__getParam(context, "value");
            if (value != null) {
                long lg = Long.parseLong(value);
                ccd.getAttributes().put("value", new Date(lg));
            }
            String month = CalendarDialogJSP.__getParam(context, "month");
            String year = CalendarDialogJSP.__getParam(context, "year");
            if (month != null && year != null) {
                try {
                    long scrolledValue = Long.parseLong(month) + Long.parseLong(year);
                    ccd.getAttributes().put("scrolledValue", new Date(scrolledValue));
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
        }
        if (multWindowsSupported) {
            CoreImportScript cis = new CoreImportScript();
            cis.setNames(new String[]{"_doCancel()", "_selectDate()"});
            doc.getFacets().put("metaContainer", cis);
            HtmlTableLayout htl = new HtmlTableLayout();
            form.getChildren().add(htl);
            htl.getChildren().add(calendarRow);
            htl.getChildren().add(spacerRow);
            htl.getChildren().add(buttonRow);
        } else {
            CorePanelGroupLayout cpg = new CorePanelGroupLayout();
            form.getChildren().add(cpg);
            cpg.setLayout("vertical");
            cpg.getChildren().add(calendarRow);
            cpg.getChildren().add(spacerRow);
            cpg.getChildren().add(buttonRow);
        }
    }

    public static boolean processReturnDialog(FacesContext context) {
        Map requestParameters = context.getExternalContext().getRequestParameterMap();
        String event = (String)requestParameters.get("event");
        if ("date".equals(event)) {
            Date date;
            String value = (String)requestParameters.get("value");
            try {
                long millis = Long.parseLong(value);
                date = new Date(millis);
            }
            catch (NumberFormatException nfe) {
                date = new Date();
            }
            RequestContext afContext = RequestContext.getCurrentInstance();
            afContext.returnFromDialog((Object)date, null);
            return true;
        }
        if ("cancel".equals(event)) {
            RequestContext afContext = RequestContext.getCurrentInstance();
            afContext.returnFromDialog(null, null);
            return true;
        }
        return false;
    }

    static String __getParam(FacesContext context, String name) {
        RequestContext afContext;
        Object o;
        Map requestParams = context.getExternalContext().getRequestParameterMap();
        String value = (String)requestParams.get(name);
        if ((value == null || value.equals("")) && (o = (afContext = RequestContext.getCurrentInstance()).getPageFlowScope().get(name)) != null) {
            value = o.toString();
        }
        return value;
    }

    private static UIComponent _createRow(boolean isDesktop, String halign) {
        if (!isDesktop) {
            return new CorePanelGroupLayout();
        }
        HtmlRowLayout hrl = new HtmlRowLayout();
        if (halign != null) {
            hrl.setHalign(halign);
        }
        return hrl;
    }
}

