/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.ppr;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.context.PartialPageContext;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.render.ExtendedRenderKitService;
import org.apache.myfaces.trinidad.util.Service;
import org.apache.myfaces.trinidadinternal.renderkit.core.pages.GenericEntry;
import org.apache.myfaces.trinidadinternal.renderkit.core.ppr.PartialPageContextImpl;
import org.apache.myfaces.trinidadinternal.renderkit.core.ppr.ScriptBufferingResponseWriter;
import org.apache.myfaces.trinidadinternal.renderkit.core.ppr.XmlResponseWriter;

public class PPRResponseWriter
extends ScriptBufferingResponseWriter {
    private State _state;
    private ResponseWriter _xml;
    private final FacesContext _facesContext = FacesContext.getCurrentInstance();
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(PPRResponseWriter.class);

    public PPRResponseWriter(ResponseWriter out, RenderingContext rc) {
        super(out);
        PartialPageContext pprContext = rc.getPartialPageContext();
        if (!(pprContext instanceof PartialPageContextImpl)) {
            throw new IllegalArgumentException();
        }
        this._state = new State((PartialPageContextImpl)pprContext);
        this._xml = new XmlResponseWriter((Writer)out, out.getCharacterEncoding());
    }

    PPRResponseWriter(ResponseWriter out, PPRResponseWriter base) {
        super(out, base);
        this._xml = new XmlResponseWriter((Writer)out, out.getCharacterEncoding());
        this._state = base._state;
    }

    public ResponseWriter cloneWithWriter(Writer writer) {
        PPRResponseWriter ppr = new PPRResponseWriter(this.getResponseWriter().cloneWithWriter(writer), this);
        this._state.forceInsideTarget = this._state.documentStarted && this._state.elementDepth == 0;
        return ppr;
    }

    public void startDocument() throws IOException {
        this._state.documentStarted = true;
        this._state.documentStarting = true;
        this._xml.startDocument();
        super.write("<?Tr-XHR-Response-Type ?>\n");
        this._xml.startElement("content", null);
        String viewId = this._facesContext.getViewRoot().getViewId();
        if (!GenericEntry.getViewId().equals(viewId)) {
            String actionURL = this._facesContext.getApplication().getViewHandler().getActionURL(this._facesContext, viewId);
            ExternalContext external = this._facesContext.getExternalContext();
            this._xml.writeURIAttribute("action", (Object)external.encodeActionURL(actionURL), null);
        }
        this._xml.writeText((Object)" ", null);
        this._state.documentStarting = false;
    }

    public void endDocument() throws IOException {
        this.writeBufferedScripts();
        this.writeFrameworkScripts();
        this._xml.endElement("content");
        this._xml.endDocument();
        this._state.forceInsideTarget = true;
    }

    public void writeComment(Object text) throws IOException {
        if (this._isInsideTarget()) {
            super.writeComment(text);
        }
    }

    public void writeText(Object text, String property) throws IOException {
        if (this._isInsideTarget()) {
            super.writeText(text, property);
        }
    }

    public void writeText(char[] text, int start, int length) throws IOException {
        if (this._isInsideTarget()) {
            super.writeText(text, start, length);
        }
    }

    public void write(String text) throws IOException {
        this._disableIfNeeded();
        if (this._isInsideTarget()) {
            super.write(text);
        }
    }

    public void write(char[] text, int start, int length) throws IOException {
        this._disableIfNeeded();
        if (this._isInsideTarget()) {
            super.write(text, start, length);
        }
    }

    public void write(int ch) throws IOException {
        if (this._isInsideTarget()) {
            super.write(ch);
        }
    }

    public void write(char[] c) throws IOException {
        this._disableIfNeeded();
        if (this._isInsideTarget()) {
            super.write(c);
        }
    }

    public void write(String text, int off, int len) throws IOException {
        this._disableIfNeeded();
        if (this._isInsideTarget()) {
            super.write(text, off, len);
        }
    }

    public void startElement(String name, UIComponent component) throws IOException {
        ++this._state.elementDepth;
        this._pushPartialTarget(component, name);
        if (this._isInsideTarget()) {
            if (_LOG.isFinest()) {
                _LOG.finest("PPR: Using element {0} in component {1}", new Object[]{name, component});
            }
            super.startElement(name, component);
        } else if (_LOG.isFinest()) {
            _LOG.finest("PPR: Ignoring element {0} in component {1}", new Object[]{name, component});
        }
    }

    public void endElement(String name) throws IOException {
        --this._state.elementDepth;
        if (this._isInsideTarget()) {
            super.endElement(name);
        }
        this._popPartialTarget(name);
        super.flush();
    }

    public void writeAttribute(String name, Object value, String property) throws IOException {
        if (value == null) {
            return;
        }
        if (this._isInsideTarget()) {
            this._handleIdAttribute(name, value);
            super.writeAttribute(name, value, property);
        }
    }

    public void writeURIAttribute(String name, Object value, String property) throws IOException {
        if (this._isInsideTarget()) {
            this._handleIdAttribute(name, value);
            super.writeURIAttribute(name, value, property);
        }
    }

    protected ResponseWriter getXmlResponseWriter() {
        return this._xml;
    }

    protected void writeBufferedScripts() throws IOException {
        List<String> scripts;
        List<String> libraries = this.getBufferedLibraries();
        if (libraries != null) {
            for (String library : libraries) {
                this._xml.startElement("script-library", null);
                this._xml.writeText((Object)library, null);
                this._xml.endElement("script-library");
            }
        }
        if ((scripts = this.getBufferedScripts()) != null) {
            for (String script : scripts) {
                this._xml.startElement("script", null);
                this._xml.write("<![CDATA[");
                this._xml.write(script);
                this._xml.write("]]>");
                this._xml.endElement("script");
            }
        }
        this.clearBufferedContents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeFrameworkScripts() throws IOException {
        ResponseWriter old = this._facesContext.getResponseWriter();
        this._facesContext.setResponseWriter(this._xml);
        try {
            ExtendedRenderKitService erks = (ExtendedRenderKitService)Service.getService((Object)this._facesContext.getRenderKit(), ExtendedRenderKitService.class);
            if (erks != null) {
                erks.encodeScripts(this._facesContext);
            }
        }
        finally {
            this._facesContext.setResponseWriter(old);
        }
    }

    private void _pushPartialTarget(UIComponent component, String elementName) throws IOException {
        String clientId;
        PPRTag tag = null;
        if (!this._isInsideTarget() && component != null && this._state.pprContext.isPartialTarget(clientId = component.getClientId(this._facesContext))) {
            tag = new PPRTag(clientId);
            this._state.enteringPPR = component;
        }
        if (tag != null) {
            super.flush();
            tag.start(this._state.pprContext, elementName);
        }
        this._state.componentStack.add(tag);
    }

    private void _popPartialTarget(String elementName) throws IOException {
        List<PPRTag> componentStack = this._state.componentStack;
        int pos = componentStack.size() - 1;
        PPRTag tag = componentStack.get(pos);
        componentStack.remove(pos);
        if (tag != null) {
            tag.finish(this._state.pprContext, elementName);
        }
    }

    private boolean _isInsideTarget() {
        return this._state.forceInsideTarget || this._state.pprContext.isInsidePartialTarget();
    }

    private void _disableIfNeeded() {
        if (this._state.documentStarting) {
            this._state = new State(this._state.pprContext);
            this._state.forceInsideTarget = true;
        }
    }

    private void _handleIdAttribute(String name, Object value) {
        if (this._state.enteringPPR != null && "id".equals(name)) {
            if (_LOG.isFine()) {
                _LOG.fine("Using id {1} for element of {0}", new Object[]{this._state.enteringPPR, value});
            }
            this._state.pprContext.addRenderedPartialTarget(value.toString());
            this._state.enteringPPR = null;
        }
    }

    private static class State {
        public UIComponent enteringPPR;
        public boolean forceInsideTarget;
        public int elementDepth;
        public boolean documentStarted;
        public boolean documentStarting;
        public final List<PPRTag> componentStack = new ArrayList<PPRTag>(50);
        public final PartialPageContextImpl pprContext;

        public State(PartialPageContextImpl pprContext) {
            this.pprContext = pprContext;
        }
    }

    private class PPRTag {
        private String _id;

        public PPRTag(String id) {
            this._id = id;
        }

        public void start(PartialPageContextImpl pprContext, String elementName) throws IOException {
            if (this._id != null) {
                pprContext.pushRenderedPartialTarget(this._id);
                PPRResponseWriter.this._xml.startElement("fragment", null);
                PPRResponseWriter.this._xml.write("<![CDATA[");
                PPRResponseWriter.this._xml.flush();
                if (_LOG.isFine()) {
                    _LOG.fine("Entering partial target id {0}", (Object)this._id);
                }
                this._startWrapperElements(elementName);
            }
        }

        public void finish(PartialPageContextImpl pprContext, String elementName) throws IOException {
            if (this._id != null) {
                if (((PPRResponseWriter)PPRResponseWriter.this)._state.enteringPPR != null) {
                    _LOG.warning("NO_PPR_CAPABLE_ID_FOUND_FOR_COMPONENT", (Object)((PPRResponseWriter)PPRResponseWriter.this)._state.enteringPPR);
                    ((PPRResponseWriter)PPRResponseWriter.this)._state.enteringPPR = null;
                }
                this._endWrapperElements(elementName);
                PPRResponseWriter.super.flush();
                PPRResponseWriter.this._xml.write("]]>");
                PPRResponseWriter.this._xml.endElement("fragment");
                PPRResponseWriter.this._xml.flush();
                pprContext.popRenderedPartialTarget();
                _LOG.finer("Leaving partial target id {0}", (Object)this._id);
            }
        }

        private void _startWrapperElements(String elementName) throws IOException {
            boolean isTR = "tr".equalsIgnoreCase(elementName);
            boolean isTD = "td".equalsIgnoreCase(elementName);
            if (isTR || isTD) {
                PPRResponseWriter.super.startElement("table", null);
                if (isTD) {
                    PPRResponseWriter.super.startElement("tr", null);
                }
            }
        }

        private void _endWrapperElements(String elementName) throws IOException {
            boolean isTR = "tr".equalsIgnoreCase(elementName);
            boolean isTD = "td".equalsIgnoreCase(elementName);
            if (isTR || isTD) {
                if (isTD) {
                    PPRResponseWriter.super.endElement("tr");
                }
                PPRResponseWriter.super.endElement("table");
            }
        }
    }
}

