/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.ppr;

import java.io.IOException;
import java.io.Writer;
import javax.faces.component.UIComponent;
import javax.faces.context.ResponseWriter;

public class XmlResponseWriter
extends ResponseWriter {
    private final Writer _out;
    private final String _encoding;
    private boolean _closeStart;

    public XmlResponseWriter(Writer writer, String encoding) {
        this._out = writer;
        this._encoding = encoding;
    }

    public String getCharacterEncoding() {
        return this._encoding;
    }

    public String getContentType() {
        return "text/xml";
    }

    public void startDocument() throws IOException {
        this._out.write("<?xml version=\"1.0\" ?>\n");
    }

    public void endDocument() throws IOException {
    }

    public void startElement(String name, UIComponent component) throws IOException {
        this.closeStartIfNecessary();
        Writer out = this._out;
        out.write(60);
        out.write(name);
        this._closeStart = true;
    }

    public void writeAttribute(String name, Object value, String attrName) throws IOException {
        if (value == null) {
            return;
        }
        Writer out = this._out;
        out.write(32);
        out.write(name);
        out.write("=\"");
        this.writeAttributeText(value, attrName);
        out.write("\"");
    }

    public void writeComment(Object comment) throws IOException {
        if (comment != null) {
            this.closeStartIfNecessary();
            Writer out = this._out;
            out.write("<!-- ");
            out.write(comment.toString());
            out.write(" -->");
        }
    }

    public void writeText(char[] buffer, int offset, int length) throws IOException {
        if (buffer != null) {
            this.closeStartIfNecessary();
            this._writeBodyText(buffer, offset, length);
        }
    }

    public void writeText(Object text, String attrName) throws IOException {
        if (text != null) {
            this.closeStartIfNecessary();
            this.writeBodyText(text, attrName);
        }
    }

    public void writeURIAttribute(String name, Object value, String attrName) throws IOException {
        this.writeAttribute(name, value, attrName);
    }

    public void endElement(String name) throws IOException {
        Writer out = this._out;
        if (this._closeStart) {
            out.write("/>");
            this._closeStart = false;
        } else {
            out.write("</");
            out.write(name);
            out.write(">");
        }
    }

    public ResponseWriter cloneWithWriter(Writer writer) {
        return new XmlResponseWriter(writer, this.getCharacterEncoding());
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        this.closeStartIfNecessary();
        this._out.write(cbuf, off, len);
    }

    public void write(char[] cbuf) throws IOException {
        this.closeStartIfNecessary();
        this._out.write(cbuf);
    }

    public void write(int c) throws IOException {
        this.closeStartIfNecessary();
        this._out.write(c);
    }

    public void write(String str) throws IOException {
        this.closeStartIfNecessary();
        this._out.write(str);
    }

    public void write(String str, int off, int len) throws IOException {
        this.closeStartIfNecessary();
        this._out.write(str, off, len);
    }

    public void close() throws IOException {
        this._out.close();
    }

    public void flush() throws IOException {
        this._out.flush();
    }

    protected void writeAttributeText(Object text, String attrName) throws IOException {
        char[] buffer = text.toString().toCharArray();
        this._writeAttributeText(buffer, 0, buffer.length);
    }

    protected void writeBodyText(Object text, String attrName) throws IOException {
        char[] buffer = text.toString().toCharArray();
        this._writeBodyText(buffer, 0, buffer.length);
    }

    protected void closeStartIfNecessary() throws IOException {
        if (this._closeStart) {
            Writer out = this._out;
            out.write(62);
            this._closeStart = false;
        }
    }

    private void _writeAttributeText(char[] text, int start, int length) throws IOException {
        Writer out = this._out;
        int end = start + length;
        for (int i = start; i < end; ++i) {
            char ch = text[i];
            if (ch <= '\u007f') {
                switch (ch) {
                    case '>': {
                        out.write("&gt;");
                        break;
                    }
                    case '<': {
                        out.write("&lt;");
                        break;
                    }
                    case '\"': {
                        out.write("&quot;");
                        break;
                    }
                    case '&': {
                        out.write("&amp;");
                        break;
                    }
                    default: {
                        out.write(ch);
                        break;
                    }
                }
                continue;
            }
            this._writeHexRef(ch);
        }
    }

    private void _writeBodyText(char[] text, int start, int length) throws IOException {
        Writer out = this._out;
        int end = start + length;
        for (int i = start; i < end; ++i) {
            char ch = text[i];
            if (ch <= '\u007f') {
                switch (ch) {
                    case '>': {
                        out.write("&gt;");
                        break;
                    }
                    case '<': {
                        out.write("&lt;");
                        break;
                    }
                    case '&': {
                        out.write("&amp;");
                        break;
                    }
                    default: {
                        out.write(ch);
                        break;
                    }
                }
                continue;
            }
            this._writeHexRef(ch);
        }
    }

    private void _writeHexRef(char ch) throws IOException {
        Writer out = this._out;
        out.write("&#x");
        out.write(Integer.toHexString(ch));
        out.write(59);
    }
}

